/*
 * $Id: SimpleDateValidator.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 作成日: 2006/03/09
 */
package feat2.validation;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;

import feat2.config.ConfigurationException;

/**
 * SimpleDateFormatのパターンに従って日付の検証をする。
 * 一つの入力文字列値を指定されたパターンで解釈する。
 * SimpleDateFormatのlenientモードで検証する。
 * @author SUGIMOTO Ken-ichi
 */
public class SimpleDateValidator implements SingleValueValidator {

    private SimpleDateFormat format;


    public boolean validate(String value) {

        if ( format == null )
            throw new ConfigurationException("exception.validator.simpledate.format");

        if ( ValidatorUtil.isBlankOrNull(value) )
            return true;

        try {
            format.parse(value);
        }
        catch (ParseException ex) {
            return false;
        }

        return true;
    }


    public void setPattern(String pattern) {
        format = new SimpleDateFormat(pattern);
        format.setLenient(true);
    }

    public String getDefaultMessageId() {
        return "error.validation.simpledate";
    }

    public Map getKeyrowds() {
        return null;
    }

}
