/*
 * $Revision: 223 $ $Date: 2007-10-14 17:07:40 +0900 $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 */

package feat2.xmlcommand;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

import feat2.impl.XMLWriter;

public class XMLCommandProcessor {

    private Log log = LogFactory.getLog(XMLCommandProcessor.class);

    private String requestObjectAttributeName = "feat2_xmlcommand_request";


    public XMLCommandProcessor() {
    }


    public String[] process(HttpServletRequest req, HttpServletResponse resp) throws IOException {

        try {
            try {

                // リクエストのXMLをバイト配列に入れる
                // このステップはデバッグ表示のためだけなので、デバッグ表示が必要なくなったら
                // HttpServletRequestのInputStreamを直接パーサに渡したほうが効率が良くなる

                InputStream is = req.getInputStream();
                ByteArrayOutputStream os = new ByteArrayOutputStream(8192);
                int size = 0;
                byte[] buf = new byte[8192];
                while ( (size = is.read(buf)) > 0 ) {
                    os.write(buf, 0, size);
                }
                os.close();
                is.close();

                byte[] requestXML = os.toByteArray();

                log.debug("-- request --\n" + new String(requestXML, "UTF-8"));

                // リクエストのXMLをパースする

                is = new ByteArrayInputStream(requestXML);
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                ObjectHandler handler = new ObjectHandler();
                parser.parse(is, handler);
                Map o = handler.getObject();
                req.setAttribute(requestObjectAttributeName, o);

                String[] ret = new String[] {handler.getFeatureName(), handler.getCommandName()};

                return ret;

            }
            catch (SAXException ex) {
                ex.printStackTrace();
                throw new ClientException(ex.getMessage(), "fatal");
            }
            catch (ParserConfigurationException ex) {
                ex.printStackTrace();
                throw new ClientException(ex.getMessage(), "fatal");
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                throw new ClientException(ex.getMessage(), "fatal");
            }
        }
        catch(ClientException ex) {

            XMLWriter w = new XMLWriter();
            if ( ex.getClientMessage() != null ) {
                w.setError(ex.getErrorCode(), ex.getClientMessage());
            }
            else {
                w.setError(ex.getErrorCode());
            }
            String ret = w.toString();
            log.debug("-- response --\n" + ret);
            resp.getOutputStream().write(ret.getBytes("UTF-8"));

        }

        return new String[2];

    }

}
