/*
 * $Id: SendMessage.java 223 2007-10-14 08:07:40Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日： 2005/03/11
 */
package feat2.testapp.flash;

import feat2.CommandContext;
import feat2.Effector;
import feat2.xmlcommand.ClientException;

/**
 * チャットメッセージの送信。
 * @author SUGIMOTO
 */
public class SendMessage implements Effector {

    private String username;
    private String message;


    public Object execute(CommandContext ctx) throws Exception {

        if ( username != null && username.length() > 10 )
            username = username.substring(0, 10);
        if ( message != null && message.length() > 50 )
            message = message.substring(0, 50);

        ChatMessage m = new ChatMessage(username, message);
        ChatLog.addMessage(m);

        if ( m.getUsername().equals("exception") ) {
            throw new ClientException("user error", "fatal", message);
        }

        return null;

    }


    public String getMessage() {
        return message;
    }
    public void setMessage(String message) {
        this.message = message;
    }
    public String getUsername() {
        return username;
    }
    public void setUsername(String username) {
        this.username = username;
    }

}
