/*
 * $Id: TimeKeeper.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2004-2006 SUGIMOTO Ken-ichi
 * 作成日: 2006/04/23
 */
package feat2.testapp.test8;

import feat2.CommandContext;
import feat2.Interceptor;
import feat2.impl.Command;

public class TimeKeeper implements Interceptor {

    private long start;

    public void before(Command command, CommandContext ctx) {
        start = System.currentTimeMillis();
    }

    public void after(Command command, CommandContext ctx) {
        long elapse = System.currentTimeMillis() - start;
        ctx.getRequest().setAttribute("elapse", new Long(elapse));
    }

}
