lang ja_JP.UTF-8
keyboard jp106
timezone Asia/Tokyo
selinux --permissive
auth --useshadow --enablemd5
firewall --enabled
xconfig --startxonboot

repo --name=fedora --mirrorlist=http://mirrors.fedoraproject.org/mirrorlist?repo=fedora-10&arch=$basearch
repo --name=updates --mirrorlist=http://mirrors.fedoraproject.org/mirrorlist?repo=updates-released-f10&arch=$basearch

repo --name=adobe-linux-i386 --baseurl=http://linuxdownload.adobe.com/linux/i386/

repo --name=rpmfusion-free --mirrorlist=http://mirrors.rpmfusion.org/mirrorlist?repo=free-fedora-10&arch=$basearch
repo --name=rpmfusion-free-updates --mirrorlist=http://mirrors.rpmfusion.org/mirrorlist?repo=free-fedora-updates-released-10&arch=$basearch
repo --name=rpmfusion-nonfree --mirrorlist=http://mirrors.rpmfusion.org/mirrorlist?repo=nonfree-fedora-10&arch=$basearch
repo --name=rpmfusion-nonfree-updates --mirrorlist=http://mirrors.rpmfusion.org/mirrorlist?repo=nonfree-fedora-updates-released-10&arch=$basearch

%packages
ConsoleKit
ConsoleKit-libs
ConsoleKit-x11
GConf2
GConf2-gtk
MAKEDEV
NetworkManager
NetworkManager-glib
NetworkManager-gnome
#NetworkManager-openvpn
#NetworkManager-vpnc
ORBit2
#OpenEXR-libs
PackageKit
PackageKit-glib
PackageKit-gstreamer-plugin
PackageKit-udev-helper
PackageKit-yum
PackageKit-yum-plugin
PolicyKit
PolicyKit-gnome
PolicyKit-gnome-libs
SDL
VLGothic-fonts
VLGothic-fonts-proportional
#abiword
acl
#aiksaurus
#aiksaurus-gtk
alacarte
alsa-lib
alsa-plugins-pulseaudio
alsa-utils
anaconda
anaconda-yum-plugins
#anacron
anthy
apr
apr-util
#at
#at-spi
#at-spi-python
#atk
#atmel-firmware
#attr
audiofile
#audit
#audit-libs
#audit-libs-python
authconfig
authconfig-gtk
avahi
avahi-autoipd
avahi-compat-libdns_sd
avahi-glib
avahi-tools
#b43-fwcutter
#babl
#baekmuk-bdf-fonts
#baekmuk-ttf-fonts-batang
#baekmuk-ttf-fonts-common
#baekmuk-ttf-fonts-dotum
#baekmuk-ttf-fonts-gulim
#baekmuk-ttf-fonts-hline
basesystem
bash
bc
#bcm43xx-fwcutter
bind-libs
bind-utils
bitmap-fonts
bluecurve-cursor-theme
bluez
bluez-alsa
#bluez-cups
bluez-gnome
bluez-libs
booty
#bug-buddy
busybox-anaconda
bzip2
bzip2-libs
ca-certificates
cairo
cairomm
cdparanoia
cdparanoia-libs
cdrdao
checkpolicy
#cheese
chkconfig
#cjkunifonts-ukai
#cjkunifonts-uming
compat-db45
#compiz
#compiz-fusion
#compiz-fusion-gnome
#compiz-gnome
comps-extras
control-center
control-center-filesystem
coreutils
cpio
cpp
cpuspeed
cracklib
cracklib-dicts
cracklib-python
createrepo
#cronie
crontabs
cryptsetup-luks
#culmus-fonts
#cups
#cups-libs
curl
cyrus-sasl
cyrus-sasl-lib
cyrus-sasl-md5
cyrus-sasl-plain
db4
dbus
dbus-glib
dbus-libs
dbus-python
dbus-x11
dejavu-fonts
desktop-backgrounds-basic
desktop-file-utils
device-mapper
device-mapper-libs
device-mapper-multipath
dhclient
dhcpv6-client
diffutils
dirmngr
dmidecode
dmraid
dmraid-libs
dnsmasq
docbook-dtds
dos2unix
dosfstools
dump
dvd+rw-tools
e2fsprogs
e2fsprogs-libs
#ed
eel2
#efibootmgr
#eject
elfutils-libelf
enchant
#enchant-voikko
#enscript
#eog
#esound-libs
ethtool
#evince
#evolution
#evolution-data-server
#evolution-perl
#evolution-webcal
exempi
expat
fbset
fedora-bookmarks
fedora-gnome-theme
fedora-icon-theme
fedora-logos
fedora-release
fedora-release-notes
fedora-screensaver-theme
fedorainfinity-screensaver-theme
#festival
#festival-lib
#festival-speechtools-libs
#festvox-slt-arctic-hts
file
file-libs
file-roller
filesystem
findutils
#finger
firefox
firstboot
flac
fontconfig
#foomatic
freetype
#fribidi
#ftp
fuse
#fuse-libs
gamin
gamin-python
gawk
#gcalctool
#gdb
#gdbm
gdm
#gdm-user-switch-applet
#gedit
#gegl
genisoimage
#ghostscript
#ghostscript-fonts
#gimp
#gimp-libs
glib2
glibc
glibc-common
glibmm24
glx-utils
gmp
#gnome-applets
#gnome-audio
gnome-backgrounds
gnome-bluetooth
gnome-bluetooth-libs
gnome-desktop
gnome-doc-utils-stylesheets
gnome-icon-theme
gnome-keyring
gnome-keyring-pam
#gnome-mag
#gnome-media
gnome-menus
gnome-mime-data
gnome-mount
gnome-packagekit
#gnome-panel
#gnome-panel-libs
#gnome-pilot
gnome-power-manager
gnome-python2
gnome-python2-applet
gnome-python2-bonobo
gnome-python2-canvas
gnome-python2-desktop
gnome-python2-extras
gnome-python2-gconf
gnome-python2-gnome
gnome-python2-gnomevfs
gnome-python2-gtkhtml2
gnome-python2-libegg
gnome-python2-libwnck
gnome-screensaver
gnome-session
gnome-session-xsession
gnome-settings-daemon
#gnome-speech
#gnome-system-monitor
#gnome-terminal
gnome-themes
#gnome-user-share
#gnome-utils
gnome-vfs2
gnupg
gnupg2
gnutls
#goffice04
#gok
#gpg-pubkey
gpgme
grep
#groff
grub
gstreamer
gstreamer-plugins-base
#gstreamer-plugins-flumpegdemux
gstreamer-plugins-good
#gstreamer-python
gstreamer-tools
#gthumb
gtk-nodoka-engine
gtk2
gtk2-engines
gtkhtml2
gtkhtml3
gtkmathview
gtkmm24
gtksourceview2
#gtkspell
gucharmap
#gutenprint
#gutenprint-foomatic
gvfs
#gvfs-archive
#gvfs-fuse
#gvfs-gphoto2
gvfs-obexftp
#gvfs-smb
gzip
hal
#hal-cups-utils
hal-info
hal-libs
hdparm
hesiod
hicolor-icon-theme
#hplip-libs
htmlview
#httpd
#httpd-tools
hunspell
hunspell-en
hwdata
icedax
ilmbase
im-chooser
imsettings
imsettings-libs
info
initscripts
#iok
iproute
iptables
iptables-ipv6
iptstate
iputils
ipw2100-firmware
ipw2200-firmware
#irda-utils
irqbalance
iso-codes
isomd5sum
iwl3945-firmware
iwl4965-firmware
iwl5000-firmware
japanese-bitmap-fonts
jasper-libs
#joystick
#jwhois
kacst-fonts
kasumi
kbd
kernel
kernel-firmware
#kerneloops
keyutils-libs
#khmeros-fonts-base
kpartx
#krb5-auth-dialog
krb5-libs
#krb5-workstation
kudzu
lcms
lcms-libs
less
lftp
libICE
libIDL
libSM
libX11
libXScrnSaver
libXau
libXaw
libXcomposite
libXcursor
libXdamage
libXdmcp
libXevie
libXext
libXfixes
libXfont
libXft
libXi
libXinerama
libXmu
libXpm
libXrandr
libXrender
libXres
libXt
libXtst
libXv
libXxf86dga
libXxf86misc
libXxf86vm
#libabiword
libacl
libaio
libarchive
libart_lgpl
libasyncns
libattr
libavc1394
libbdevid-python
#libbeagle
libbonobo
libbonoboui
libbtctl
libcanberra
libcanberra-gtk2
libcap
libcdio
#libchewing
libconfig
libcroco
libcurl
libdaemon
libdhcp
libdhcp4client
libdhcp6client
libdmx
libdrm
libdv
libedit
#liberation-fonts
#libertas-usb8388-firmware
#libevent
libexif
libfontenc
libgail-gnome
libgcc
libgcrypt
libglade2
libglademm24
libgnome
libgnomecanvas
#libgnomecups
libgnomekbd
#libgnomeprint22
#libgnomeprintui22
libgnomeui
libgpg-error
libgphoto2
#libgpod
libgsf
#libgsf-gnome
#libgssglue
#libgtop2
#libgweather
libgxim
#libhangul
libidn
libiec61883
libieee1284
#libiptcdata
libjpeg
libksba
#libmalaga
#libmng
#libmtp
#libmusicbrainz
libnetfilter_conntrack
libnfnetlink
libnl
libnotify
libogg
liboil
#libopenraw
#libopenraw-gnome
libpcap
libpciaccess
libpng
#libpurple
libraw1394
librsvg2
libsamplerate
#libsane-hpaio
libselinux
libselinux-python
libselinux-utils
libsemanage
libsemanage-python
libsepol
libsexy
libshout
libsigc++20
#libsilc
#libsmbclient
libsmbios
libsndfile
libsoup
#libspectre
libssh2
libstdc++
#libtalloc
libtasn1
libtdb
libthai
libtheora
libtiff
#libtirpc
libtool-ltdl
libusb
libuser
libuser-python
libutempter
libv4l
libvisual
#libvoikko
libvolume_id
libvorbis
libwiimote
#libwmf
#libwmf-lite
libwnck
#libwpd
libwvstreams
libx86
libxcb
libxkbfile
libxklavier
libxml2
libxml2-python
libxslt
link-grammar
linux-atm-libs
linuxwacom
#lm_sensors
lockdev
logrotate
#logwatch
#lohit-fonts-bengali
#lohit-fonts-gujarati
#lohit-fonts-hindi
#lohit-fonts-kannada
#lohit-fonts-maithili
#lohit-fonts-malayalam
#lohit-fonts-marathi
#lohit-fonts-nepali
#lohit-fonts-oriya
#lohit-fonts-punjabi
#lohit-fonts-tamil
#lohit-fonts-telugu
loudmouth
lrzsz
lsof
lua
lvm2
lzma
lzma-libs
lzo
#m17n-contrib
#m17n-contrib-assamese
#m17n-contrib-bengali
#m17n-contrib-gujarati
#m17n-contrib-hindi
#m17n-contrib-kannada
#m17n-contrib-malayalam
#m17n-contrib-marathi
#m17n-contrib-nepali
#m17n-contrib-oriya
#m17n-contrib-punjabi
#m17n-contrib-tamil
#m17n-contrib-telugu
#m17n-db
#m17n-db-assamese
#m17n-db-bengali
#m17n-db-gujarati
#m17n-db-hindi
#m17n-db-kannada
#m17n-db-malayalam
#m17n-db-oriya
#m17n-db-punjabi
#m17n-db-tamil
#m17n-db-telugu
#m17n-db-thai
#m17n-lib
m4
#madan-fonts
#mailcap
#mailx
makebootfat
#malaga-suomi-voikko
#man
mathml-fonts
mdadm
meanwhile
memtest86+
mesa-dri-drivers
mesa-libGL
mesa-libGLU
metacity
microcode_ctl
mingetty
minicom
mkinitrd
mlocate
module-init-tools
#mousetweaks
mozilla-filesystem
mpfr
mtools
mtr
#nano
nash
#nautilus
#nautilus-cd-burner
#nautilus-extensions
#nautilus-sendto
nc
ncurses
ncurses-base
ncurses-libs
#net-snmp-libs
net-tools
newt
newt-python
#nfs-utils
#nfs-utils-lib
nodoka-filesystem
nodoka-metacity-theme
notification-daemon
notification-daemon-engine-nodoka
notify-python
nscd
nspluginwrapper
nspr
nss
nss-mdns
nss_ldap
ntfs-3g
ntfsprogs
ntp
ntpdate
ntsysv
obex-data-server
openldap
openobex
openssh
#openssh-askpass
openssh-clients
#openssh-server
openssl
#openvpn
#orca
#ots-libs
padauk-fonts
paktype-fonts
pam
pam_ccreds
pam_krb5
pam_passwdqc
pam_pkcs11
pam_smb
pango
pangomm
paps
paps-libs
parted
passwd
pavucontrol
pciutils
pciutils-libs
pcmciautils
pcre
perl
perl-Date-Manip
perl-Module-Pluggable
perl-Pod-Escapes
perl-Pod-Simple
perl-String-CRC32
perl-libs
perl-version
#pidgin
#pilot-link
pinentry
pixman
pkgconfig
plymouth
plymouth-gdm-hooks
plymouth-libs
plymouth-plugin-label
plymouth-plugin-solar
plymouth-scripts
plymouth-system-plugin
plymouth-utils
pm-utils
policycoreutils
policycoreutils-gui
poppler
#poppler-glib
popt
portreserve
ppp
prelink
procmail
procps
psacct
psmisc
pth
pulseaudio
pulseaudio-core-libs
pulseaudio-esound-compat
pulseaudio-libs
pulseaudio-libs-glib2
pulseaudio-module-gconf
pulseaudio-module-x11
pulseaudio-utils
pycairo
pygobject2
pygpgme
pygtk2
pygtk2-libglade
pygtksourceview
pykickstart
pyorbit
pyparted
python
python-bugzilla
python-iniparse
python-libs
python-numeric
python-paste
python-pyblock
python-slip
python-slip-dbus
python-slip-gtk
python-sqlite2
python-urlgrabber
pyxf86config
quota
radeontool
rarian
rarian-compat
rdate
rdist
readline
redhat-menus
rhpl
#rhythmbox
rmt
rng-utils
rootfiles
rp-pppoe
#rpcbind
rpm
rpm-libs
rpm-python
rsh
rsync
rsyslog
rt61pci-firmware
rt73usb-firmware
#samba-common
#samba-winbind
#samyak-fonts-devanagari
#samyak-fonts-gujarati
#samyak-fonts-malayalam
#samyak-fonts-oriya
#samyak-fonts-tamil
sane-backends
sane-backends-libs
#sarai-fonts
sazanami-fonts-gothic
sazanami-fonts-mincho
scim
scim-anthy
scim-bridge
scim-bridge-gtk
#scim-chewing
#scim-hangul
#scim-lang-assamese
#scim-lang-bengali
#scim-lang-gujarati
#scim-lang-hindi
scim-lang-japanese
#scim-lang-kannada
#scim-lang-korean
#scim-lang-malayalam
#scim-lang-marathi
#scim-lang-nepali
#scim-lang-oriya
#scim-lang-punjabi
#scim-lang-tamil
#scim-lang-telugu
#scim-lang-thai
scim-libs
#scim-m17n
#scim-pinyin
#scim-thai
sed
selinux-policy
selinux-policy-targeted
#sendmail
setools-console
setools-libs
#setroubleshoot
#setroubleshoot-plugins
#setroubleshoot-server
setserial
setup
setuptool
#sg3_utils-libs
sgml-common
shadow-utils
shared-mime-info
slang
#smartmontools
smbios-utils
#smc-fonts-anjalioldlipi
#smc-fonts-dyuthi
#smc-fonts-kalyani
#smc-fonts-meera
#smc-fonts-rachana
#smc-fonts-raghumalayalam
#smc-fonts-suruma
smolt
smolt-firstboot
solar-backgrounds
#sound-juicer
sound-theme-freedesktop
speex
sqlite
squashfs-tools
startup-notification
stix-fonts
#stunnel
sudo
symlinks
syslinux
#sysreport
system-config-boot
system-config-date
system-config-firewall
system-config-firewall-tui
system-config-keyboard
system-config-language
#system-config-lvm
system-config-network
system-config-network-tui
#system-config-printer
#system-config-printer-libs
system-config-rootpassword
system-config-services
system-config-users
sysvinit-tools
t1lib
taglib
#taipeifonts
#talk
tar
tcp_wrappers
tcp_wrappers-libs
#tcpdump
#telnet
#thaifonts-scalable
time
tmpwatch
#totem
#totem-gstreamer
#totem-mozplugin
#totem-nautilus
#totem-pl-parser
#traceroute
#transmission
tree
tzdata
udev
#un-core-fonts-batang
#un-core-fonts-dinaru
#un-core-fonts-dotum
#un-core-fonts-graphic
#un-core-fonts-gungseo
#un-core-fonts-pilgi
#un-extra-fonts-bom
#un-extra-fonts-jamobatang
#un-extra-fonts-jamodotum
#un-extra-fonts-jamonovel
#un-extra-fonts-jamosora
#un-extra-fonts-pen
#un-extra-fonts-penheulim
#un-extra-fonts-pilgia
#un-extra-fonts-shinmun
#un-extra-fonts-taza
#un-extra-fonts-vada
#un-extra-fonts-yetgul
unique
unix2dos
unzip
upstart
#urw-fonts
usbutils
usermode
usermode-gtk
ustr
util-linux-ng
vbetool
vconfig
vim-minimal
vpnc
vte
wavpack
which
wireless-tools
wodim
wpa_supplicant
wv
wvdial
xdg-user-dirs
xdg-user-dirs-gtk
xdg-utils
xkeyboard-config
xml-common
xorg-x11-drivers
xorg-x11-drv-acecad
xorg-x11-drv-aiptek
xorg-x11-drv-apm
xorg-x11-drv-ast
xorg-x11-drv-ati
xorg-x11-drv-calcomp
xorg-x11-drv-cirrus
xorg-x11-drv-citron
xorg-x11-drv-diamondtouch
xorg-x11-drv-digitaledge
xorg-x11-drv-dmc
xorg-x11-drv-dummy
xorg-x11-drv-dynapro
xorg-x11-drv-elographics
xorg-x11-drv-evdev
xorg-x11-drv-fbdev
xorg-x11-drv-fpit
xorg-x11-drv-geode
xorg-x11-drv-glint
xorg-x11-drv-hyperpen
xorg-x11-drv-i128
xorg-x11-drv-i740
xorg-x11-drv-i810
xorg-x11-drv-jamstudio
xorg-x11-drv-keyboard
xorg-x11-drv-mach64
xorg-x11-drv-magellan
xorg-x11-drv-mga
xorg-x11-drv-microtouch
xorg-x11-drv-mouse
xorg-x11-drv-mutouch
xorg-x11-drv-neomagic
xorg-x11-drv-nouveau
xorg-x11-drv-nv
xorg-x11-drv-openchrome
xorg-x11-drv-palmax
xorg-x11-drv-penmount
xorg-x11-drv-r128
xorg-x11-drv-rendition
xorg-x11-drv-s3virge
xorg-x11-drv-savage
xorg-x11-drv-siliconmotion
xorg-x11-drv-sis
xorg-x11-drv-sisusb
xorg-x11-drv-spaceorb
xorg-x11-drv-summa
xorg-x11-drv-synaptics
xorg-x11-drv-tdfx
xorg-x11-drv-tek4957
xorg-x11-drv-trident
xorg-x11-drv-ur98
xorg-x11-drv-v4l
xorg-x11-drv-vesa
xorg-x11-drv-vmmouse
xorg-x11-drv-vmware
xorg-x11-drv-void
xorg-x11-drv-voodoo
xorg-x11-drv-wiimote
xorg-x11-filesystem
xorg-x11-font-utils
xorg-x11-server-Xorg
xorg-x11-server-common
xorg-x11-server-utils
xorg-x11-utils
xorg-x11-xauth
xorg-x11-xinit
xorg-x11-xkb-utils
xulrunner
#yelp
#yp-tools
#ypbind
yum
yum-metadata-parser
yum-utils
zd1211-firmware
zenity
zip
zlib

###################
adobe-release-i386
rpmfusion-free-release
rpmfusion-nonfree-release

###################
Terminal
broadcom-wl
flash-plugin
fluxbox
fluxbox-pulseaudio
gpicview
leafpad
pcmanfm
slim
yum-fastestmirror
%end

%post
cat >/etc/rc.d/init.d/livesys <<'EOF'
#!/bin/bash
#
# live: Init script for live image
#
# chkconfig: 345 00 99
# description: Init script for live image.

. /etc/init.d/functions

if ! strstr "`cat /proc/cmdline`" liveimg || [ "$1" != "start" ]; then
    exit 0
fi

if [ -e /.liveimg-configured ] ; then
    configdone=1
fi

exists() {
    which $1 >/dev/null 2>&1 || return
    $*
}

touch /.liveimg-configured

# mount live image
if [ -b `readlink -f /dev/live` ]; then
   mkdir -p /mnt/live
   mount -o ro /dev/live /mnt/live 2>/dev/null || mount /dev/live /mnt/live
fi

# enable swaps unless requested otherwise
swaps=`blkid -t TYPE=swap -o device`
if ! strstr "`cat /proc/cmdline`" noswap && [ -n "$swaps" ] ; then
  for s in $swaps ; do
    action "Enabling swap partition $s" swapon $s
  done
fi
if ! strstr "`cat /proc/cmdline`" noswap && [ -f /mnt/live/LiveOS/swap.img ] ; then
  action "Enabling swap file" swapon /mnt/live/LiveOS/swap.img
fi

mountPersistentHome() {
  # support label/uuid
  if [ "${homedev##LABEL=}" != "${homedev}" -o "${homedev##UUID=}" != "${homedev}" ]; then
    homedev=`/sbin/blkid -o device -t "$homedev"`
  fi

  # if we're given a file rather than a blockdev, loopback it
  if [ "${homedev##mtd}" != "${homedev}" ]; then
    # mtd devs don't have a block device but get magic-mounted with -t jffs2
    mountopts="-t jffs2"
  elif [ ! -b "$homedev" ]; then
    loopdev=`losetup -f`
    if [ "${homedev##/mnt/live}" != "${homedev}" ]; then
      action "Remounting live store r/w" mount -o remount,rw /mnt/live
    fi
    losetup $loopdev $homedev
    homedev=$loopdev
  fi

  # if it's encrypted, we need to unlock it
  if [ "$(/lib/udev/vol_id -t $homedev 2>/dev/null)" = "crypto_LUKS" ]; then
    echo
    echo "Setting up encrypted /home device"
    plymouth ask-for-password --command="cryptsetup luksOpen $homedev EncHome"
    homedev=/dev/mapper/EncHome
  fi

  # and finally do the mount
  mount $mountopts $homedev /home
  # if we have /home under what's passed for persistent home, then
  # we should make that the real /home.  useful for mtd device on olpc
  if [ -d /home/home ]; then mount --bind /home/home /home ; fi
  [ -x /sbin/restorecon ] && /sbin/restorecon /home
  if [ -d /home/liveuser ]; then USERADDARGS="-M" ; fi
}

findPersistentHome() {
  for arg in `cat /proc/cmdline` ; do
    if [ "${arg##persistenthome=}" != "${arg}" ]; then
      homedev=${arg##persistenthome=}
      return
    fi
  done
}

if strstr "`cat /proc/cmdline`" persistenthome= ; then
  findPersistentHome
elif [ -e /mnt/live/LiveOS/home.img ]; then
  homedev=/mnt/live/LiveOS/home.img
fi

# if we have a persistent /home, then we want to go ahead and mount it
if ! strstr "`cat /proc/cmdline`" nopersistenthome && [ -n "$homedev" ] ; then
  action "Mounting persistent /home" mountPersistentHome
fi

# make it so that we don't do writing to the overlay for things which
# are just tmpdirs/caches
mount -t tmpfs -o mode=0755 varcacheyum /var/cache/yum
mount -t tmpfs tmp /tmp
mount -t tmpfs vartmp /var/tmp
[ -x /sbin/restorecon ] && /sbin/restorecon /var/cache/yum /tmp /var/tmp >/dev/null 2>&1

if [ -n "$configdone" ]; then
  exit 0
fi

# add fedora user with no passwd
useradd fedora
passwd -d fedora > /dev/null

sed -i -e 's/^#\(default_user\).*/\1\tfedora/' /etc/slim.conf
sed -i -e 's/^#\(auto_login\).*/\1\tyes/' /etc/slim.conf

# turn off firstboot for livecd boots
chkconfig firstboot off

# don't do packagekit checking by default
gconftool-2 --direct --config-source=xml:readwrite:/etc/gconf/gconf.xml.defaults -s -t string /apps/gnome-packagekit/frequency_get_updates never >/dev/null
gconftool-2 --direct --config-source=xml:readwrite:/etc/gconf/gconf.xml.defaults -s -t string /apps/gnome-packagekit/frequency_get_upgrades never >/dev/null
gconftool-2 --direct --config-source=xml:readwrite:/etc/gconf/gconf.xml.defaults -s -t string /apps/gnome-packagekit/frequency_refresh_cache never >/dev/null
gconftool-2 --direct --config-source=xml:readwrite:/etc/gconf/gconf.xml.defaults -s -t bool /apps/gnome-packagekit/notify_available false >/dev/null
gconftool-2 --direct --config-source=xml:readwrite:/etc/gconf/gconf.xml.defaults -s -t bool /apps/gnome-packagekit/notify_distro_upgrades false >/dev/null
gconftool-2 --direct --config-source=xml:readwrite:/etc/gconf/gconf.xml.defaults -s -t bool /apps/gnome-packagekit/enable_check_firmware false >/dev/null
gconftool-2 --direct --config-source=xml:readwrite:/etc/gconf/gconf.xml.defaults -s -t bool /apps/gnome-packagekit/enable_check_hardware false >/dev/null
gconftool-2 --direct --config-source=xml:readwrite:/etc/gconf/gconf.xml.defaults -s -t bool /apps/gnome-packagekit/enable_codec_helper false >/dev/null
gconftool-2 --direct --config-source=xml:readwrite:/etc/gconf/gconf.xml.defaults -s -t bool /apps/gnome-packagekit/enable_font_helper false >/dev/null
gconftool-2 --direct --config-source=xml:readwrite:/etc/gconf/gconf.xml.defaults -s -t bool /apps/gnome-packagekit/enable_mime_type_helper false >/dev/null

# Stopgap fix for RH #217966; should be fixed in HAL instead
touch /media/.hal-mtab

# workaround clock syncing on shutdown that we don't want (#297421)
sed -i -e 's/hwclock/no-such-hwclock/g' /etc/rc.d/init.d/halt

# disable screensaver locking
gconftool-2 --direct --config-source=xml:readwrite:/etc/gconf/gconf.xml.defaults -s -t bool /apps/gnome-screensaver/lock_enabled false >/dev/null

sed -i -e 's|\(\[encoding\]\s{UTF-8}\)|\1\n\t\t[exec] (インストール) {. /etc/sysconfig/keyboard \&\& liveinst -G --keymap=$KEYTABLE}\n\t\t[separator]|' /home/fedora/.fluxbox/menu
EOF

chmod 755 /etc/rc.d/init.d/livesys
/sbin/chkconfig --add livesys

cat >/etc/rc.d/init.d/livesys-late <<'EOF'
#!/bin/bash
#
# live: Late init script for live image
#
# chkconfig: 345 99 01
# description: Late init script for live image.

. /etc/init.d/functions

if ! strstr "`cat /proc/cmdline`" liveimg || [ "$1" != "start" ] || [ -e /.liveimg-late-configured ] ; then
    exit 0
fi

exists() {
    which $1 >/dev/null 2>&1 || return
    $*
}

touch /.liveimg-late-configured

# read some variables out of /proc/cmdline
for o in `cat /proc/cmdline` ; do
    case $o in
    ks=*)
        ks="${o#ks=}"
        ;;
    xdriver=*)
        xdriver="--set-driver=${o#xdriver=}"
        ;;
    esac
done

# this is a bad hack to work around #460581 for the geode
# purely to help move testing along for now
if [ `grep -c Geode /proc/cpuinfo` -ne 0 ]; then
  cat >/etc/X11/xorg.conf <<'FOE'
Section "ServerLayout"
	Identifier     "Default Layout"
	Screen      0  "Screen0" 0 0
	InputDevice    "Keyboard0" "CoreKeyboard"
EndSection

Section "InputDevice"
# keyboard added by rhpxl
	Identifier  "Keyboard0"
	Driver      "kbd"
	Option	    "XkbModel" "pc105"
	Option	    "XkbLayout" "us"
EndSection

Section "Monitor"
	Identifier  "Monitor0"
	HorizSync   30-67
	VertRefresh 48-52
	DisplaySize 152 114
	Mode "1200x900"
		DotClock 57.275
		HTimings 1200 1208 1216 1240
		VTimings 900 905 908 912
		Flags    "-HSync" "-VSync"
	EndMode
EndSection

Section "Device"
	Identifier  "Videocard0"
	Driver      "amd"
	VendorName  "Advanced Micro Devices, Inc."
	BoardName   "AMD Geode GX/LX"

	Option     "AccelMethod" "EXA"
	Option     "NoCompression" "true"
        Option     "MigrationHeuristic" "greedy"
	Option     "PanelGeometry" "1200x900"
EndSection

Section "Screen"
	Identifier "Screen0"
	Device     "Videocard0"
	Monitor    "Monitor0"
	DefaultDepth 16
	SubSection "Display"
		Depth   16
		Modes   "1200x900"
	EndSubSection
EndSection
FOE
fi

# if liveinst or textinst is given, start anaconda
if strstr "`cat /proc/cmdline`" liveinst ; then
   plymouth --quit
   /usr/sbin/liveinst $ks
fi
if strstr "`cat /proc/cmdline`" textinst ; then
   plymouth --quit
   /usr/sbin/liveinst --text $ks
fi

# configure X, allowing user to override xdriver
if [ -n "$xdriver" ]; then
   exists system-config-display --noui --reconfig --set-depth=24 $xdriver
fi
EOF

chmod 755 /etc/rc.d/init.d/livesys-late
/sbin/chkconfig --add livesys-late
%end

%post --nochroot
cp -r root/* $INSTALL_ROOT/
for d in `find root/ -name .svn | sed -e "s|^root|$INSTALL_ROOT|"`
do
	rm -rf $d
done

for s in script/*
do
	sh $s $INSTALL_ROOT $LIVE_ROOT
done
%end
