/**
 * feedblog PluginScript
 *
 * @copyright 2013 feedblog project (http://sourceforge.jp/projects/feedblog/)
 * @author Kureha Hisame (http://lunardial.sakura.ne.jp/) & Yui Naruse (http://airemix.com/)
 * @since 2009/02/27
 * @version　4.2.0.0
 */

(function($) {
	$.fn.feedblog_contents_plugin = function(options) {
		// デフォルト値を設定
		var options = $.extend({
			entry : {}
		}, options);
		
		var mainPageUrl = $("#feedblog_mainpageurl").val();
		var searchPageUrl = $("#feedblog_searchpageurl").val();

		// 既に処理されているかを判定
		if(options.entry.pluginExecuted != true) {
			// 記事へのアンカー、Twitterリンクをを付与
			var escapeXmlAttr = function(str) {
				return str.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;').replace(/^[ ]+/mg, "&nbsp;").replace(/^[\t]+/mg, "");
			};
			var contentUrl = mainPageUrl + "?id=" + CryptoJS.SHA1(options.entry.id).toString();

			// 追加する文字列を生成
			// 開始タグを生成
			var addContent = '<br><div class="feedblog_content_footer">';

			// タグを追加
			var tagHtml = [];
			for(var i = 0; i < options.entry.category.length; i++) {
				tagHtml.push('<a href="' + mainPageUrl + '?tag=' + options.entry.category.eq(i).attr("term") + '" target="_blank">' + options.entry.category.eq(i).attr("label") + '</a>');
			}
			if(tagHtml.length != 0) {
				addContent = addContent + 'タグ : ';
				addContent = addContent + tagHtml.join("&nbsp;/&nbsp;");
			}

			// 改行
			addContent = addContent + "<br>";

			// アンカーリンクを追加
			addContent = addContent + '<a href="' + contentUrl + '" target="_blank">- この日の記事にリンクする -<\/a>';

			// 終了タグを生成
			addContent = addContent + '<\/div>';

			// アンカーリンクを追加
			options.entry.content = options.entry.content + addContent;
			
			// プラグイン処理済み判定を追加
			options.entry.pluginExecuted = true;
		}
		return true;
	};
})(jQuery);
