/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tests;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class CommandLineTest {
    private ByteArrayOutputStream results;
    private PrintStream oldOut;
    private static boolean testWasRun;
    private static int fCount;

    @Before
    public void before() {
        this.oldOut = System.out;
        this.results = new ByteArrayOutputStream();
        System.setOut(new PrintStream(this.results));
    }

    @After
    public void after() {
        System.setOut(this.oldOut);
    }

    @Test
    public void runATest() {
        testWasRun = false;
        new JUnitCore().runMain("org.junit.tests.CommandLineTest$Example");
        Assert.assertTrue(testWasRun);
    }

    @Test
    public void runAClass() {
        testWasRun = false;
        JUnitCore.runClasses(Example.class);
        Assert.assertTrue(testWasRun);
    }

    @Test
    public void runTwoClassesAsArray() {
        fCount = 0;
        JUnitCore.runClasses(Count.class, Count.class);
        Assert.assertEquals(2, fCount);
    }

    @Test
    public void runTwoClasses() {
        fCount = 0;
        JUnitCore.runClasses(Count.class, Count.class);
        Assert.assertEquals(2, fCount);
    }

    public static class Count {
        @Test
        public void increment() {
            fCount++;
        }
    }

    public static class Example {
        @Test
        public void test() {
            testWasRun = true;
        }
    }
}

