/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tests;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import junit.framework.TestCase;
import org.junit.Test;
import org.junit.internal.runners.TextListener;
import org.junit.runner.JUnitCore;

public class TextListenerTest
extends TestCase {
    private JUnitCore runner;
    private OutputStream results;
    private TextListener listener;

    public void setUp() {
        this.runner = new JUnitCore();
        this.results = new ByteArrayOutputStream();
        PrintStream writer = new PrintStream(this.results);
        this.listener = new TextListener(writer);
        this.runner.addListener(this.listener);
    }

    public void testSuccess() throws Exception {
        this.runner.run(OneTest.class);
        TextListenerTest.assertTrue(this.results.toString().startsWith(this.convert(".\nTime: ")));
        TextListenerTest.assertTrue(this.results.toString().endsWith(this.convert("\n\nOK (1 test)\n\n")));
    }

    public void testError() throws Exception {
        this.runner.run(ErrorTest.class);
        TextListenerTest.assertTrue(this.results.toString().startsWith(this.convert(".E\nTime: ")));
        TextListenerTest.assertTrue(this.results.toString().indexOf(this.convert("\nThere was 1 failure:\n1) error(org.junit.tests.TextListenerTest$ErrorTest)\njava.lang.Exception")) != -1);
    }

    public void testTime() {
        this.runner.run(Slow.class);
        TextListenerTest.assertFalse(this.results.toString().contains("Time: 0"));
    }

    private String convert(String string) {
        ByteArrayOutputStream resultsStream = new ByteArrayOutputStream();
        PrintStream writer = new PrintStream(resultsStream);
        writer.println();
        return string.replace("\n", ((Object)resultsStream).toString());
    }

    public static class Slow {
        @Test
        public void pause() throws InterruptedException {
            Thread.sleep(1000L);
        }
    }

    public static class ErrorTest {
        @Test
        public void error() throws Exception {
            throw new Exception();
        }
    }

    public static class OneTest {
        @Test
        public void one() {
        }
    }
}

