/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.SQLException;
import java.util.WeakHashMap;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.util.Cache;
import org.h2.util.CacheHead;
import org.h2.util.CacheObject;
import org.h2.util.CacheSecondLevel;
import org.h2.util.CacheWriter;
import org.h2.util.MathUtils;
import org.h2.util.ObjectArray;
import org.h2.util.SoftHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheLRU
implements Cache {
    static final String TYPE_NAME = "LRU";
    private final CacheWriter writer;
    private final CacheObject head = new CacheHead();
    private final int len;
    private final int mask;
    private int maxSize;
    private CacheObject[] values;
    private int recordCount;
    private int sizeMemory;

    private CacheLRU(CacheWriter cacheWriter, int n) {
        this.maxSize = n * 1024 / 4;
        this.writer = cacheWriter;
        this.len = MathUtils.nextPowerOf2(this.maxSize / 64);
        this.mask = this.len - 1;
        MathUtils.checkPowerOf2(this.len);
        this.clear();
    }

    public static Cache getCache(CacheWriter cacheWriter, String string, int n) throws SQLException {
        Cache cache;
        SoftHashMap<Integer, CacheObject> softHashMap = null;
        String string2 = null;
        if (string.startsWith("SOFT_")) {
            softHashMap = new SoftHashMap();
            string = string.substring("SOFT_".length());
            string2 = "SOFT_";
        } else if (string.startsWith("WEAK_")) {
            softHashMap = new WeakHashMap();
            string = string.substring("WEAK_".length());
            string2 = "WEAK_";
        }
        if ("TQ".equals(string)) {
            cache = new CacheLRU(cacheWriter, n);
        } else if (TYPE_NAME.equals(string)) {
            cache = new CacheLRU(cacheWriter, n);
        } else {
            throw Message.getInvalidValueException(string, "CACHE_TYPE");
        }
        if (softHashMap != null) {
            cache = new CacheSecondLevel(cache, string2, softHashMap);
        }
        return cache;
    }

    @Override
    public void clear() {
        this.head.next = this.head.previous = this.head;
        this.values = null;
        this.values = new CacheObject[this.len];
        this.recordCount = 0;
        this.sizeMemory = 0;
    }

    @Override
    public void put(CacheObject cacheObject) throws SQLException {
        int n;
        if (SysProperties.CHECK) {
            n = cacheObject.getPos();
            for (int i = 0; i < cacheObject.getBlockCount(); ++i) {
                CacheObject cacheObject2 = this.find(n + i);
                if (cacheObject2 == null) continue;
                Message.throwInternalError("try to add a record twice pos:" + n + " i:" + i);
            }
        }
        n = cacheObject.getPos() & this.mask;
        cacheObject.chained = this.values[n];
        this.values[n] = cacheObject;
        ++this.recordCount;
        this.sizeMemory += cacheObject.getMemorySize();
        this.addToFront(cacheObject);
        this.removeOldIfRequired();
    }

    @Override
    public CacheObject update(int n, CacheObject cacheObject) throws SQLException {
        CacheObject cacheObject2 = this.find(n);
        if (cacheObject2 == null) {
            this.put(cacheObject);
        } else {
            if (SysProperties.CHECK && cacheObject2 != cacheObject) {
                Message.throwInternalError("old!=record pos:" + n + " old:" + cacheObject2 + " new:" + cacheObject);
            }
            this.removeFromLinkedList(cacheObject);
            this.addToFront(cacheObject);
        }
        return cacheObject2;
    }

    private void removeOldIfRequired() throws SQLException {
        if (this.sizeMemory >= this.maxSize) {
            this.removeOld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOld() throws SQLException {
        int n = 0;
        ObjectArray<CacheObject> objectArray = ObjectArray.newInstance();
        int n2 = this.sizeMemory;
        int n3 = this.recordCount;
        CacheObject cacheObject = this.head.next;
        while (n2 * 4 > this.maxSize * 3 && n3 > 16) {
            CacheObject cacheObject2 = cacheObject;
            cacheObject = cacheObject2.next;
            if (++n == this.recordCount) {
                this.writer.flushLog();
            }
            if (n >= this.recordCount * 2) {
                this.writer.getTrace().info("Cannot remove records, cache size too small?");
                break;
            }
            if (SysProperties.CHECK && cacheObject2 == this.head) {
                Message.throwInternalError("try to remove head");
            }
            if (!cacheObject2.canRemove()) {
                this.removeFromLinkedList(cacheObject2);
                this.addToFront(cacheObject2);
                continue;
            }
            --n3;
            n2 -= cacheObject2.getMemorySize();
            if (cacheObject2.isChanged()) {
                objectArray.add(cacheObject2);
                continue;
            }
            this.remove(cacheObject2.getPos());
        }
        if (objectArray.size() > 0) {
            CacheObject cacheObject3;
            CacheObject.sort(objectArray);
            int n4 = this.maxSize;
            try {
                this.maxSize = Integer.MAX_VALUE;
                for (n = 0; n < objectArray.size(); ++n) {
                    cacheObject3 = objectArray.get(n);
                    this.writer.writeBack(cacheObject3);
                }
            }
            finally {
                this.maxSize = n4;
            }
            for (n = 0; n < objectArray.size(); ++n) {
                cacheObject3 = objectArray.get(n);
                this.remove(cacheObject3.getPos());
                if (!SysProperties.CHECK || cacheObject3.next == null) continue;
                throw Message.throwInternalError();
            }
        }
    }

    private void addToFront(CacheObject cacheObject) {
        if (SysProperties.CHECK && cacheObject == this.head) {
            Message.throwInternalError("try to move head");
        }
        cacheObject.next = this.head;
        cacheObject.previous = this.head.previous;
        cacheObject.previous.next = cacheObject;
        this.head.previous = cacheObject;
    }

    private void removeFromLinkedList(CacheObject cacheObject) {
        if (SysProperties.CHECK && cacheObject == this.head) {
            Message.throwInternalError("try to remove head");
        }
        cacheObject.previous.next = cacheObject.next;
        cacheObject.next.previous = cacheObject.previous;
        cacheObject.next = null;
        cacheObject.previous = null;
    }

    @Override
    public void remove(int n) {
        int n2 = n & this.mask;
        CacheObject cacheObject = this.values[n2];
        if (cacheObject == null) {
            return;
        }
        if (cacheObject.getPos() == n) {
            this.values[n2] = cacheObject.chained;
        } else {
            do {
                CacheObject cacheObject2 = cacheObject;
                cacheObject = cacheObject.chained;
                if (cacheObject != null) continue;
                return;
            } while (cacheObject.getPos() != n);
            cacheObject2.chained = cacheObject.chained;
        }
        --this.recordCount;
        this.sizeMemory -= cacheObject.getMemorySize();
        this.removeFromLinkedList(cacheObject);
        if (SysProperties.CHECK) {
            cacheObject.chained = null;
            if (this.find(n) != null) {
                Message.throwInternalError("not removed!");
            }
        }
    }

    @Override
    public CacheObject find(int n) {
        CacheObject cacheObject = this.values[n & this.mask];
        while (cacheObject != null && cacheObject.getPos() != n) {
            cacheObject = cacheObject.chained;
        }
        return cacheObject;
    }

    @Override
    public CacheObject get(int n) {
        CacheObject cacheObject = this.find(n);
        if (cacheObject != null) {
            this.removeFromLinkedList(cacheObject);
            this.addToFront(cacheObject);
        }
        return cacheObject;
    }

    @Override
    public ObjectArray<CacheObject> getAllChanged() {
        ObjectArray<CacheObject> objectArray = ObjectArray.newInstance();
        block0: for (int i = 0; i < this.len; ++i) {
            CacheObject cacheObject = this.values[i];
            while (cacheObject != null) {
                if (cacheObject.isChanged()) {
                    objectArray.add(cacheObject);
                    if (objectArray.size() >= this.recordCount) {
                        if (!SysProperties.CHECK) continue block0;
                        if (objectArray.size() > this.recordCount) {
                            Message.throwInternalError("cache chain error");
                        }
                    }
                }
                cacheObject = cacheObject.chained;
            }
        }
        return objectArray;
    }

    @Override
    public void setMaxSize(int n) throws SQLException {
        int n2 = n * 1024 / 4;
        this.maxSize = n2 < 0 ? 0 : n2;
        this.removeOldIfRequired();
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public int getSize() {
        return this.sizeMemory;
    }
}

