/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.exceptions.InvalidPasswordException;
import org.apache.pdfbox.pdfviewer.PageWrapper;
import org.apache.pdfbox.pdfviewer.ReaderBottomPanel;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.util.ExtensionFileFilter;

public class PDFReader
extends JFrame {
    private File currentDir = new File(".");
    private JMenuItem aboutMenuItem;
    private JMenuItem contentsMenuItem;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenuBar menuBar;
    private JMenuItem openMenuItem;
    private JMenuItem printMenuItem;
    private JMenu viewMenu;
    private JMenuItem nextPageItem;
    private JMenuItem previousPageItem;
    private JPanel documentPanel = new JPanel();
    private ReaderBottomPanel bottomStatusPanel = new ReaderBottomPanel();
    private PDDocument document = null;
    private List pages = null;
    private int currentPage = 0;
    private int numberOfPages = 0;

    public PDFReader() {
        this.initComponents();
    }

    private void initComponents() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.contentsMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.printMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.nextPageItem = new JMenuItem();
        this.previousPageItem = new JMenuItem();
        this.setTitle("PDFBox - PDF Reader");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PDFReader.this.exitApplication();
            }
        });
        JScrollPane documentScroller = new JScrollPane();
        documentScroller.setViewportView(this.documentPanel);
        this.getContentPane().add((Component)documentScroller, "Center");
        this.getContentPane().add((Component)this.bottomStatusPanel, "South");
        this.fileMenu.setText("File");
        this.openMenuItem.setText("Open");
        this.openMenuItem.setToolTipText("Open PDF file");
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PDFReader.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.printMenuItem.setText("Print");
        this.printMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (PDFReader.this.document != null) {
                        PDFReader.this.document.print();
                    }
                }
                catch (PrinterException e) {
                    e.printStackTrace();
                }
            }
        });
        this.fileMenu.add(this.printMenuItem);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PDFReader.this.exitApplication();
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.helpMenu.setText("Help");
        this.contentsMenuItem.setText("Contents");
        this.helpMenu.add(this.contentsMenuItem);
        this.aboutMenuItem.setText("About");
        this.helpMenu.add(this.aboutMenuItem);
        this.viewMenu.setText("View");
        this.nextPageItem.setText("Next page");
        this.nextPageItem.setAccelerator(KeyStroke.getKeyStroke('+'));
        this.nextPageItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PDFReader.this.nextPage();
            }
        });
        this.viewMenu.add(this.nextPageItem);
        this.previousPageItem.setText("Previous page");
        this.previousPageItem.setAccelerator(KeyStroke.getKeyStroke('-'));
        this.previousPageItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PDFReader.this.previousPage();
            }
        });
        this.viewMenu.add(this.previousPageItem);
        this.menuBar.add(this.viewMenu);
        this.setJMenuBar(this.menuBar);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 700) / 2, (screenSize.height - 600) / 2, 700, 600);
    }

    private void nextPage() {
        if (this.currentPage < this.numberOfPages - 1) {
            ++this.currentPage;
            this.showPage(this.currentPage);
        }
    }

    private void previousPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.showPage(this.currentPage);
        }
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(this.currentDir);
        ExtensionFileFilter pdfFilter = new ExtensionFileFilter(new String[]{"PDF"}, "PDF Files");
        chooser.setFileFilter(pdfFilter);
        int result = chooser.showOpenDialog(this);
        if (result == 0) {
            String name = chooser.getSelectedFile().getPath();
            this.currentDir = new File(name).getParentFile();
            try {
                this.openPDFFile(name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void exitApplication() {
        try {
            if (this.document != null) {
                this.document.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        PDFReader viewer = new PDFReader();
        if (args.length > 0) {
            viewer.openPDFFile(args[0]);
        }
        ((Component)viewer).setVisible(true);
    }

    private void openPDFFile(String file) throws Exception {
        if (this.document != null) {
            this.document.close();
            this.documentPanel.removeAll();
        }
        FileInputStream input = null;
        File f = new File(file);
        input = new FileInputStream(f);
        this.document = PDFReader.parseDocument(input);
        this.setTitle("PDFBox - " + f.getAbsolutePath());
        this.pages = this.document.getDocumentCatalog().getAllPages();
        this.numberOfPages = this.pages.size();
        this.currentPage = 0;
        this.showPage(0);
    }

    private void showPage(int pageNumber) {
        try {
            PageWrapper wrapper = new PageWrapper(this);
            wrapper.displayPage((PDPage)this.pages.get(pageNumber));
            if (this.documentPanel.getComponentCount() > 0) {
                this.documentPanel.remove(0);
            }
            this.documentPanel.add(wrapper.getPanel());
            this.pack();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    private static PDDocument parseDocument(InputStream input) throws IOException {
        PDDocument document = PDDocument.load(input);
        if (document.isEncrypted()) {
            try {
                document.decrypt("");
            }
            catch (InvalidPasswordException e) {
                System.err.println("Error: The document is encrypted.");
            }
            catch (CryptographyException e) {
                e.printStackTrace();
            }
        }
        return document;
    }

    public ReaderBottomPanel getBottomStatusPanel() {
        return this.bottomStatusPanel;
    }
}

