/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.COSObjectable;

public class COSDictionaryMap
implements Map {
    private COSDictionary map;
    private Map actuals;

    public COSDictionaryMap(Map actualsMap, COSDictionary dicMap) {
        this.actuals = actualsMap;
        this.map = dicMap;
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(Object key) {
        return this.map.keyList().contains(key);
    }

    public boolean containsValue(Object value) {
        return this.actuals.containsValue(value);
    }

    public Object get(Object key) {
        return this.actuals.get(key);
    }

    public Object put(Object key, Object value) {
        COSObjectable object = (COSObjectable)value;
        this.map.setItem(COSName.getPDFName((String)key), object.getCOSObject());
        return this.actuals.put(key, value);
    }

    public Object remove(Object key) {
        this.map.removeItem(COSName.getPDFName((String)key));
        return this.actuals.remove(key);
    }

    public void putAll(Map t) {
        throw new RuntimeException("Not yet implemented");
    }

    public void clear() {
        this.map.clear();
        this.actuals.clear();
    }

    public Set keySet() {
        return this.actuals.keySet();
    }

    public Collection values() {
        return this.actuals.values();
    }

    public Set entrySet() {
        throw new RuntimeException("Not yet implemented");
    }

    public boolean equals(Object o) {
        boolean retval = false;
        if (o instanceof COSDictionaryMap) {
            COSDictionaryMap other = (COSDictionaryMap)o;
            retval = other.map.equals(this.map);
        }
        return retval;
    }

    public String toString() {
        return this.actuals.toString();
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public static COSDictionary convert(Map someMap) {
        Iterator iter = someMap.keySet().iterator();
        COSDictionary dic = new COSDictionary();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            COSObjectable object = (COSObjectable)someMap.get(name);
            dic.setItem(COSName.getPDFName(name), object.getCOSObject());
        }
        return dic;
    }

    public static COSDictionaryMap convertBasicTypesToMap(COSDictionary map) throws IOException {
        COSDictionaryMap retval = null;
        if (map != null) {
            HashMap<String, String> actualMap = new HashMap<String, String>();
            Iterator keyIter = map.keyList().iterator();
            while (keyIter.hasNext()) {
                COSName key = (COSName)keyIter.next();
                COSBase cosObj = map.getDictionaryObject(key);
                Object actualObject = null;
                if (cosObj instanceof COSString) {
                    actualObject = ((COSString)cosObj).getString();
                } else if (cosObj instanceof COSInteger) {
                    actualObject = new Integer(((COSInteger)cosObj).intValue());
                } else if (cosObj instanceof COSName) {
                    actualObject = ((COSName)cosObj).getName();
                } else if (cosObj instanceof COSFloat) {
                    actualObject = new Float(((COSFloat)cosObj).floatValue());
                } else if (cosObj instanceof COSBoolean) {
                    actualObject = ((COSBoolean)cosObj).getValue() ? Boolean.TRUE : Boolean.FALSE;
                } else {
                    throw new IOException("Error:unknown type of object to convert:" + cosObj);
                }
                actualMap.put(key.getName(), (String)actualObject);
            }
            retval = new COSDictionaryMap(actualMap, map);
        }
        return retval;
    }
}

