/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpaceFactory;

public class PDSeparation
extends PDColorSpace {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$pdfbox$pdmodel$graphics$color$PDSeparation == null ? (class$org$apache$pdfbox$pdmodel$graphics$color$PDSeparation = PDSeparation.class$("org.apache.pdfbox.pdmodel.graphics.color.PDSeparation")) : class$org$apache$pdfbox$pdmodel$graphics$color$PDSeparation));
    public static final String NAME = "Separation";
    static /* synthetic */ Class class$org$apache$pdfbox$pdmodel$graphics$color$PDSeparation;

    public PDSeparation() {
        this.array = new COSArray();
        this.array.add(COSName.getPDFName(NAME));
        this.array.add(COSName.getPDFName(""));
    }

    public PDSeparation(COSArray separation) {
        this.array = separation;
    }

    public String getName() {
        return NAME;
    }

    public int getNumberOfComponents() throws IOException {
        return this.getAlternateColorSpace().getNumberOfComponents();
    }

    protected ColorSpace createColorSpace() throws IOException {
        try {
            PDColorSpace alt = this.getAlternateColorSpace();
            return alt.getJavaColorSpace();
        }
        catch (IOException ioexception) {
            log.error((Object)ioexception, (Throwable)ioexception);
            throw ioexception;
        }
        catch (Exception exception) {
            log.error((Object)exception, (Throwable)exception);
            throw new IOException("Failed to Create ColorSpace");
        }
    }

    public ColorModel createColorModel(int bpc) throws IOException {
        log.info((Object)("About to create ColorModel for " + this.getAlternateColorSpace().toString()));
        return this.getAlternateColorSpace().createColorModel(bpc);
    }

    public String getColorantName() {
        COSName name = (COSName)this.array.getObject(1);
        return name.getName();
    }

    public void setColorantName(String name) {
        this.array.set(1, COSName.getPDFName(name));
    }

    public PDColorSpace getAlternateColorSpace() throws IOException {
        COSBase alternate = this.array.getObject(2);
        PDColorSpace cs = PDColorSpaceFactory.createColorSpace(alternate);
        return cs;
    }

    public void setAlternateColorSpace(PDColorSpace cs) {
        COSBase space = null;
        if (cs != null) {
            space = cs.getCOSObject();
        }
        this.array.set(2, space);
    }

    public PDFunction getTintTransform() throws IOException {
        return PDFunction.create(this.array.getObject(3));
    }

    public void setTintTransform(PDFunction tint) {
        this.array.set(3, tint);
    }

    private COSDictionary getDictionary() throws IOException {
        return (COSDictionary)this.array.getObject(3);
    }

    public COSArray getColorValues() throws IOException {
        return (COSArray)this.getDictionary().getDictionaryObject("C1");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

