/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.sqlclause;

import org.seasar.dbflute.cbean.sqlclause.AbstractSqlClause;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.cbean.sqlclause.WhereClauseArranger;
import org.seasar.dbflute.dbmeta.DBMeta;

public class SqlClauseOracle
extends AbstractSqlClause {
    protected String _fetchScopeSelectHint = "";
    protected String _fetchScopeSqlSuffix = "";
    protected String _lockSqlSuffix = "";

    public SqlClauseOracle(String tableName) {
        super(tableName);
    }

    protected String buildUnionClause(String selectClause) {
        selectClause = this.replaceString(selectClause, "/*$dto.selectHint*/", "");
        return super.buildUnionClause(selectClause);
    }

    protected void doFetchFirst() {
        this.doFetchPage();
    }

    protected void doFetchPage() {
        if (!this.isFetchStartIndexSupported() && !this.isFetchSizeSupported()) {
            return;
        }
        String ln = this.getLineSeparator();
        this._fetchScopeSelectHint = " * from (select base.*, rownum as rn from (" + ln + "select";
        this._fetchScopeSqlSuffix = "";
        if (this.isFetchStartIndexSupported()) {
            this._fetchScopeSqlSuffix = ") base )" + ln + " where rn > " + this.getPageStartIndex();
        }
        if (this.isFetchSizeSupported()) {
            this._fetchScopeSqlSuffix = this.isFetchStartIndexSupported() ? this._fetchScopeSqlSuffix + " and rn <= " + this.getPageEndIndex() : ") base )" + ln + " where rn <= " + this.getPageEndIndex();
        }
    }

    protected void doClearFetchPageClause() {
        this._fetchScopeSelectHint = "";
        this._fetchScopeSqlSuffix = "";
    }

    public SqlClause lockForUpdate() {
        DBMeta dbmeta = this.findDBMeta(this._tableName);
        if (dbmeta.hasPrimaryKey()) {
            String primaryKeyColumnName = dbmeta.getPrimaryUniqueInfo().getFirstColumn().getColumnDbName();
            this._lockSqlSuffix = " for update of " + this.getLocalTableAliasName() + "." + primaryKeyColumnName;
        } else {
            String randomColumnName = dbmeta.getColumnInfoList().get(0).getColumnDbName();
            this._lockSqlSuffix = " for update of " + this.getLocalTableAliasName() + "." + randomColumnName;
        }
        return this;
    }

    protected String createSelectHint() {
        return this._fetchScopeSelectHint;
    }

    protected String createFromBaseTableHint() {
        return "";
    }

    protected String createFromHint() {
        return "";
    }

    protected String createSqlSuffix() {
        return this._fetchScopeSqlSuffix + this._lockSqlSuffix;
    }

    public SqlClause lockForUpdateNoWait() {
        this.lockForUpdate();
        this._lockSqlSuffix = this._lockSqlSuffix + " nowait";
        return this;
    }

    public SqlClause lockForUpdateWait(int waitSec) {
        this.lockForUpdate();
        this._lockSqlSuffix = this._lockSqlSuffix + " wait " + waitSec;
        return this;
    }

    public int getInScopeLimit() {
        return 1000;
    }

    public WhereClauseArranger createFullTextSearchClauseArranger() {
        return new FullTextSearchClauseArranger();
    }

    public String escapeFullTextSearchValue(String conditionValue) {
        if (conditionValue.contains("}")) {
            conditionValue = this.replaceString(conditionValue, "}", "}}");
        }
        conditionValue = "{" + conditionValue + "}";
        return conditionValue;
    }

    protected static class FullTextSearchClauseArranger
    implements WhereClauseArranger {
        protected FullTextSearchClauseArranger() {
        }

        public String arrange(String columnName, String operand, String bindExpression, String rearOption) {
            return "contains(" + columnName + ", " + bindExpression + ") > 0";
        }
    }
}

