/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlcommand;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.sql.DataSource;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.core.SqlExecution;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.sqlcommand.TnSqlCommand;
import org.seasar.dbflute.s2dao.sqlhandler.TnCommandContextHandler;
import org.seasar.dbflute.twowaysql.SqlAnalyzer;
import org.seasar.dbflute.twowaysql.context.CommandContext;
import org.seasar.dbflute.twowaysql.context.CommandContextCreator;
import org.seasar.dbflute.twowaysql.node.Node;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnUpdateQueryAutoDynamicCommand
implements TnSqlCommand,
SqlExecution {
    protected DataSource dataSource;
    protected StatementFactory statementFactory;

    public TnUpdateQueryAutoDynamicCommand(DataSource dataSource, StatementFactory statementFactory) {
        this.dataSource = dataSource;
        this.statementFactory = statementFactory;
    }

    @Override
    public Object execute(Object[] args) {
        ConditionBean cb = this.extractConditionBeanWithCheck(args);
        Entity entity = this.extractEntityWithCheck(args);
        String[] argNames = new String[]{"dto", "entity"};
        Class[] argTypes = new Class[]{cb.getClass(), entity.getClass()};
        String twoWaySql = this.buildQueryUpdateTwoWaySql(cb, entity);
        if (twoWaySql == null) {
            return 0;
        }
        CommandContext context = this.createCommandContext(twoWaySql, argNames, argTypes, args);
        TnCommandContextHandler handler = this.createCommandContextHandler(context);
        handler.setLoggingMessageSqlArgs(context.getBindVariables());
        int rows = handler.execute(args);
        return rows;
    }

    protected ConditionBean extractConditionBeanWithCheck(Object[] args) {
        this.assertArgument(args);
        Object fisrtArg = args[0];
        if (!(fisrtArg instanceof ConditionBean)) {
            String msg = "The type of first argument should be " + ConditionBean.class + "! But:";
            msg = msg + " type=" + fisrtArg.getClass();
            throw new IllegalArgumentException(msg);
        }
        return (ConditionBean)fisrtArg;
    }

    protected Entity extractEntityWithCheck(Object[] args) {
        this.assertArgument(args);
        Object secondArg = args[1];
        if (!(secondArg instanceof Entity)) {
            String msg = "The type of second argument should be " + Entity.class + "! But:";
            msg = msg + " type=" + secondArg.getClass();
            throw new IllegalArgumentException(msg);
        }
        return (Entity)secondArg;
    }

    protected void assertArgument(Object[] args) {
        if (args == null || args.length <= 1) {
            String msg = "The arguments should have two argument! But:";
            msg = msg + " args=" + (args != null ? Integer.valueOf(args.length) : null);
            throw new IllegalArgumentException(msg);
        }
    }

    protected TnCommandContextHandler createCommandContextHandler(CommandContext context) {
        return new TnCommandContextHandler(this.dataSource, this.statementFactory, context);
    }

    protected String buildQueryUpdateTwoWaySql(ConditionBean cb, Entity entity) {
        LinkedHashMap<String, String> columnParameterMap = new LinkedHashMap<String, String>();
        DBMeta dbmeta = entity.getDBMeta();
        Set<String> modifiedPropertyNames = entity.getModifiedPropertyNames();
        if (modifiedPropertyNames.isEmpty()) {
            return null;
        }
        String currentPropertyName = null;
        try {
            ColumnInfo columnInfo;
            Iterator<String> i$ = modifiedPropertyNames.iterator();
            while (i$.hasNext()) {
                String propertyName;
                currentPropertyName = propertyName = i$.next();
                ColumnInfo columnInfo2 = dbmeta.findColumnInfo(propertyName);
                String columnName = columnInfo2.getColumnDbName();
                Method getter = columnInfo2.findGetter();
                Object value = getter.invoke((Object)entity, (Object[])null);
                if (value != null) {
                    columnParameterMap.put(columnName, "/*entity." + propertyName + "*/null");
                    continue;
                }
                columnParameterMap.put(columnName, "null");
            }
            if (dbmeta.hasVersionNo()) {
                columnInfo = dbmeta.getVersionNoColumnInfo();
                String columnName = columnInfo.getColumnDbName();
                columnParameterMap.put(columnName, columnName + " + 1");
            }
            if (dbmeta.hasUpdateDate()) {
                columnInfo = dbmeta.getUpdateDateColumnInfo();
                Method setter = columnInfo.findSetter();
                setter.invoke((Object)entity, ResourceContext.getAccessTimestamp());
                String columnName = columnInfo.getColumnDbName();
                columnParameterMap.put(columnName, "/*entity." + columnInfo.getPropertyName() + "*/null");
            }
        }
        catch (Exception e) {
            this.throwQueryUpdateFailureException(cb, entity, currentPropertyName, e);
        }
        return cb.getSqlClause().getClauseQueryUpdate(columnParameterMap);
    }

    protected void throwQueryUpdateFailureException(ConditionBean cb, Entity entity, String propertyName, Exception e) {
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = msg + "queryUpdate() failed to execute!" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Advice]" + this.getLineSeparator();
        msg = msg + "Please confirm the parameter comment logic." + this.getLineSeparator();
        msg = msg + "It may exist the parameter comment that DOESN'T have an end comment." + this.getLineSeparator();
        msg = msg + "  For example:" + this.getLineSeparator();
        msg = msg + "    before (x) -- /*IF pmb.xxxId != null*/XXX_ID = /*pmb.xxxId*/3" + this.getLineSeparator();
        msg = msg + "    after  (o) -- /*IF pmb.xxxId != null*/XXX_ID = /*pmb.xxxId*/3/*END*/" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Doubtful Property Name]" + this.getLineSeparator() + propertyName + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[ConditionBean]" + this.getLineSeparator() + cb + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Entity]" + this.getLineSeparator() + entity + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Exception Message]" + this.getLineSeparator() + e.getMessage() + this.getLineSeparator();
        msg = msg + "* * * * * * * * * */";
        throw new QueryUpdateFailureException(msg, e);
    }

    protected CommandContext createCommandContext(String twoWaySql, String[] argNames, Class<?>[] argTypes, Object[] args) {
        SqlAnalyzer parser = new SqlAnalyzer(twoWaySql, true);
        Node node = parser.parse();
        CommandContextCreator creator = new CommandContextCreator(argNames, argTypes);
        CommandContext context = creator.createCommandContext(args);
        node.accept(context);
        return context;
    }

    protected String getLineSeparator() {
        return DfSystemUtil.getLineSeparator();
    }

    public static class QueryUpdateFailureException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public QueryUpdateFailureException(String msg, Exception e) {
            super(msg, e);
        }
    }
}

