/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.tartarus.snowball.ext.EnglishStemmer;

class EnglishPorterFilter
extends TokenFilter {
    private final CharArraySet protWords;
    private EnglishStemmer stemmer;

    public EnglishPorterFilter(TokenStream source, CharArraySet protWords) {
        super(source);
        this.protWords = protWords;
        this.stemmer = new EnglishStemmer();
    }

    public Token next(Token token) throws IOException {
        Token result = this.input.next(token);
        if (result != null) {
            char[] termBuffer = result.termBuffer();
            int len = result.termLength();
            if (this.protWords != null && this.protWords.contains(termBuffer, 0, len)) {
                return result;
            }
            this.stemmer.setCurrent(new String(termBuffer, 0, len));
            this.stemmer.stem();
            String newstr = this.stemmer.getCurrent();
            result.setTermBuffer(newstr.toCharArray(), 0, newstr.length());
        }
        return result;
    }
}

