/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.extractor.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.sax.BodyContentHandler;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.entity.ExtractData;
import org.seasar.robot.extractor.ExtractException;
import org.seasar.robot.extractor.Extractor;
import org.seasar.robot.util.StreamUtil;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TikaExtractor
implements Extractor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public ExtractData getText(InputStream in, Map<String, String> params) {
        if (in == null) {
            throw new RobotSystemException("The inputstream is null.");
        }
        File tempFile = null;
        try {
            tempFile = File.createTempFile("tikaExtractor-", ".out");
        }
        catch (IOException e) {
            throw new ExtractException("Could not create a temp file.", e);
        }
        try {
            ExtractData extractData;
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(tempFile);
                StreamUtil.drain(in, out);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
            in = new FileInputStream(tempFile);
            try {
                String resourceName = params != null ? params.get("resourceName") : null;
                String contentType = params != null ? params.get("Content-Type") : null;
                Metadata metadata = new Metadata();
                if (StringUtil.isNotEmpty((String)resourceName)) {
                    metadata.set("resourceName", resourceName);
                }
                if (StringUtil.isNotBlank((String)contentType)) {
                    metadata.set("Content-Type", contentType);
                }
                AutoDetectParser parser = new AutoDetectParser();
                StringWriter writer = new StringWriter();
                parser.parse(in, (ContentHandler)new BodyContentHandler((Writer)writer), metadata);
                ExtractData extractData2 = new ExtractData(writer.toString().replaceAll("\\s+$", " ").trim());
                Object[] names = metadata.names();
                Arrays.sort(names);
                for (Object name : names) {
                    extractData2.putValues((String)name, metadata.getValues((String)name));
                }
                extractData = extractData2;
            }
            catch (TikaException e) {
                block22: {
                    Extractor xmlExtractor;
                    Throwable cause = e.getCause();
                    if (!(cause instanceof SAXException) || (xmlExtractor = (Extractor)SingletonS2Container.getComponent((String)"xmlExtractor")) == null) break block22;
                    IOUtils.closeQuietly((InputStream)in);
                    in = new FileInputStream(tempFile);
                    ExtractData extractData3 = xmlExtractor.getText(in, params);
                    IOUtils.closeQuietly((InputStream)in);
                    if (tempFile != null && !tempFile.delete()) {
                        tempFile.deleteOnExit();
                    }
                    return extractData3;
                }
                try {
                    throw e;
                    {
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly((InputStream)in);
                            throw throwable;
                        }
                    }
                }
                catch (Exception e2) {
                    throw new ExtractException("Could not extract a content.", e2);
                }
            }
            IOUtils.closeQuietly((InputStream)in);
            return extractData;
        }
        finally {
            if (tempFile != null && !tempFile.delete()) {
                tempFile.deleteOnExit();
            }
        }
    }
}

