/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpRequest;
import org.apache.http.ProtocolVersion;
import org.apache.http.annotation.Immutable;
import org.apache.http.impl.client.cache.CachedHeaderGroup;
import org.apache.http.impl.cookie.DateParseException;
import org.apache.http.impl.cookie.DateUtils;
import org.apache.http.message.BasicHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class CacheEntry
implements Serializable {
    private static final long serialVersionUID = -6300496422359477413L;
    public static final long MAX_AGE = 0x80000000L;
    private final Date requestDate;
    private final Date responseDate;
    private final ProtocolVersion version;
    private final int status;
    private final String reason;
    private final CachedHeaderGroup responseHeaders = new CachedHeaderGroup();
    private final byte[] body;
    private final Set<String> variantURIs = new HashSet<String>();

    public CacheEntry(Date requestDate, Date responseDate, ProtocolVersion version, Header[] responseHeaders, byte[] responseBytes, int status, String reason) {
        this.requestDate = requestDate;
        this.responseDate = responseDate;
        this.version = version;
        this.responseHeaders.setHeaders(responseHeaders);
        this.status = status;
        this.reason = reason;
        this.body = (byte[])responseBytes.clone();
    }

    private CacheEntry(CacheEntry toCopy, String variantURI) {
        this(toCopy.getRequestDate(), toCopy.getResponseDate(), toCopy.getProtocolVersion(), toCopy.getAllHeaders(), toCopy.getBody(), toCopy.getStatusCode(), toCopy.getReasonPhrase());
        this.variantURIs.addAll(toCopy.getVariantURIs());
        this.variantURIs.add(variantURI);
    }

    public CacheEntry addVariantURI(String variantURI) {
        return new CacheEntry(this, variantURI);
    }

    public ProtocolVersion getProtocolVersion() {
        return this.version;
    }

    public String getReasonPhrase() {
        return this.reason;
    }

    public int getStatusCode() {
        return this.status;
    }

    public Date getRequestDate() {
        return this.requestDate;
    }

    public Date getResponseDate() {
        return this.responseDate;
    }

    public byte[] getBody() {
        return (byte[])this.body.clone();
    }

    public Header[] getAllHeaders() {
        return this.responseHeaders.getAllHeaders();
    }

    public Header getFirstHeader(String name) {
        return this.responseHeaders.getFirstHeader(name);
    }

    public Header[] getHeaders(String name) {
        return this.responseHeaders.getHeaders(name);
    }

    protected Date getDateValue() {
        Header dateHdr = this.getFirstHeader("Date");
        if (dateHdr == null) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)dateHdr.getValue());
        }
        catch (DateParseException dateParseException) {
            return null;
        }
    }

    protected long getContentLengthValue() {
        Header cl = this.getFirstHeader("Content-Length");
        if (cl == null) {
            return -1L;
        }
        try {
            return Long.parseLong(cl.getValue());
        }
        catch (NumberFormatException ex) {
            return -1L;
        }
    }

    protected boolean contentLengthHeaderMatchesActualLength() {
        return this.getContentLengthValue() == (long)this.body.length;
    }

    protected long getApparentAgeSecs() {
        Date dateValue = this.getDateValue();
        if (dateValue == null) {
            return 0x80000000L;
        }
        long diff = this.responseDate.getTime() - dateValue.getTime();
        if (diff < 0L) {
            return 0L;
        }
        return diff / 1000L;
    }

    protected long getAgeValue() {
        long ageValue = 0L;
        for (Header hdr : this.getHeaders("Age")) {
            long hdrAge;
            try {
                hdrAge = Long.parseLong(hdr.getValue());
                if (hdrAge < 0L) {
                    hdrAge = 0x80000000L;
                }
            }
            catch (NumberFormatException nfe) {
                hdrAge = 0x80000000L;
            }
            ageValue = hdrAge > ageValue ? hdrAge : ageValue;
        }
        return ageValue;
    }

    protected long getCorrectedReceivedAgeSecs() {
        long ageValue;
        long apparentAge = this.getApparentAgeSecs();
        return apparentAge > (ageValue = this.getAgeValue()) ? apparentAge : ageValue;
    }

    protected long getResponseDelaySecs() {
        long diff = this.responseDate.getTime() - this.requestDate.getTime();
        return diff / 1000L;
    }

    protected long getCorrectedInitialAgeSecs() {
        return this.getCorrectedReceivedAgeSecs() + this.getResponseDelaySecs();
    }

    protected Date getCurrentDate() {
        return new Date();
    }

    protected long getResidentTimeSecs() {
        long diff = this.getCurrentDate().getTime() - this.responseDate.getTime();
        return diff / 1000L;
    }

    public long getCurrentAgeSecs() {
        return this.getCorrectedInitialAgeSecs() + this.getResidentTimeSecs();
    }

    protected long getMaxAge() {
        long maxage = -1L;
        for (Header hdr : this.getHeaders("Cache-Control")) {
            for (HeaderElement elt : hdr.getElements()) {
                if (!"max-age".equals(elt.getName()) && !"s-maxage".equals(elt.getName())) continue;
                try {
                    long currMaxAge = Long.parseLong(elt.getValue());
                    if (maxage != -1L && currMaxAge >= maxage) continue;
                    maxage = currMaxAge;
                }
                catch (NumberFormatException nfe) {
                    maxage = 0L;
                }
            }
        }
        return maxage;
    }

    protected Date getExpirationDate() {
        Header expiresHeader = this.getFirstHeader("Expires");
        if (expiresHeader == null) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)expiresHeader.getValue());
        }
        catch (DateParseException dateParseException) {
            return null;
        }
    }

    public long getFreshnessLifetimeSecs() {
        long maxage = this.getMaxAge();
        if (maxage > -1L) {
            return maxage;
        }
        Date dateValue = this.getDateValue();
        if (dateValue == null) {
            return 0L;
        }
        Date expiry = this.getExpirationDate();
        if (expiry == null) {
            return 0L;
        }
        long diff = expiry.getTime() - dateValue.getTime();
        return diff / 1000L;
    }

    public boolean isResponseFresh() {
        return this.getCurrentAgeSecs() < this.getFreshnessLifetimeSecs();
    }

    public boolean isRevalidatable() {
        return this.getFirstHeader("ETag") != null || this.getFirstHeader("Last-Modified") != null;
    }

    public boolean modifiedSince(HttpRequest request) {
        Header unmodHeader = request.getFirstHeader("If-Unmodified-Since");
        if (unmodHeader == null) {
            return false;
        }
        try {
            Date unmodifiedSinceDate = DateUtils.parseDate((String)unmodHeader.getValue());
            Date lastModifiedDate = DateUtils.parseDate((String)this.getFirstHeader("Last-Modified").getValue());
            if (unmodifiedSinceDate.before(lastModifiedDate)) {
                return true;
            }
        }
        catch (DateParseException e) {
            return false;
        }
        return false;
    }

    public boolean hasVariants() {
        return this.getFirstHeader("Vary") != null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (null == this.responseHeaders || this.responseHeaders.getAllHeaders().length < 1) {
            return;
        }
        int headerCount = this.responseHeaders.getAllHeaders().length;
        Header[] headers = this.responseHeaders.getAllHeaders();
        String[][] sheaders = new String[headerCount][2];
        for (int i = 0; i < headerCount; ++i) {
            sheaders[i][0] = headers[i].getName();
            sheaders[i][1] = headers[i].getValue();
        }
        out.writeObject(sheaders);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String[][] sheaders = (String[][])in.readObject();
        if (null == sheaders || sheaders.length < 1) {
            return;
        }
        BasicHeader[] headers = new BasicHeader[sheaders.length];
        for (int i = 0; i < sheaders.length; ++i) {
            String[] sheader = sheaders[i];
            headers[i] = new BasicHeader(sheader[0], sheader[1]);
        }
        this.responseHeaders.setHeaders((Header[])headers);
    }

    public Set<String> getVariantURIs() {
        return Collections.unmodifiableSet(this.variantURIs);
    }

    public String toString() {
        return "[request date=" + this.requestDate + "; response date=" + this.responseDate + "; status=" + this.status + "]";
    }
}

