/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.taglibs.impl;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.mobylet.core.gps.Geo;
import org.mobylet.core.gps.Gps;
import org.mobylet.core.gps.Marker;
import org.mobylet.core.util.StringUtils;
import org.mobylet.taglibs.MobyletTag;
import org.mobylet.taglibs.utils.JspWriterUtils;
import org.mobylet.view.designer.GoogleMapDesigner;

public class GoogleMapTag
extends TagSupport
implements MobyletTag {
    private static final long serialVersionUID = -2122566184950353337L;
    public static final String TAG = "img";
    public static final String URL = "http://maps.google.com/staticmap";
    protected String key;
    protected String lat;
    protected String lon;
    protected Integer width;
    protected Integer height;
    protected Integer zoom = 15;
    protected Boolean sensor = false;
    protected String markerSize;
    protected String markerColor;
    protected String markerAlphaNumericCharacter;
    protected List<Marker> markers;

    public int doStartTag() throws JspException {
        return 1;
    }

    public int doEndTag() throws JspException {
        try {
            if (StringUtils.isEmpty((String)this.key)) {
                return 6;
            }
            GoogleMapDesigner designer = new GoogleMapDesigner(this.key);
            if (StringUtils.isNotEmpty((String)this.lat) && StringUtils.isNotEmpty((String)this.lon)) {
                designer.setCenter((Gps)new Marker(Double.valueOf(Double.parseDouble(this.lat)), Double.valueOf(Double.parseDouble(this.lon)), Geo.WGS84));
            }
            if (this.width != null && this.height != null) {
                designer.setWidth(this.width);
                designer.setHeight(this.height);
            }
            if (this.zoom != null) {
                designer.setZoom(this.zoom);
            }
            if (this.sensor != null) {
                designer.setSensor(this.sensor);
            }
            if (this.markers != null && this.markers.size() > 0) {
                for (Marker marker : this.markers) {
                    designer.addMarker(marker);
                }
            }
            JspWriterUtils.write(this.pageContext.getOut(), "<img src=\"" + designer.getSrc(this.markerSize, this.markerColor, this.markerAlphaNumericCharacter) + "\"" + ">");
            this.recycle();
            return 6;
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }

    protected void recycle() {
        this.key = null;
        this.lat = null;
        this.lon = null;
        this.width = null;
        this.height = null;
        this.markers = null;
        this.zoom = 15;
        this.sensor = false;
    }

    public void addMarker(Marker marker) {
        if (this.markers == null) {
            this.markers = new ArrayList<Marker>();
        }
        this.markers.add(marker);
    }

    public String getLat() {
        return this.lat;
    }

    public void setLat(String lat) {
        this.lat = lat;
    }

    public String getLon() {
        return this.lon;
    }

    public void setLon(String lon) {
        this.lon = lon;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Integer getZoom() {
        return this.zoom;
    }

    public void setZoom(Integer zoom) {
        this.zoom = zoom;
    }

    public Boolean getSensor() {
        return this.sensor;
    }

    public void setSensor(Boolean sensor) {
        this.sensor = sensor;
    }

    public String getMarkerSize() {
        return this.markerSize;
    }

    public void setMarkerSize(String markerSize) {
        this.markerSize = markerSize;
    }

    public String getMarkerColor() {
        return this.markerColor;
    }

    public void setMarkerColor(String markerColor) {
        this.markerColor = markerColor;
    }

    public String getMarkerAlphaNumericCharacter() {
        return this.markerAlphaNumericCharacter;
    }

    public void setMarkerAlphaNumericCharacter(String markerAlphaNumericCharacter) {
        this.markerAlphaNumericCharacter = markerAlphaNumericCharacter;
    }
}

