/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv.core.supplement;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.seasar.dbflute.XLog;
import org.seasar.dbflute.util.DfTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceCache {
    protected static final BigDecimal INITIAL_ADDED_COUNT = BigDecimal.ZERO;
    protected static final BigDecimal DEFAULT_ADD_SIZE = BigDecimal.ONE;
    protected final Class<?> _resultType;
    protected final BigDecimal _cacheSize;
    protected final Integer _incrementSize;
    protected volatile BigDecimal _addedCount = INITIAL_ADDED_COUNT;
    protected volatile BigDecimal _sequenceValue;
    protected volatile BigDecimal _batchFirstValue;
    protected final List<BigDecimal> _cachedList = new ArrayList<BigDecimal>();
    protected final SortedSet<BigDecimal> _tmpSortedSet = new TreeSet<BigDecimal>(new Comparator<BigDecimal>(){

        @Override
        public int compare(BigDecimal arg0, BigDecimal arg1) {
            return arg0.compareTo(arg1);
        }
    });
    protected volatile boolean _batchWay;

    public SequenceCache(Class<?> resultType, BigDecimal cacheSize, Integer incrementSize) {
        this._resultType = resultType;
        this._cacheSize = cacheSize;
        this._incrementSize = incrementSize;
    }

    public synchronized Object nextval(SequenceRealExecutor executor) {
        if (this._batchWay) {
            if (this._incrementSize == null) {
                String msg = "The increment size should not be null if it uses batch way!";
                throw new IllegalStateException(msg);
            }
            if (this._incrementSize >= 2) {
                this._addedCount = this._addedCount.add(this.getAddSize());
                if (this._addedCount.intValue() < this._incrementSize) {
                    if (this.isLogEnabled()) {
                        String msg = "...Getting next value from (cached-size) added count:";
                        msg = msg + " (" + this._sequenceValue + " + " + this._addedCount + ":";
                        msg = msg + " cache-point=" + this._batchFirstValue + ")";
                        this.log(msg);
                    }
                    return this.toResultType(this._sequenceValue.add(this._addedCount));
                }
                this._addedCount = INITIAL_ADDED_COUNT;
            }
            if (!this._cachedList.isEmpty()) {
                this._sequenceValue = this._cachedList.remove(0);
                if (this.isLogEnabled()) {
                    String msg = "...Getting next value from cached list:";
                    msg = msg + " (" + this._sequenceValue + ": cache-point=" + this._batchFirstValue + ")";
                    this.log(msg);
                }
                return this.toResultType(this._sequenceValue);
            }
        } else {
            this._addedCount = this._addedCount.add(this.getAddSize());
            if (this._sequenceValue != null && this._addedCount.compareTo(this._cacheSize) < 0) {
                if (this.isLogEnabled()) {
                    String msg = "...Getting next value from added count:";
                    msg = msg + " (" + this._sequenceValue + " + " + this._addedCount + ")";
                    this.log(msg);
                }
                return this.toResultType(this._sequenceValue.add(this._addedCount));
            }
        }
        if (this.isLogEnabled()) {
            String msg = "...Selecting next value and cache values:";
            msg = msg + " cacheSize=" + this._cacheSize;
            this.log(msg);
        }
        this.setupSequence(executor);
        return this.toResultType(this._sequenceValue);
    }

    protected BigDecimal getAddSize() {
        return DEFAULT_ADD_SIZE;
    }

    protected void setupSequence(SequenceRealExecutor executor) {
        this.initialize();
        Object obj = executor.execute();
        this.assertSequenceRealExecutorReturnsNotNull(obj, executor);
        if (obj instanceof List) {
            List selectedList = (List)obj;
            this.assertSequenceRealExecutorReturnsNotEmptyList(selectedList, executor);
            for (Object element : selectedList) {
                this._tmpSortedSet.add(this.toInternalType(element));
            }
            this._cachedList.addAll(this._tmpSortedSet);
            this._batchFirstValue = this._sequenceValue = this._cachedList.remove(0);
            this._batchWay = true;
        } else {
            this._sequenceValue = this.toInternalType(obj);
            this._batchWay = false;
        }
    }

    protected void initialize() {
        this._addedCount = INITIAL_ADDED_COUNT;
        this._cachedList.clear();
        this._tmpSortedSet.clear();
    }

    protected void assertSequenceRealExecutorReturnsNotNull(Object obj, SequenceRealExecutor executor) {
        if (obj == null) {
            String msg = "The sequence real executor should not return null:";
            msg = msg + " executor=" + executor;
            throw new IllegalStateException(msg);
        }
    }

    protected void assertSequenceRealExecutorReturnsNotEmptyList(List<?> selectedList, SequenceRealExecutor executor) {
        if (selectedList.isEmpty()) {
            String msg = "The sequence real executor should not return empty list:";
            msg = msg + " executor=" + executor;
            throw new IllegalStateException(msg);
        }
    }

    protected BigDecimal toInternalType(Object value) {
        return DfTypeUtil.toBigDecimal(value);
    }

    protected Object toResultType(BigDecimal value) {
        return DfTypeUtil.toNumber(value, this._resultType);
    }

    protected void log(String msg) {
        XLog.log(msg);
    }

    protected boolean isLogEnabled() {
        return XLog.isLogEnabled();
    }

    public String toString() {
        String hash = Integer.toHexString(this.hashCode());
        return "{type=" + this._resultType + ", cache=" + this._cacheSize + ", increment=" + this._incrementSize + "}@" + hash;
    }

    public static interface SequenceRealExecutor {
        public Object execute();
    }
}

