/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.SimpleMapPmb;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.ckey.ConditionKeyInScope;
import org.seasar.dbflute.cbean.coption.ConditionOption;
import org.seasar.dbflute.cbean.coption.FromToOption;
import org.seasar.dbflute.cbean.coption.LikeSearchOption;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.cbean.sqlclause.SqlClauseMySql;
import org.seasar.dbflute.cbean.sqlclause.SqlClauseOracle;
import org.seasar.dbflute.cbean.sqlclause.orderby.OrderByClause;
import org.seasar.dbflute.cbean.sqlclause.query.QueryClauseArranger;
import org.seasar.dbflute.cbean.sqlclause.subquery.ExistsReferrer;
import org.seasar.dbflute.cbean.sqlclause.subquery.InScopeRelation;
import org.seasar.dbflute.cbean.sqlclause.subquery.QueryDerivedReferrer;
import org.seasar.dbflute.cbean.sqlclause.subquery.ScalarCondition;
import org.seasar.dbflute.cbean.sqlclause.subquery.SpecifyDerivedReferrer;
import org.seasar.dbflute.cbean.sqlclause.subquery.SubQueryLevelReflector;
import org.seasar.dbflute.cbean.sqlclause.subquery.SubQueryPath;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.DBMetaProvider;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.name.ColumnRealName;
import org.seasar.dbflute.dbmeta.name.ColumnRealNameProvider;
import org.seasar.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.dbflute.dbmeta.name.ColumnSqlNameProvider;
import org.seasar.dbflute.dbway.ExtensionOperand;
import org.seasar.dbflute.dbway.WayOfMySQL;
import org.seasar.dbflute.exception.ConditionInvokingFailureException;
import org.seasar.dbflute.exception.thrower.ConditionBeanExceptionThrower;
import org.seasar.dbflute.jdbc.Classification;
import org.seasar.dbflute.jdbc.ParameterUtil;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.DfReflectionUtil;
import org.seasar.dbflute.util.DfSystemUtil;
import org.seasar.dbflute.util.DfTypeUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConditionQuery
implements ConditionQuery {
    protected static final ConditionKey CK_EQ = ConditionKey.CK_EQUAL;
    protected static final ConditionKey CK_NES = ConditionKey.CK_NOT_EQUAL_STANDARD;
    protected static final ConditionKey CK_NET = ConditionKey.CK_NOT_EQUAL_TRADITION;
    protected static final ConditionKey CK_GT = ConditionKey.CK_GREATER_THAN;
    protected static final ConditionKey CK_LT = ConditionKey.CK_LESS_THAN;
    protected static final ConditionKey CK_GE = ConditionKey.CK_GREATER_EQUAL;
    protected static final ConditionKey CK_LE = ConditionKey.CK_LESS_EQUAL;
    protected static final ConditionKey CK_INS = ConditionKey.CK_IN_SCOPE;
    protected static final ConditionKey CK_NINS = ConditionKey.CK_NOT_IN_SCOPE;
    protected static final ConditionKey CK_LS = ConditionKey.CK_LIKE_SEARCH;
    protected static final ConditionKey CK_NLS = ConditionKey.CK_NOT_LIKE_SEARCH;
    protected static final ConditionKey CK_ISN = ConditionKey.CK_IS_NULL;
    protected static final ConditionKey CK_ISNN = ConditionKey.CK_IS_NOT_NULL;
    protected static final Object DOBJ = new Object();
    protected static final String CQ_PROPERTY = "conditionQuery";
    protected final SqlClause _sqlClause;
    protected final String _aliasName;
    protected final int _nestLevel;
    protected int _subQueryLevel;
    protected String _foreignPropertyName;
    protected String _relationPath;
    protected final ConditionQuery _referrerQuery;
    protected boolean _onClauseInline;
    protected SimpleMapPmb<ConditionQuery> _unionQueryMap;
    protected SimpleMapPmb<ConditionQuery> _unionAllQueryMap;

    public AbstractConditionQuery(ConditionQuery referrerQuery, SqlClause sqlClause, String aliasName, int nestLevel) {
        this._referrerQuery = referrerQuery;
        this._sqlClause = sqlClause;
        this._aliasName = aliasName;
        this._nestLevel = nestLevel;
    }

    protected abstract DBMetaProvider getDBMetaProvider();

    protected DBMeta findDBMeta(String tableFlexibleName) {
        return this.getDBMetaProvider().provideDBMetaChecked(tableFlexibleName);
    }

    @Override
    public ConditionQuery getReferrerQuery() {
        return this._referrerQuery;
    }

    @Override
    public SqlClause getSqlClause() {
        return this._sqlClause;
    }

    @Override
    public String getAliasName() {
        return this._aliasName;
    }

    @Override
    public int getNestLevel() {
        return this._nestLevel;
    }

    @Override
    public int getNextNestLevel() {
        return this._nestLevel + 1;
    }

    @Override
    public boolean isBaseQuery() {
        return this.getReferrerQuery() == null;
    }

    @Override
    public int getSubQueryLevel() {
        return this._subQueryLevel;
    }

    @Override
    public String getRealAliasName() {
        return this.getAliasName();
    }

    @Override
    public ColumnRealName toColumnRealName(String columnDbName) {
        return new ColumnRealName(this.getRealAliasName(), this.toColumnSqlName(columnDbName));
    }

    @Override
    public ColumnSqlName toColumnSqlName(String columnDbName) {
        return this.findDBMeta(this.getTableDbName()).findColumnInfo(columnDbName).getColumnSqlName();
    }

    @Override
    public String getForeignPropertyName() {
        return this._foreignPropertyName;
    }

    public void xsetForeignPropertyName(String foreignPropertyName) {
        this._foreignPropertyName = foreignPropertyName;
    }

    @Override
    public String getRelationPath() {
        return this._relationPath;
    }

    public void xsetRelationPath(String relationPath) {
        this._relationPath = relationPath;
    }

    public void xsetOnClauseInline(boolean onClauseInline) {
        this._onClauseInline = onClauseInline;
    }

    protected String getLocation(String propertyName) {
        return this.getLocationBase() + propertyName;
    }

    protected String getLocation(String propertyName, ConditionKey key) {
        return this.getLocation(propertyName) + "." + key.getConditionKey();
    }

    protected String getLocationBase() {
        StringBuilder sb = new StringBuilder();
        ConditionQuery query = this;
        while (true) {
            if (query.isBaseQuery()) break;
            String foreignPropertyName = query.getForeignPropertyName();
            if (foreignPropertyName == null) {
                String msg = "The foreignPropertyName of the query should not be null:";
                msg = msg + " query=" + query;
                throw new IllegalStateException(msg);
            }
            sb.insert(0, CQ_PROPERTY + this.initCap(foreignPropertyName) + ".");
            query = query.getReferrerQuery();
        }
        sb.insert(0, "conditionQuery.");
        return sb.toString();
    }

    public void doNss(NssCall callback) {
        String foreignPropertyName = callback.qf().getForeignPropertyName();
        String foreignTableAliasName = callback.qf().getRealAliasName();
        this.getSqlClause().registerSelectedSelectColumn(foreignTableAliasName, this.getTableDbName(), foreignPropertyName, this.getRelationPath());
        this.getSqlClause().registerSelectedForeignInfo(callback.qf().getRelationPath(), foreignPropertyName);
    }

    protected void registerOuterJoin(ConditionQuery cq, Map<String, String> joinOnMap) {
        this.registerOuterJoin(cq, joinOnMap, null);
    }

    protected void registerOuterJoin(ConditionQuery cq, Map<String, String> joinOnMap, String fixedCondition) {
        String localDbName = this.getTableDbName();
        String foreignDbName = cq.getTableDbName();
        String localAliasName = this.getRealAliasName();
        String foreignAliasName = cq.getRealAliasName();
        if (fixedCondition != null) {
            fixedCondition = this.replaceString(fixedCondition, "$$alias$$", foreignAliasName);
            fixedCondition = this.replaceString(fixedCondition, "$$foreignAlias$$", foreignAliasName);
            fixedCondition = this.replaceString(fixedCondition, "$$localAlias$$", localAliasName);
            fixedCondition = this.replaceString(fixedCondition, "$$locationBase$$.", "pmb." + this.getLocationBase());
        }
        LinkedHashMap<ColumnRealName, ColumnRealName> joinOnRealMap = this.newLinkedHashMap();
        Set<Map.Entry<String, String>> entrySet = joinOnMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String local = entry.getKey();
            String foreign = entry.getValue();
            joinOnRealMap.put(this.toColumnRealName(local), cq.toColumnRealName(foreign));
        }
        this.getSqlClause().registerOuterJoin(localDbName, foreignDbName, foreignAliasName, joinOnRealMap, fixedCondition);
    }

    public SimpleMapPmb<ConditionQuery> getUnionQueryMap() {
        if (this._unionQueryMap == null) {
            this._unionQueryMap = this.xcreateUnionMapPmb();
        }
        return this._unionQueryMap;
    }

    public void xsetUnionQuery(ConditionQuery unionQuery) {
        this.xsetupUnion(unionQuery, false, this.getUnionQueryMap());
    }

    public SimpleMapPmb<ConditionQuery> getUnionAllQueryMap() {
        if (this._unionAllQueryMap == null) {
            this._unionAllQueryMap = this.xcreateUnionMapPmb();
        }
        return this._unionAllQueryMap;
    }

    protected SimpleMapPmb<ConditionQuery> xcreateUnionMapPmb() {
        return new SimpleMapPmb<ConditionQuery>();
    }

    public void xsetUnionAllQuery(ConditionQuery unionAllQuery) {
        this.xsetupUnion(unionAllQuery, true, this.getUnionAllQueryMap());
    }

    protected void xsetupUnion(ConditionQuery unionQuery, boolean unionAll, SimpleMapPmb<ConditionQuery> unionQueryMap) {
        if (unionQuery == null) {
            String msg = "The argument[unionQuery] should not be null.";
            throw new IllegalArgumentException(msg);
        }
        this.reflectRelationOnUnionQuery(this, unionQuery);
        String key = (unionAll ? "unionAllQuery" : "unionQuery") + unionQueryMap.size();
        unionQueryMap.addParameter(key, unionQuery);
        this.registerUnionQuery(unionQuery, unionAll, (unionAll ? "unionAllQueryMap" : "unionQueryMap") + "." + key);
    }

    protected abstract void reflectRelationOnUnionQuery(ConditionQuery var1, ConditionQuery var2);

    public boolean hasUnionQueryOrUnionAllQuery() {
        return this._unionQueryMap != null && !this._unionQueryMap.isEmpty() || this._unionAllQueryMap != null && !this._unionAllQueryMap.isEmpty();
    }

    protected void regQ(ConditionKey key, Object value, ConditionValue cvalue, String columnDbName) {
        if (!this.isValidQuery(key, value, cvalue, columnDbName)) {
            return;
        }
        this.setupConditionValueAndRegisterWhereClause(key, value, cvalue, columnDbName);
    }

    protected void regQ(ConditionKey key, Object value, ConditionValue cvalue, String columnDbName, ConditionOption option) {
        if (!this.isValidQuery(key, value, cvalue, columnDbName)) {
            return;
        }
        this.setupConditionValueAndRegisterWhereClause(key, value, cvalue, columnDbName, option);
    }

    protected boolean isValidQuery(ConditionKey key, Object value, ConditionValue cvalue, String columnDbName) {
        ColumnRealName columnRealName = this.toColumnRealName(columnDbName);
        if (key.isValidRegistration(cvalue, value, columnRealName.toString())) {
            return true;
        }
        if (this.getSqlClause().isCheckInvalidQuery()) {
            this.throwInvalidQueryRegisteredException(key, value, columnRealName);
            return false;
        }
        this.getSqlClause().registerInvalidQueryColumn(columnRealName, key);
        return false;
    }

    protected void throwInvalidQueryRegisteredException(ConditionKey key, Object value, ColumnRealName columnRealName) {
        this.createCBExThrower().throwInvalidQueryRegisteredException(key, value, columnRealName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void regINS(ConditionKey key, List<?> value, ConditionValue cvalue, String columnDbName) {
        if (!this.isValidQuery(key, value, cvalue, columnDbName)) {
            return;
        }
        int inScopeLimit = this.getSqlClause().getInScopeLimit();
        if (inScopeLimit > 0 && value.size() > inScopeLimit) {
            boolean alreadyOrScopeQuery = this.getSqlClause().isOrScopeQueryEffective();
            if (AbstractConditionQuery.isConditionKeyInScope(key)) {
                this.getSqlClause().makeOrScopeQueryEffective();
            } else if (alreadyOrScopeQuery) {
                this.getSqlClause().beginOrScopeQueryAndPart();
            }
            try {
                List<?> objectList = value;
                List<List<?>> valueList = DfCollectionUtil.splitByLimit(objectList, inScopeLimit);
                for (int i = 0; i < valueList.size(); ++i) {
                    List<?> currentValue = valueList.get(i);
                    if (i == 0) {
                        this.setupConditionValueAndRegisterWhereClause(key, currentValue, cvalue, columnDbName);
                        continue;
                    }
                    this.invokeQuery(columnDbName, key.getConditionKey(), currentValue);
                }
            }
            finally {
                if (AbstractConditionQuery.isConditionKeyInScope(key)) {
                    this.getSqlClause().closeOrScopeQuery();
                } else if (alreadyOrScopeQuery) {
                    this.getSqlClause().endOrScopeQueryAndPart();
                }
            }
        } else {
            this.setupConditionValueAndRegisterWhereClause(key, value, cvalue, columnDbName);
        }
    }

    static boolean isConditionKeyInScope(ConditionKey key) {
        return ConditionKeyInScope.class.isAssignableFrom(key.getClass());
    }

    protected void regFTQ(Date fromDate, Date toDate, ConditionValue cvalue, String columnDbName, FromToOption option) {
        Date filteredToDate;
        ConditionKey toKey;
        Date filteredFromDate;
        ConditionKey fromKey = option.getFromDateConditionKey();
        if (this.isValidQuery(fromKey, filteredFromDate = option.filterFromDate(fromDate), cvalue, columnDbName)) {
            this.setupConditionValueAndRegisterWhereClause(fromKey, filteredFromDate, cvalue, columnDbName);
        }
        if (this.isValidQuery(toKey = option.getToDateConditionKey(), filteredToDate = option.filterToDate(toDate), cvalue, columnDbName)) {
            this.setupConditionValueAndRegisterWhereClause(toKey, filteredToDate, cvalue, columnDbName);
        }
    }

    protected void regLSQ(ConditionKey key, String value, ConditionValue cvalue, String columnDbName, LikeSearchOption option) {
        this.registerLikeSearchQuery(key, value, cvalue, columnDbName, option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerLikeSearchQuery(ConditionKey key, String value, ConditionValue cvalue, String columnDbName, LikeSearchOption option) {
        if (option == null) {
            this.throwLikeSearchOptionNotFoundException(columnDbName, value);
            return;
        }
        if (!this.isValidQuery(key, value, cvalue, columnDbName)) {
            return;
        }
        if (this.xsuppressEscape()) {
            option.notEscape();
        }
        if (value == null || !option.isSplit()) {
            this.setupConditionValueAndRegisterWhereClause(key, value, cvalue, columnDbName, option);
            return;
        }
        String[] strArray = option.generateSplitValueArray(value);
        boolean alreadyOrScopeQuery = this.getSqlClause().isOrScopeQueryEffective();
        if (!option.isAsOrSplit()) {
            if (alreadyOrScopeQuery) {
                this.getSqlClause().beginOrScopeQueryAndPart();
            }
            try {
                for (int i = 0; i < strArray.length; ++i) {
                    String currentValue = strArray[i];
                    this.setupConditionValueAndRegisterWhereClause(key, currentValue, cvalue, columnDbName, option);
                }
            }
            finally {
                if (alreadyOrScopeQuery) {
                    this.getSqlClause().endOrScopeQueryAndPart();
                }
            }
        }
        if (!alreadyOrScopeQuery) {
            this.getSqlClause().makeOrScopeQueryEffective();
        }
        try {
            for (int i = 0; i < strArray.length; ++i) {
                String currentValue = strArray[i];
                if (i == 0) {
                    this.setupConditionValueAndRegisterWhereClause(key, currentValue, cvalue, columnDbName, option);
                    continue;
                }
                this.invokeQueryLikeSearch(columnDbName, currentValue, option);
            }
        }
        finally {
            if (!alreadyOrScopeQuery) {
                this.getSqlClause().closeOrScopeQuery();
            }
        }
    }

    protected boolean xsuppressEscape() {
        return false;
    }

    protected void throwLikeSearchOptionNotFoundException(String columnDbName, String value) {
        DBMeta dbmeta = this.getDBMetaProvider().provideDBMeta(this.getTableDbName());
        this.createCBExThrower().throwLikeSearchOptionNotFoundException(columnDbName, value, dbmeta);
    }

    protected void invokeQueryLikeSearch(String columnFlexibleName, Object value, LikeSearchOption option) {
        this.invokeQuery(columnFlexibleName, "likeSearch", value, option);
    }

    protected void regIQ(ConditionKey key, Object value, ConditionValue cvalue, String columnDbName) {
        if (!this.isValidQuery(key, value, cvalue, columnDbName)) {
            return;
        }
        DBMeta dbmeta = this.getDBMetaProvider().provideDBMetaChecked(this.getTableDbName());
        ColumnInfo columnInfo = dbmeta.findColumnInfo(columnDbName);
        String propertyName = columnInfo.getPropertyName();
        String uncapPropName = this.initUncap(propertyName);
        key.setupConditionValue(cvalue, value, this.getLocation(uncapPropName, key));
        ColumnSqlName columnSqlName = columnInfo.getColumnSqlName();
        if (this.isBaseQuery()) {
            this.getSqlClause().registerBaseTableInlineWhereClause(columnSqlName, key, cvalue);
        } else {
            String aliasName = this.getRealAliasName();
            this.getSqlClause().registerOuterJoinInlineWhereClause(aliasName, columnSqlName, key, cvalue, this._onClauseInline);
        }
    }

    protected void regIQ(ConditionKey key, Object value, ConditionValue cvalue, String columnDbName, ConditionOption option) {
        if (!this.isValidQuery(key, value, cvalue, columnDbName)) {
            return;
        }
        DBMeta dbmeta = this.getDBMetaProvider().provideDBMetaChecked(this.getTableDbName());
        ColumnInfo columnInfo = dbmeta.findColumnInfo(columnDbName);
        String propertyName = columnInfo.getPropertyName();
        String uncapPropName = this.initUncap(propertyName);
        key.setupConditionValue(cvalue, value, this.getLocation(uncapPropName, key), option);
        ColumnSqlName columnSqlName = columnInfo.getColumnSqlName();
        if (this.isBaseQuery()) {
            this.getSqlClause().registerBaseTableInlineWhereClause(columnSqlName, key, cvalue, option);
        } else {
            String aliasName = this.getRealAliasName();
            this.getSqlClause().registerOuterJoinInlineWhereClause(aliasName, columnSqlName, key, cvalue, option, this._onClauseInline);
        }
    }

    protected void registerExistsReferrer(ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName) {
        this.registerExistsReferrer(subQuery, columnDbName, relatedColumnDbName, propertyName, null);
    }

    protected void registerNotExistsReferrer(ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName) {
        this.registerExistsReferrer(subQuery, columnDbName, relatedColumnDbName, propertyName, "not");
    }

    protected void registerExistsReferrer(final ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName, String existsOption) {
        this.assertObjectNotNull("ExistsReferrer(" + columnDbName + ")", subQuery);
        SqlClause sqlClause = this.getSqlClause();
        SubQueryPath subQueryPath = new SubQueryPath(this.getLocation(propertyName));
        GeneralColumnRealNameProvider localRealNameProvider = new GeneralColumnRealNameProvider();
        int subQueryLevel = subQuery.getSubQueryLevel();
        SqlClause subQueryClause = subQuery.getSqlClause();
        GeneralSubQueryLevelReflector reflector = new GeneralSubQueryLevelReflector();
        String subQueryIdentity = propertyName + "[" + subQueryLevel + "]";
        ColumnSqlNameProvider subQuerySqlNameProvider = new ColumnSqlNameProvider(){

            public ColumnSqlName provide(String columnDbName) {
                return subQuery.toColumnSqlName(columnDbName);
            }
        };
        DBMeta subQueryDBMeta = this.findDBMeta(subQuery.getTableDbName());
        ExistsReferrer existsReferrer = new ExistsReferrer(sqlClause, subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQueryClause, reflector, subQueryIdentity, subQueryDBMeta);
        String clause = existsReferrer.buildExistsReferrer(columnDbName, relatedColumnDbName, existsOption);
        this.registerWhereClause(clause);
    }

    protected void registerInScopeRelation(ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName) {
        this.registerInScopeRelation(subQuery, columnDbName, relatedColumnDbName, propertyName, null);
    }

    protected void registerNotInScopeRelation(ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName) {
        this.registerInScopeRelation(subQuery, columnDbName, relatedColumnDbName, propertyName, "not");
    }

    protected void registerInScopeRelation(final ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName, String inScopeOption) {
        this.assertObjectNotNull("InScopeRelation(" + columnDbName + ")", subQuery);
        SqlClause sqlClause = this.getSqlClause();
        SubQueryPath subQueryPath = new SubQueryPath(this.getLocation(propertyName));
        GeneralColumnRealNameProvider localRealNameProvider = new GeneralColumnRealNameProvider();
        int subQueryLevel = subQuery.getSubQueryLevel();
        SqlClause subQueryClause = subQuery.getSqlClause();
        GeneralSubQueryLevelReflector reflector = new GeneralSubQueryLevelReflector();
        String subQueryIdentity = propertyName + "[" + subQueryLevel + "]";
        ColumnSqlNameProvider subQuerySqlNameProvider = new ColumnSqlNameProvider(){

            public ColumnSqlName provide(String columnDbName) {
                return subQuery.toColumnSqlName(columnDbName);
            }
        };
        DBMeta subQueryDBMeta = this.findDBMeta(subQuery.getTableDbName());
        boolean suppressLocalAliasName = this.isInScopeRelationSuppressLocalAliasName();
        InScopeRelation inScopeRelation = new InScopeRelation(sqlClause, subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQueryClause, reflector, subQueryIdentity, subQueryDBMeta, suppressLocalAliasName);
        String clause = inScopeRelation.buildInScopeRelation(columnDbName, relatedColumnDbName, inScopeOption);
        this.registerWhereClause(clause);
    }

    protected boolean isInScopeRelationSuppressLocalAliasName() {
        return false;
    }

    protected void registerSpecifyDerivedReferrer(String function, final ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName, String aliasName) {
        this.assertObjectNotNull("SpecifyDerivedReferrer(function)", function);
        this.assertObjectNotNull("SpecifyDerivedReferrer(" + columnDbName + ")", subQuery);
        SqlClause sqlClause = this.getSqlClause();
        SubQueryPath subQueryPath = new SubQueryPath(this.getLocation(propertyName));
        GeneralColumnRealNameProvider localRealNameProvider = new GeneralColumnRealNameProvider();
        int subQueryLevel = subQuery.getSubQueryLevel();
        SqlClause subQueryClause = subQuery.getSqlClause();
        GeneralSubQueryLevelReflector reflector = new GeneralSubQueryLevelReflector();
        String subQueryIdentity = propertyName + "[" + subQueryLevel + "]";
        ColumnSqlNameProvider subQuerySqlNameProvider = new ColumnSqlNameProvider(){

            public ColumnSqlName provide(String columnDbName) {
                return subQuery.toColumnSqlName(columnDbName);
            }
        };
        DBMeta subQueryDBMeta = this.findDBMeta(subQuery.getTableDbName());
        String mainSubQueryIdentity = propertyName + "[" + subQueryLevel + ":subquerymain]";
        SpecifyDerivedReferrer derivedReferrer = new SpecifyDerivedReferrer(sqlClause, subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQueryClause, reflector, subQueryIdentity, subQueryDBMeta, mainSubQueryIdentity, aliasName);
        String clause = derivedReferrer.buildDerivedReferrer(function, columnDbName, relatedColumnDbName);
        this.getSqlClause().specifyDerivingSubQuery(aliasName, clause);
    }

    protected void registerQueryDerivedReferrer(String function, final ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName, String operand, Object value, String parameterPropertyName) {
        this.assertObjectNotNull("QueryDerivedReferrer(function)", function);
        this.assertObjectNotNull("QueryDerivedReferrer(" + columnDbName + ")", subQuery);
        SqlClause sqlClause = this.getSqlClause();
        SubQueryPath subQueryPath = new SubQueryPath(this.getLocation(propertyName));
        GeneralColumnRealNameProvider localRealNameProvider = new GeneralColumnRealNameProvider();
        int subQueryLevel = subQuery.getSubQueryLevel();
        SqlClause subQueryClause = subQuery.getSqlClause();
        GeneralSubQueryLevelReflector reflector = new GeneralSubQueryLevelReflector();
        String subQueryIdentity = propertyName + "[" + subQueryLevel + "]";
        ColumnSqlNameProvider subQuerySqlNameProvider = new ColumnSqlNameProvider(){

            public ColumnSqlName provide(String columnDbName) {
                return subQuery.toColumnSqlName(columnDbName);
            }
        };
        DBMeta subQueryDBMeta = this.findDBMeta(subQuery.getTableDbName());
        String mainSubQueryIdentity = propertyName + "[" + subQueryLevel + ":subquerymain]";
        String parameterPath = this.getLocation(parameterPropertyName);
        QueryDerivedReferrer derivedReferrer = new QueryDerivedReferrer(sqlClause, subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQueryClause, reflector, subQueryIdentity, subQueryDBMeta, mainSubQueryIdentity, operand, value, parameterPath);
        String clause = derivedReferrer.buildDerivedReferrer(function, columnDbName, relatedColumnDbName);
        this.registerWhereClause(clause);
    }

    protected void registerScalarCondition(String function, final ConditionQuery subQuery, String propertyName, String operand) {
        this.assertObjectNotNull("ScalarCondition(" + propertyName + ")", subQuery);
        SqlClause sqlClause = this.getSqlClause();
        SubQueryPath subQueryPath = new SubQueryPath(this.getLocation(propertyName));
        GeneralColumnRealNameProvider localRealNameProvider = new GeneralColumnRealNameProvider();
        int subQueryLevel = subQuery.getSubQueryLevel();
        SqlClause subQueryClause = subQuery.getSqlClause();
        GeneralSubQueryLevelReflector reflector = new GeneralSubQueryLevelReflector();
        String subQueryIdentity = propertyName + "[" + subQueryLevel + "]";
        ColumnSqlNameProvider subQuerySqlNameProvider = new ColumnSqlNameProvider(){

            public ColumnSqlName provide(String columnDbName) {
                return subQuery.toColumnSqlName(columnDbName);
            }
        };
        DBMeta subQueryDBMeta = this.findDBMeta(subQuery.getTableDbName());
        String mainSubQueryIdentity = propertyName + "[" + subQueryLevel + ":subquerymain]";
        ScalarCondition scalarCondition = new ScalarCondition(sqlClause, subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQueryClause, reflector, subQueryIdentity, subQueryDBMeta, mainSubQueryIdentity, operand);
        String clause = scalarCondition.buildScalarCondition(function);
        this.registerWhereClause(clause);
    }

    protected void setupConditionValueAndRegisterWhereClause(ConditionKey key, Object value, ConditionValue cvalue, String columnDbName) {
        DBMeta dbmeta = this.getDBMetaProvider().provideDBMetaChecked(this.getTableDbName());
        ColumnInfo columnInfo = dbmeta.findColumnInfo(columnDbName);
        String propertyName = columnInfo.getPropertyName();
        String uncapPropName = this.initUncap(propertyName);
        key.setupConditionValue(cvalue, value, this.getLocation(uncapPropName, key));
        this.getSqlClause().registerWhereClause(this.toColumnRealName(columnInfo.getColumnDbName()), key, cvalue);
    }

    protected void setupConditionValueAndRegisterWhereClause(ConditionKey key, Object value, ConditionValue cvalue, String columnDbName, ConditionOption option) {
        DBMeta dbmeta = this.getDBMetaProvider().provideDBMetaChecked(this.getTableDbName());
        ColumnInfo columnInfo = dbmeta.findColumnInfo(columnDbName);
        String propertyName = columnInfo.getPropertyName();
        String uncapPropName = this.initUncap(propertyName);
        key.setupConditionValue(cvalue, value, this.getLocation(uncapPropName, key), option);
        this.getSqlClause().registerWhereClause(this.toColumnRealName(columnInfo.getColumnDbName()), key, cvalue, option);
    }

    protected void registerWhereClause(String whereClause) {
        this.getSqlClause().registerWhereClause(whereClause);
    }

    protected void registerInlineWhereClause(String whereClause) {
        if (this.isBaseQuery()) {
            this.getSqlClause().registerBaseTableInlineWhereClause(whereClause);
        } else {
            this.getSqlClause().registerOuterJoinInlineWhereClause(this.getRealAliasName(), whereClause, this._onClauseInline);
        }
    }

    public void registerUnionQuery(ConditionQuery unionQuery, boolean unionAll, String unionQueryPropertyName) {
        String unionQueryClause = this.getUnionQuerySql(unionQuery, unionQueryPropertyName);
        this.getSqlClause().registerUnionQuery(unionQueryClause, unionAll);
    }

    protected String getUnionQuerySql(ConditionQuery unionQuery, String unionQueryPropertyName) {
        String unionQueryClause;
        String fromClause = unionQuery.getSqlClause().getFromClause();
        String whereClause = unionQuery.getSqlClause().getWhereClause();
        if (whereClause.trim().length() <= 0) {
            unionQueryClause = fromClause + " " + this.getSqlClause().getUnionWhereClauseMark();
        } else {
            int whereIndex = whereClause.indexOf("where ");
            if (whereIndex < 0) {
                String msg = "The whereClause should have 'where' string: " + whereClause;
                throw new IllegalStateException(msg);
            }
            int clauseIndex = whereIndex + "where ".length();
            String mark = this.getSqlClause().getUnionWhereFirstConditionMark();
            String markedClause = whereClause.substring(0, clauseIndex) + mark + whereClause.substring(clauseIndex);
            unionQueryClause = fromClause + " " + markedClause;
        }
        String oldStr = ".conditionQuery.";
        String newStr = ".conditionQuery." + unionQueryPropertyName + ".";
        return this.replaceString(unionQueryClause, ".conditionQuery.", newStr);
    }

    public void innerJoin() {
        if (this.isBaseQuery()) {
            String msg = "Look! Read the message below." + this.ln();
            msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
            msg = msg + "The method 'innerJoin()' should be called for a relation query!" + this.ln();
            msg = msg + this.ln();
            msg = msg + "[Advice]" + this.ln();
            msg = msg + "Please confirm your program. " + this.ln();
            msg = msg + "  For example:" + this.ln();
            msg = msg + "    (x) - cb.query().innerJoin();" + this.ln();
            msg = msg + "    (o) - cb.query().queryMemberStatusCode().innerJoin();" + this.ln();
            msg = msg + "* * * * * * * * * */";
            throw new IllegalStateException(msg);
        }
        this.getSqlClause().changeToInnerJoin(this.getRealAliasName());
    }

    protected void registerOrderBy(String columnDbName, boolean ascOrDesc) {
        this.getSqlClause().registerOrderBy(this.toColumnRealName(columnDbName).toString(), ascOrDesc);
    }

    protected void regOBA(String columnName) {
        this.assertOrderByPurpose(columnName);
        this.registerOrderBy(columnName, true);
    }

    protected void regOBD(String columnName) {
        this.assertOrderByPurpose(columnName);
        this.registerOrderBy(columnName, false);
    }

    protected void assertOrderByPurpose(String columnName) {
        if (this.getSqlClause().getPurpose().isNoOrderBy()) {
            this.throwOrderByIllegalPurposeException(columnName);
        }
    }

    protected void throwOrderByIllegalPurposeException(String columnName) {
        this.createCBExThrower().throwOrderByIllegalPurposeException(this.getSqlClause().getPurpose(), this.getTableDbName(), columnName);
    }

    public void withNullsFirst() {
        this.getSqlClause().addNullsFirstToPreviousOrderBy();
    }

    public void withNullsLast() {
        this.getSqlClause().addNullsLastToPreviousOrderBy();
    }

    public void withManualOrder(List<? extends Object> manualValueList) {
        this.assertObjectNotNull("withManualOrder(manualValueList)", manualValueList);
        OrderByClause.ManumalOrderInfo manumalOrderInfo = new OrderByClause.ManumalOrderInfo();
        manumalOrderInfo.setManualValueList(manualValueList);
        this.getSqlClause().addManualOrderToPreviousOrderByElement(manumalOrderInfo);
    }

    protected void registerSpecifiedDerivedOrderBy_Asc(String aliasName) {
        if (!this.getSqlClause().hasSpecifiedDerivingSubQuery(aliasName)) {
            this.throwSpecifiedDerivedOrderByAliasNameNotFoundException(aliasName);
        }
        this.getSqlClause().registerOrderBy(aliasName, true);
    }

    protected void registerSpecifiedDerivedOrderBy_Desc(String aliasName) {
        if (!this.getSqlClause().hasSpecifiedDerivingSubQuery(aliasName)) {
            this.throwSpecifiedDerivedOrderByAliasNameNotFoundException(aliasName);
        }
        this.getSqlClause().registerOrderBy(aliasName, false);
    }

    protected void throwSpecifiedDerivedOrderByAliasNameNotFoundException(String aliasName) {
        this.createCBExThrower().throwSpecifiedDerivedOrderByAliasNameNotFoundException(aliasName);
    }

    protected String resolveJoinAliasName(String relationPath, int nestLevel) {
        return this.getSqlClause().resolveJoinAliasName(relationPath, nestLevel);
    }

    protected String resolveNestLevelExpression(String name) {
        return this.getSqlClause().resolveNestLevelExpression(name, this.getNestLevel());
    }

    protected String resolveNextRelationPath(String tableName, String relationPropertyName) {
        int relationNo = this.getSqlClause().resolveRelationNo(tableName, relationPropertyName);
        String nextRelationPath = "_" + relationNo;
        if (this._relationPath != null) {
            nextRelationPath = this._relationPath + nextRelationPath;
        }
        return nextRelationPath;
    }

    @Override
    public ConditionValue invokeValue(String columnFlexibleName) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFlexibleName", columnFlexibleName);
        DBMeta dbmeta = this.findDBMeta(this.getTableDbName());
        String columnCapPropName = this.initCap(dbmeta.findPropertyName(columnFlexibleName));
        String methodName = "get" + columnCapPropName;
        Method method = this.helpGettingCQMethod(this, methodName, new Class[0]);
        if (method == null) {
            String msg = "Not found the method for getting value:";
            msg = msg + " columnFlexibleName=" + columnFlexibleName;
            msg = msg + " methodName=" + methodName;
            throw new ConditionInvokingFailureException(msg);
        }
        try {
            return (ConditionValue)this.helpInvokingCQMethod(this, method, new Object[0]);
        }
        catch (DfReflectionUtil.ReflectionFailureException e) {
            String msg = "Failed to invoke the method for getting value:";
            msg = msg + " columnFlexibleName=" + columnFlexibleName;
            msg = msg + " methodName=" + methodName;
            throw new ConditionInvokingFailureException(msg, e);
        }
    }

    @Override
    public void invokeQuery(String columnFlexibleName, String conditionKeyName, Object value) {
        this.doInvokeQuery(columnFlexibleName, conditionKeyName, value, null);
    }

    @Override
    public void invokeQuery(String columnFlexibleName, String conditionKeyName, Object value, ConditionOption option) {
        this.assertObjectNotNull("option", option);
        this.doInvokeQuery(columnFlexibleName, conditionKeyName, value, option);
    }

    protected void doInvokeQuery(String columnFlexibleName, String conditionKeyName, Object value, ConditionOption option) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFlexibleName", columnFlexibleName);
        this.assertStringNotNullAndNotTrimmedEmpty("conditionKeyName", conditionKeyName);
        if (value == null) {
            return;
        }
        PropertyNameCQContainer container = this.helpExtractingPropertyNameCQContainer(columnFlexibleName);
        String propertyName = container.getPropertyName();
        ConditionQuery cq = container.getConditionQuery();
        DBMeta dbmeta = this.findDBMeta(cq.getTableDbName());
        String columnCapPropName = this.initCap(dbmeta.findPropertyName(propertyName));
        String methodName = "set" + columnCapPropName + "_" + this.initCap(conditionKeyName);
        Class<?> type = value.getClass();
        Class[] parameterTypes = option != null ? new Class[]{type, option.getClass()} : new Class[]{type};
        Method method = this.helpGettingCQMethod(cq, methodName, parameterTypes);
        if (method == null) {
            String msg = "Not found the method for setting a condition(query):";
            msg = msg + " columnFlexibleName=" + columnFlexibleName;
            msg = msg + " conditionKeyName=" + conditionKeyName;
            msg = msg + " value=" + value;
            msg = msg + " option=" + option;
            msg = msg + " methodName=" + methodName;
            throw new ConditionInvokingFailureException(msg);
        }
        try {
            Object[] args = option != null ? new Object[]{value, option} : new Object[]{value};
            this.helpInvokingCQMethod(cq, method, args);
        }
        catch (DfReflectionUtil.ReflectionFailureException e) {
            String msg = "Failed to invoke the method for setting a condition(query):";
            msg = msg + " columnFlexibleName=" + columnFlexibleName;
            msg = msg + " conditionKeyName=" + conditionKeyName;
            msg = msg + " value=" + value;
            msg = msg + " option=" + option;
            msg = msg + " methodName=" + methodName;
            throw new ConditionInvokingFailureException(msg, e);
        }
    }

    @Override
    public void invokeQueryEqual(String columnFlexibleName, Object value) {
        this.invokeQuery(columnFlexibleName, CK_EQ.getConditionKey(), value);
    }

    @Override
    public void invokeOrderBy(String columnFlexibleName, boolean isAsc) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFlexibleName", columnFlexibleName);
        PropertyNameCQContainer container = this.helpExtractingPropertyNameCQContainer(columnFlexibleName);
        String propertyName = container.getPropertyName();
        ConditionQuery cq = container.getConditionQuery();
        String ascDesc = isAsc ? "Asc" : "Desc";
        DBMeta dbmeta = this.findDBMeta(cq.getTableDbName());
        String columnCapPropName = this.initCap(dbmeta.findPropertyName(propertyName));
        String methodName = "addOrderBy_" + columnCapPropName + "_" + ascDesc;
        Method method = this.helpGettingCQMethod(cq, methodName, new Class[0]);
        if (method == null) {
            String msg = "Not found the method for adding a order-by condition:";
            msg = msg + " columnFlexibleName=" + columnFlexibleName;
            msg = msg + " isAsc=" + isAsc;
            msg = msg + " methodName=" + methodName;
            throw new ConditionInvokingFailureException(msg);
        }
        this.helpInvokingCQMethod(cq, method, new Object[0]);
        try {
            this.helpInvokingCQMethod(cq, method, new Object[0]);
        }
        catch (DfReflectionUtil.ReflectionFailureException e) {
            String msg = "Failed to invoke the method for setting a condition(query):";
            msg = msg + " columnFlexibleName=" + columnFlexibleName;
            msg = msg + " isAsc=" + isAsc;
            msg = msg + " methodName=" + methodName;
            throw new ConditionInvokingFailureException(msg, e);
        }
    }

    @Override
    public ConditionQuery invokeForeignCQ(String foreignPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("foreignPropertyName", foreignPropertyName);
        String methodName = "query" + this.initCap(foreignPropertyName);
        Method method = this.helpGettingCQMethod(this, methodName, new Class[0]);
        if (method == null) {
            String msg = "Not found the method for getting a foreign condition query:";
            msg = msg + " foreignPropertyName=" + foreignPropertyName;
            msg = msg + " methodName=" + methodName;
            throw new ConditionInvokingFailureException(msg);
        }
        try {
            return (ConditionQuery)this.helpInvokingCQMethod(this, method, new Object[0]);
        }
        catch (DfReflectionUtil.ReflectionFailureException e) {
            String msg = "Failed to invoke the method for setting a condition(query):";
            msg = msg + " foreignPropertyName=" + foreignPropertyName;
            msg = msg + " methodName=" + methodName;
            throw new ConditionInvokingFailureException(msg, e);
        }
    }

    private PropertyNameCQContainer helpExtractingPropertyNameCQContainer(String name) {
        String[] strings = name.split("\\.");
        int length = strings.length;
        String propertyName = null;
        ConditionQuery cq = this;
        int index = 0;
        for (String element : strings) {
            if (length == index + 1) {
                propertyName = element;
                break;
            }
            cq = cq.invokeForeignCQ(element);
            ++index;
        }
        return new PropertyNameCQContainer(propertyName, cq);
    }

    private Method helpGettingCQMethod(ConditionQuery cq, String methodName, Class<?>[] argTypes) {
        Class<?> clazz = cq.getClass();
        Method method = DfReflectionUtil.getAccessibleMethod(clazz, methodName, argTypes);
        if (method == null && argTypes != null) {
            Class<?> superType;
            if (argTypes.length == 1 && Collection.class.isAssignableFrom(argTypes[0])) {
                method = DfReflectionUtil.getAccessibleMethod(clazz, methodName, new Class[]{Collection.class});
            } else if (argTypes.length == 2 && ConditionOption.class.isAssignableFrom(argTypes[1])) {
                Class<?> superType2 = argTypes[1].getSuperclass();
                method = DfReflectionUtil.getAccessibleMethod(clazz, methodName, new Class[]{superType2});
                if (method == null) {
                    superType2 = argTypes[1].getSuperclass();
                    method = DfReflectionUtil.getAccessibleMethod(clazz, methodName, new Class[]{superType2});
                }
            } else if (argTypes.length == 3 && ConditionOption.class.isAssignableFrom(argTypes[2]) && (method = DfReflectionUtil.getAccessibleMethod(clazz, methodName, new Class[]{superType = argTypes[2].getSuperclass()})) == null) {
                superType = argTypes[2].getSuperclass();
                method = DfReflectionUtil.getAccessibleMethod(clazz, methodName, new Class[]{superType});
            }
        }
        return method;
    }

    private Object helpInvokingCQMethod(ConditionQuery cq, Method method, Object[] args) {
        return DfReflectionUtil.invokeForcedly(method, cq, args);
    }

    protected ConditionValue nCV() {
        return this.newConditionValue();
    }

    protected ConditionValue newConditionValue() {
        return new ConditionValue();
    }

    protected String fRES(String value) {
        return this.filterRemoveEmptyString(value);
    }

    private String filterRemoveEmptyString(String value) {
        return value != null && !"".equals(value) ? value : null;
    }

    protected Date fCTPD(Date date) {
        return this.filterConvertToPureDate(date);
    }

    private Date filterConvertToPureDate(Date date) {
        return DfTypeUtil.toDate(date);
    }

    protected LikeSearchOption cLSOP() {
        return new LikeSearchOption().likePrefix();
    }

    protected <PROPERTY extends Number> PROPERTY cTNum(Object obj, Class<PROPERTY> type) {
        return (PROPERTY)DfTypeUtil.toNumber(obj, type);
    }

    protected <PROPERTY> List<PROPERTY> cTL(Collection<PROPERTY> col) {
        return this.convertToList(col);
    }

    protected List<String> cTStrL(Collection<? extends Classification> col) {
        ArrayList<String> list = new ArrayList<String>();
        for (Classification classification : col) {
            list.add(classification.code());
        }
        return list;
    }

    protected <PROPERTY extends Number> List<PROPERTY> cTNumL(Collection<? extends Classification> col, Class<PROPERTY> type) {
        ArrayList<Number> list = new ArrayList<Number>();
        for (Classification classification : col) {
            Number value = DfTypeUtil.toNumber(classification.code(), type);
            list.add(value);
        }
        return list;
    }

    private <PROPERTY> List<PROPERTY> convertToList(Collection<PROPERTY> col) {
        if (col == null) {
            return null;
        }
        if (col instanceof List) {
            return this.filterRemoveNullOrEmptyValueFromList((List)col);
        }
        return this.filterRemoveNullOrEmptyValueFromList(new ArrayList<PROPERTY>(col));
    }

    private <PROPERTY_TYPE> List<PROPERTY_TYPE> filterRemoveNullOrEmptyValueFromList(List<PROPERTY_TYPE> ls) {
        if (ls == null) {
            return null;
        }
        ArrayList<PROPERTY_TYPE> newList = new ArrayList<PROPERTY_TYPE>();
        for (PROPERTY_TYPE element : ls) {
            if (element == null || element instanceof String && ((String)element).length() == 0) continue;
            newList.add(element);
        }
        return newList;
    }

    protected String hSC(String columnName, String value, Integer size, String modeCode) {
        ParameterUtil.ShortCharHandlingMode mode = ParameterUtil.ShortCharHandlingMode.codeOf(modeCode);
        if (mode == null) {
            String msg = "The mode was not found by the code: ";
            msg = msg + " columnName=" + columnName + " modeCode=" + modeCode;
            throw new IllegalStateException(msg);
        }
        return ParameterUtil.handleShortChar(columnName, value, size, mode);
    }

    protected void xdoMatchForMySQL(List<ColumnInfo> textColumnList, String conditionValue, WayOfMySQL.FullTextSearchModifier modifier) {
        if (conditionValue == null || conditionValue.length() == 0) {
            return;
        }
        String clause = ((SqlClauseMySql)this.getSqlClause()).buildMatchCondition(textColumnList, conditionValue, modifier, this.getTableDbName(), this.getRealAliasName());
        this.registerWhereClause(clause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void xdoMatchByLikeSearch(List<ColumnInfo> textColumnList, String conditionValue) {
        if (conditionValue == null || conditionValue.length() == 0) {
            return;
        }
        this.assertObjectNotNull("textColumnList", textColumnList);
        if (textColumnList.isEmpty()) {
            String msg = "The argument 'textColumnList' should not be empty list.";
            throw new IllegalArgumentException(msg);
        }
        conditionValue = this.xescapeFullTextSearchValue(conditionValue);
        int index = 0;
        this.getSqlClause().makeOrScopeQueryEffective();
        try {
            for (ColumnInfo columnInfo : textColumnList) {
                if (columnInfo == null) continue;
                String tableOfColumn = columnInfo.getDBMeta().getTableDbName();
                if (!tableOfColumn.equalsIgnoreCase(this.getTableDbName())) {
                    String msg = "The table of the text column should be '" + this.getTableDbName() + "'";
                    msg = msg + " but the table is '" + tableOfColumn + "': column=" + columnInfo;
                    throw new IllegalArgumentException(msg);
                }
                if (!columnInfo.isPropertyTypeString()) {
                    String msg = "The text column should be String type:";
                    msg = msg + " column=" + columnInfo;
                    throw new IllegalArgumentException(msg);
                }
                this.invokeQueryLikeSearch(columnInfo.getColumnDbName(), conditionValue, this.xcreateMatchLikeSearch());
                ++index;
            }
        }
        finally {
            this.getSqlClause().closeOrScopeQuery();
        }
    }

    protected String xescapeFullTextSearchValue(String conditionValue) {
        String msg = "You should override this method.";
        throw new UnsupportedOperationException(msg);
    }

    protected String xescapeOracleFullTextSearchValue(String conditionValue) {
        return ((SqlClauseOracle)this.getSqlClause()).escapeFullTextSearchValue(conditionValue);
    }

    protected LikeSearchOption xcreateMatchLikeSearch() {
        String msg = "You should override this method.";
        throw new UnsupportedOperationException(msg);
    }

    protected LikeSearchOption xcreatePostgreSQLMatchLikeSearch() {
        return new PostgreSQLMatchLikeSearch();
    }

    protected ExtensionOperand xgetPostgreSQLMatchOperand() {
        String msg = "You should override this method.";
        throw new UnsupportedOperationException(msg);
    }

    protected LikeSearchOption xcreateOracleMatchLikeSearch() {
        return new OracleMatchLikeSearch();
    }

    protected ConditionBeanExceptionThrower createCBExThrower() {
        return new ConditionBeanExceptionThrower();
    }

    protected final String replaceString(String text, String fromText, String toText) {
        return Srl.replace(text, fromText, toText);
    }

    protected String initCap(String str) {
        return Srl.initCap(str);
    }

    protected String initUncap(String str) {
        return Srl.initUncap(str);
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    protected <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    protected <ELEMENT> ArrayList<ELEMENT> newArrayList() {
        return new ArrayList();
    }

    protected <ELEMENT> ArrayList<ELEMENT> newArrayList(ELEMENT element) {
        ArrayList<ELEMENT> arrayList = new ArrayList<ELEMENT>();
        arrayList.add(element);
        return arrayList;
    }

    protected <ELEMENT> ArrayList<ELEMENT> newArrayList(Collection<ELEMENT> collection) {
        return new ArrayList<ELEMENT>(collection);
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertColumnName(String columnName) {
        if (columnName == null) {
            String msg = "The columnName should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (columnName.trim().length() == 0) {
            String msg = "The columnName should not be empty-string.";
            throw new IllegalArgumentException(msg);
        }
        if (columnName.indexOf(",") >= 0) {
            String msg = "The columnName should not contain comma ',': " + columnName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertAliasName(String aliasName) {
        if (aliasName == null) {
            String msg = "The aliasName should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (aliasName.trim().length() == 0) {
            String msg = "The aliasName should not be empty-string.";
            throw new IllegalArgumentException(msg);
        }
        if (aliasName.indexOf(",") >= 0) {
            String msg = "The aliasName should not contain comma ',': " + aliasName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull("value", value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    public String toString() {
        String titleName = DfTypeUtil.toClassTitle(this);
        return titleName + ":{aliasName=" + this._aliasName + ", nestLevel=" + this._nestLevel + ", subQueryLevel=" + this._subQueryLevel + ", foreignPropertyName=" + this._foreignPropertyName + ", relationPath=" + this._relationPath + ", onClauseInline=" + this._onClauseInline + "}";
    }

    public class OracleMatchLikeSearch
    extends LikeSearchOption {
        private static final long serialVersionUID = 1L;

        public QueryClauseArranger getWhereClauseArranger() {
            return ((SqlClauseOracle)AbstractConditionQuery.this.getSqlClause()).createFullTextSearchClauseArranger();
        }
    }

    public class PostgreSQLMatchLikeSearch
    extends LikeSearchOption {
        private static final long serialVersionUID = 1L;

        public ExtensionOperand getExtensionOperand() {
            return AbstractConditionQuery.this.xgetPostgreSQLMatchOperand();
        }
    }

    private static class PropertyNameCQContainer {
        protected String _propertyName;
        protected ConditionQuery _cq;

        public PropertyNameCQContainer(String propertyName, ConditionQuery cq) {
            this._propertyName = propertyName;
            this._cq = cq;
        }

        public String getPropertyName() {
            return this._propertyName;
        }

        public ConditionQuery getConditionQuery() {
            return this._cq;
        }
    }

    protected class GeneralSubQueryLevelReflector
    implements SubQueryLevelReflector {
        protected GeneralSubQueryLevelReflector() {
        }

        public void reflect(int subQueryLevel) {
            if (AbstractConditionQuery.this._subQueryLevel <= subQueryLevel) {
                AbstractConditionQuery.this._subQueryLevel = subQueryLevel + 1;
            }
        }
    }

    protected class GeneralColumnRealNameProvider
    implements ColumnRealNameProvider {
        protected GeneralColumnRealNameProvider() {
        }

        public ColumnRealName provide(String columnDbName) {
            return AbstractConditionQuery.this.toColumnRealName(columnDbName);
        }
    }

    public static interface NssCall {
        public ConditionQuery qf();
    }
}

