/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.chelper;

import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.chelper.HpCBPurpose;
import org.seasar.dbflute.cbean.chelper.HpSpQyCall;
import org.seasar.dbflute.dbmeta.DBMetaProvider;
import org.seasar.dbflute.exception.thrower.ConditionBeanExceptionThrower;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HpAbstractSpecification<CQ extends ConditionQuery> {
    protected final ConditionBean _baseCB;
    protected HpSpQyCall<CQ> _qyCall;
    protected final HpCBPurpose _purpose;
    protected final DBMetaProvider _dbmetaProvider;
    protected CQ _query;
    protected boolean _alreadySpecifiedRequiredColumn;
    protected int _specifyColumnCount;

    protected HpAbstractSpecification(ConditionBean baseCB, HpSpQyCall<CQ> qyCall, HpCBPurpose purpose, DBMetaProvider dbmetaProvider) {
        this._baseCB = baseCB;
        this._qyCall = qyCall;
        this._purpose = purpose;
        this._dbmetaProvider = dbmetaProvider;
    }

    protected void doColumn(String columnName) {
        ++this._specifyColumnCount;
        this.assertColumn(columnName);
        if (this._query == null) {
            this._query = this._qyCall.qy();
        }
        if (this.isRequiredColumnSpecificationEnabled()) {
            this._alreadySpecifiedRequiredColumn = true;
            this.doSpecifyRequiredColumn();
        }
        String relationPath = this._query.getRelationPath() != null ? this._query.getRelationPath() : "";
        String tableAliasName = this._query.isBaseQuery() ? this._baseCB.getSqlClause().getLocalTableAliasName() : this._baseCB.getSqlClause().resolveJoinAliasName(relationPath, this._query.getNestLevel());
        this._baseCB.getSqlClause().specifySelectColumn(tableAliasName, columnName, this._query.getTableDbName());
    }

    protected void assertColumn(String columnName) {
        if (this._purpose.isNoSpecifyColumnTwoOrMore() && this._specifyColumnCount > 1) {
            this.throwSpecifyColumnTwoOrMoreColumnException(columnName);
        }
        if (this.isNormalUse() && this._query == null && !this._qyCall.has()) {
            this.throwSpecifyColumnNotSetupSelectColumnException(columnName);
        }
    }

    protected boolean isRequiredColumnSpecificationEnabled() {
        if (this._alreadySpecifiedRequiredColumn) {
            return false;
        }
        return this.isNormalUse();
    }

    protected void assertRelation(String relationName) {
        if (this._purpose.isNoSpecifyRelation()) {
            this.throwSpecifyRelationIllegalPurposeException(relationName);
        }
    }

    protected void assertDerived(String referrerName) {
        if (this._purpose.isNoSpecifyDerivedReferrer()) {
            this.throwSpecifyDerivedReferrerIllegalPurposeException(referrerName);
        }
    }

    protected boolean isNormalUse() {
        return HpCBPurpose.NORMAL_USE.equals((Object)this._purpose);
    }

    protected abstract void doSpecifyRequiredColumn();

    protected abstract String getTableDbName();

    protected void throwSpecifyColumnTwoOrMoreColumnException(String columnName) {
        this.createCBExThrower().throwSpecifyColumnTwoOrMoreColumnException(this._purpose, this._baseCB, columnName);
    }

    protected void throwSpecifyColumnNotSetupSelectColumnException(String columnName) {
        this.createCBExThrower().throwSpecifyColumnNotSetupSelectColumnException(this._baseCB, columnName);
    }

    protected void throwSpecifyRelationIllegalPurposeException(String relationName) {
        this.createCBExThrower().throwSpecifyRelationIllegalPurposeException(this._purpose, this._baseCB, relationName);
    }

    protected void throwSpecifyDerivedReferrerIllegalPurposeException(String referrerName) {
        this.createCBExThrower().throwSpecifyDerivedReferrerIllegalPurposeException(this._purpose, this._baseCB, referrerName);
    }

    protected ConditionBeanExceptionThrower createCBExThrower() {
        return new ConditionBeanExceptionThrower();
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    public boolean isAlreadySpecifiedRequiredColumn() {
        return this._alreadySpecifiedRequiredColumn;
    }

    public void xswitchQyCall(HpSpQyCall<CQ> qyCall) {
        if (qyCall == null) {
            String msg = "The argument 'qyCall' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        this._qyCall = qyCall;
    }
}

