/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.sqlclause;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.seasar.dbflute.cbean.chelper.HpCBPurpose;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.ConditionOption;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.cbean.sqlclause.join.LeftOuterJoinInfo;
import org.seasar.dbflute.cbean.sqlclause.orderby.OrderByClause;
import org.seasar.dbflute.cbean.sqlclause.orderby.OrderByElement;
import org.seasar.dbflute.cbean.sqlclause.query.OrScopeQueryInfo;
import org.seasar.dbflute.cbean.sqlclause.query.OrScopeQueryReflector;
import org.seasar.dbflute.cbean.sqlclause.query.QueryClause;
import org.seasar.dbflute.cbean.sqlclause.query.QueryClauseFilter;
import org.seasar.dbflute.cbean.sqlclause.query.StringQueryClause;
import org.seasar.dbflute.cbean.sqlclause.select.SelectedSelectColumnInfo;
import org.seasar.dbflute.cbean.sqlclause.subquery.SubQueryIndentProcessor;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.DBMetaProvider;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.ForeignInfo;
import org.seasar.dbflute.dbmeta.name.ColumnRealName;
import org.seasar.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.dbflute.dbmeta.name.TableSqlName;
import org.seasar.dbflute.exception.IllegalConditionBeanOperationException;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.util.DfAssertUtil;
import org.seasar.dbflute.util.DfSystemUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSqlClause
implements SqlClause,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final SqlClause.SelectClauseType DEFAULT_SELECT_CLAUSE_TYPE = SqlClause.SelectClauseType.COLUMNS;
    protected static final String SELECT_HINT = "/*$pmb.selectHint*/";
    protected final String _tableDbName;
    protected DBMeta _dbmeta;
    protected DBMetaProvider _dbmetaProvider;
    protected final Map<String, DBMeta> _cachedDBMetaMap = StringKeyMap.createAsFlexible();
    protected final Map<String, Map<String, SelectedSelectColumnInfo>> _selectedSelectColumnMap = new LinkedHashMap<String, Map<String, SelectedSelectColumnInfo>>();
    protected Map<String, Map<String, String>> _specifiedSelectColumnMap;
    protected Map<String, Map<String, String>> _backupSpecifiedSelectColumnMap;
    protected Map<String, String> _specifiedDerivingSubQueryMap;
    protected final Map<String, String> _selectClauseRealColumnAliasMap = new HashMap<String, String>();
    protected SqlClause.SelectClauseType _selectClauseType = DEFAULT_SELECT_CLAUSE_TYPE;
    protected SqlClause.SelectClauseType _previousSelectClauseType;
    protected Map<String, Integer> _selectIndexMap;
    protected Map<String, String> _selectIndexReverseMap;
    protected boolean _useSelectIndex = true;
    protected final Map<String, LeftOuterJoinInfo> _outerJoinMap = new LinkedHashMap<String, LeftOuterJoinInfo>(4);
    protected boolean _innerJoinEffective;
    protected final List<QueryClause> _whereList = new ArrayList<QueryClause>(8);
    protected final List<QueryClause> _baseTableInlineWhereList = new ArrayList<QueryClause>(2);
    protected final OrderByClause _orderByClause = new OrderByClause();
    protected List<UnionQueryInfo> _unionQueryInfoList;
    protected boolean _orderByEffective;
    protected int _fetchStartIndex = 0;
    protected int _fetchSize = 0;
    protected int _fetchPageNumber = 1;
    protected boolean _fetchScopeEffective;
    protected boolean _orScopeQueryEffective;
    protected OrScopeQueryInfo _currentTmpOrScopeQueryInfo;
    protected boolean _orScopeQueryAndPart;
    protected final SubQueryIndentProcessor _subQueryIndentProcessor = new SubQueryIndentProcessor();
    protected Map<String, String> _selectedForeignInfo;
    protected boolean _checkInvalidQuery;
    protected Map<ColumnRealName, ConditionKey> _invalidQueryColumnMap;
    protected List<QueryClauseFilter> _whereClauseSimpleFilterList;
    protected HpCBPurpose _purpose = HpCBPurpose.NORMAL_USE;

    public AbstractSqlClause(String tableDbName) {
        if (tableDbName == null) {
            String msg = "The argument 'tableDbName' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        this._tableDbName = tableDbName;
    }

    public SqlClause provider(DBMetaProvider dbmetaProvider) {
        if (dbmetaProvider == null) {
            String msg = "The argument 'dbmetaProvider' should not be null:";
            msg = msg + " tableDbName=" + this._tableDbName;
            throw new IllegalArgumentException(msg);
        }
        this._dbmetaProvider = dbmetaProvider;
        this._dbmeta = this.findDBMeta(this._tableDbName);
        return this;
    }

    @Override
    public String getClause() {
        StringBuilder sb = new StringBuilder(512);
        String selectClause = this.getSelectClause();
        sb.append(selectClause);
        sb.append(" ");
        this.buildClauseWithoutMainSelect(sb, selectClause);
        String sql = sb.toString();
        sql = this.filterEnclosingClause(sql);
        sql = this.processSubQueryIndent(sql);
        return sql;
    }

    protected void buildClauseWithoutMainSelect(StringBuilder sb, String selectClause) {
        this.buildFromClause(sb);
        sb.append(this.getFromHint());
        sb.append(" ");
        this.buildWhereClause(sb);
        String unionClause = this.prepareUnionClause(selectClause);
        unionClause = this.deleteUnionWhereTemplateMark(unionClause);
        sb.append(unionClause);
        if (!this.needsUnionNormalSelectEnclosing()) {
            sb.append(this.prepareClauseOrderBy());
            sb.append(this.prepareClauseSqlSuffix());
        }
    }

    protected String deleteUnionWhereTemplateMark(String unionClause) {
        if (unionClause != null && unionClause.trim().length() > 0) {
            unionClause = this.replace(unionClause, this.getUnionWhereClauseMark(), "");
            unionClause = this.replace(unionClause, this.getUnionWhereFirstConditionMark(), "");
        }
        return unionClause;
    }

    @Override
    public String getClauseFromWhereWithUnionTemplate() {
        return this.buildClauseFromWhereAsTemplate(false);
    }

    @Override
    public String getClauseFromWhereWithWhereUnionTemplate() {
        return this.buildClauseFromWhereAsTemplate(true);
    }

    protected String buildClauseFromWhereAsTemplate(boolean template) {
        StringBuilder sb = new StringBuilder(256);
        this.buildFromClause(sb);
        sb.append(this.getFromHint());
        sb.append(" ");
        this.buildWhereClause(sb, template);
        sb.append(this.prepareUnionClause(this.getUnionSelectClauseMark()));
        return sb.toString();
    }

    protected String prepareUnionClause(String selectClause) {
        if (!this.hasUnionQuery()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (UnionQueryInfo unionQueryInfo : this._unionQueryInfoList) {
            String unionQueryClause = unionQueryInfo.getUnionQueryClause();
            boolean unionAll = unionQueryInfo.isUnionAll();
            sb.append(this.ln());
            sb.append(unionAll ? " union all " : " union ");
            sb.append(this.ln());
            sb.append(selectClause).append(" ").append(unionQueryClause);
        }
        return sb.toString();
    }

    protected String prepareClauseOrderBy() {
        if (!this._orderByEffective || this._orderByClause.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" ");
        sb.append(this.getOrderByClause());
        return sb.toString();
    }

    protected String prepareClauseSqlSuffix() {
        String sqlSuffix = this.getSqlSuffix();
        if (sqlSuffix == null || sqlSuffix.trim().length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" ");
        sb.append(sqlSuffix);
        return sb.toString();
    }

    protected String filterEnclosingClause(String sql) {
        sql = this.filterUnionNormalSelectEnclosing(sql);
        sql = this.filterUnionCountOrScalarEnclosing(sql);
        return sql;
    }

    protected String filterUnionNormalSelectEnclosing(String sql) {
        if (!this.needsUnionNormalSelectEnclosing()) {
            return sql;
        }
        String selectClause = "select/*$pmb.selectHint*/ *";
        String ln = this.ln();
        String beginMark = this.resolveSubQueryBeginMark("dfmain") + ln;
        String endMark = this.resolveSubQueryEndMark("dfmain");
        String clause = "select/*$pmb.selectHint*/ *" + ln + "  from (" + beginMark + sql + ln + "       ) dfmain" + endMark;
        clause = clause + this.prepareClauseOrderBy() + this.prepareClauseSqlSuffix();
        return clause;
    }

    protected String filterUnionCountOrScalarEnclosing(String sql) {
        if (!this.needsUnionCountOrScalarEnclosing()) {
            return sql;
        }
        String selectClause = this.buildSelectClauseCountOrScalar("dfmain");
        String ln = this.ln();
        String beginMark = this.resolveSubQueryBeginMark("dfmain") + ln;
        String endMark = this.resolveSubQueryEndMark("dfmain");
        return selectClause + ln + "  from (" + beginMark + sql + ln + "       ) dfmain" + endMark;
    }

    protected boolean needsUnionNormalSelectEnclosing() {
        if (!this.isUnionNormalSelectEnclosingRequired()) {
            return false;
        }
        return this.hasUnionQuery() && !this.isSelectClauseTypeCountOrScalar();
    }

    protected boolean isUnionNormalSelectEnclosingRequired() {
        return false;
    }

    protected boolean needsUnionCountOrScalarEnclosing() {
        return this.hasUnionQuery() && this.isSelectClauseTypeCountOrScalar();
    }

    @Override
    public String getSelectClause() {
        if (this.isSelectClauseTypeCountOrScalar() && !this.hasUnionQuery()) {
            return this.buildSelectClauseCountOrScalar("dflocal");
        }
        StringBuilder sb = new StringBuilder();
        DBMeta dbmeta = this.getDBMeta();
        List<ColumnInfo> columnInfoList = dbmeta.getColumnInfoList();
        Map<String, String> localSpecifiedMap = null;
        if (this._specifiedSelectColumnMap != null) {
            localSpecifiedMap = this._specifiedSelectColumnMap.get(this.getLocalTableAliasName());
        }
        boolean existsSpecifiedLocal = localSpecifiedMap != null && !localSpecifiedMap.isEmpty();
        Integer selectIndex = 0;
        if (this._useSelectIndex) {
            this._selectIndexMap = this.createSelectIndexMap();
        }
        boolean needsDelimiter = false;
        for (ColumnInfo columnInfo : columnInfoList) {
            String onQueryName;
            String columnDbName = columnInfo.getColumnDbName();
            ColumnSqlName columnSqlName = columnInfo.getColumnSqlName();
            if (existsSpecifiedLocal && !localSpecifiedMap.containsKey(columnDbName) && (!this.isSelectClauseTypeCountOrScalar() || !this.hasUnionQuery() || dbmeta.hasPrimaryKey() && !columnInfo.isPrimary())) continue;
            if (needsDelimiter) {
                sb.append(", ");
            } else {
                sb.append("select");
                this.appendSelectHint(sb);
                sb.append(" ");
                needsDelimiter = true;
            }
            String realColumnName = this.getLocalTableAliasName() + "." + columnSqlName;
            selectIndex = selectIndex + 1;
            if (this._useSelectIndex) {
                this._selectIndexMap.put(columnDbName, selectIndex);
                onQueryName = this.buildSelectIndexAliasName(selectIndex);
            } else {
                onQueryName = columnSqlName.toString();
            }
            sb.append(realColumnName).append(" as ").append(onQueryName);
            this._selectClauseRealColumnAliasMap.put(realColumnName, onQueryName);
        }
        Set<String> tableAliasNameSet = this._selectedSelectColumnMap.keySet();
        for (String tableAliasName : tableAliasNameSet) {
            Map<String, SelectedSelectColumnInfo> map = this._selectedSelectColumnMap.get(tableAliasName);
            Collection<SelectedSelectColumnInfo> selectColumnInfoList = map.values();
            Map<String, String> foreginSpecifiedMap = null;
            if (this._specifiedSelectColumnMap != null) {
                foreginSpecifiedMap = this._specifiedSelectColumnMap.get(tableAliasName);
            }
            boolean existsSpecifiedForeign = foreginSpecifiedMap != null && !foreginSpecifiedMap.isEmpty();
            boolean finishedForeignIndent = false;
            for (SelectedSelectColumnInfo selectColumnInfo : selectColumnInfoList) {
                String onQueryName;
                if (existsSpecifiedForeign && !foreginSpecifiedMap.containsKey(selectColumnInfo.getColumnDbName())) continue;
                String realColumnName = selectColumnInfo.buildRealColumnSqlName();
                String columnAliasName = selectColumnInfo.getColumnAliasName();
                selectIndex = selectIndex + 1;
                if (this._useSelectIndex) {
                    this._selectIndexMap.put(columnAliasName, selectIndex);
                    onQueryName = this.buildSelectIndexAliasName(selectIndex);
                } else {
                    onQueryName = columnAliasName;
                }
                if (!finishedForeignIndent) {
                    sb.append(this.ln()).append("     ");
                    finishedForeignIndent = true;
                }
                sb.append(", ").append(realColumnName).append(" as ").append(onQueryName);
                this._selectClauseRealColumnAliasMap.put(realColumnName, onQueryName);
            }
        }
        if (this._specifiedDerivingSubQueryMap != null && !this._specifiedDerivingSubQueryMap.isEmpty()) {
            Collection<String> deriveSubQuerySet = this._specifiedDerivingSubQueryMap.values();
            for (String deriveSubQuery : deriveSubQuerySet) {
                sb.append(this.ln()).append("     ");
                sb.append(", ").append(deriveSubQuery);
                int beginIndex = deriveSubQuery.lastIndexOf(" as ");
                if (beginIndex < 0) continue;
                String aliasName = deriveSubQuery.substring(beginIndex + " as ".length());
                int endIndex = aliasName.indexOf("--df:");
                if (endIndex >= 0) {
                    aliasName = aliasName.substring(0, endIndex);
                }
                this._selectClauseRealColumnAliasMap.put(aliasName, aliasName);
            }
        }
        return sb.toString();
    }

    protected boolean isSelectClauseTypeCountOrScalar() {
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.COUNT)) {
            return true;
        }
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.MAX)) {
            return true;
        }
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.MIN)) {
            return true;
        }
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.SUM)) {
            return true;
        }
        return this._selectClauseType.equals((Object)SqlClause.SelectClauseType.AVG);
    }

    protected String buildSelectClauseCountOrScalar(String aliasName) {
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.COUNT)) {
            return this.buildSelectClauseCount();
        }
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.MAX)) {
            return this.buildSelectClauseMax(aliasName);
        }
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.MIN)) {
            return this.buildSelectClauseMin(aliasName);
        }
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.SUM)) {
            return this.buildSelectClauseSum(aliasName);
        }
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.AVG)) {
            return this.buildSelectClauseAvg(aliasName);
        }
        String msg = "The type of select clause is not for scalar:";
        msg = msg + " type=" + (Object)((Object)this._selectClauseType);
        throw new IllegalStateException(msg);
    }

    protected String buildSelectClauseCount() {
        return "select count(*)";
    }

    protected String buildSelectClauseMax(String aliasName) {
        ColumnSqlName columnSqlName = this.getSpecifiedColumnSqlNameAsOne();
        this.assertScalarSelectSpecifiedColumnOnlyOne(columnSqlName);
        return "select max(" + aliasName + "." + columnSqlName + ")";
    }

    protected String buildSelectClauseMin(String aliasName) {
        ColumnSqlName columnSqlName = this.getSpecifiedColumnSqlNameAsOne();
        this.assertScalarSelectSpecifiedColumnOnlyOne(columnSqlName);
        return "select min(" + aliasName + "." + columnSqlName + ")";
    }

    protected String buildSelectClauseSum(String aliasName) {
        ColumnSqlName columnSqlName = this.getSpecifiedColumnSqlNameAsOne();
        this.assertScalarSelectSpecifiedColumnOnlyOne(columnSqlName);
        return "select sum(" + aliasName + "." + columnSqlName + ")";
    }

    protected String buildSelectClauseAvg(String aliasName) {
        ColumnSqlName columnSqlName = this.getSpecifiedColumnSqlNameAsOne();
        this.assertScalarSelectSpecifiedColumnOnlyOne(columnSqlName);
        return "select avg(" + aliasName + "." + columnSqlName + ")";
    }

    protected void assertScalarSelectSpecifiedColumnOnlyOne(ColumnSqlName columnSqlName) {
        if (columnSqlName != null) {
            return;
        }
        String msg = "The specified column exists one";
        msg = msg + " when the type of select clause is for scalar:";
        msg = msg + " specifiedSelectColumnMap=" + this._specifiedSelectColumnMap;
        throw new IllegalStateException(msg);
    }

    @Override
    public Map<String, Integer> getSelectIndexMap() {
        return this._selectIndexMap;
    }

    @Override
    public Map<String, String> getSelectIndexReverseMap() {
        if (this._selectIndexReverseMap != null) {
            return this._selectIndexReverseMap;
        }
        if (this._selectIndexMap == null) {
            return null;
        }
        this._selectIndexReverseMap = this.createSelectIndexMap();
        Set<Map.Entry<String, Integer>> entrySet = this._selectIndexMap.entrySet();
        for (Map.Entry<String, Integer> entry : entrySet) {
            String columnName = entry.getKey();
            Integer selectIndex = entry.getValue();
            this._selectIndexReverseMap.put(this.buildSelectIndexAliasName(selectIndex), columnName);
        }
        return this._selectIndexReverseMap;
    }

    protected <VALUE> Map<String, VALUE> createSelectIndexMap() {
        return StringKeyMap.createAsFlexible();
    }

    protected String buildSelectIndexAliasName(Integer selectIndex) {
        return "c" + selectIndex;
    }

    @Override
    public void disableSelectIndex() {
        this._useSelectIndex = false;
    }

    @Override
    public String getSelectHint() {
        return this.createSelectHint();
    }

    protected void appendSelectHint(StringBuilder sb) {
        sb.append(SELECT_HINT);
    }

    @Override
    public String getFromClause() {
        StringBuilder sb = new StringBuilder();
        this.buildFromClause(sb);
        return sb.toString();
    }

    protected void buildFromClause(StringBuilder sb) {
        sb.append(this.ln()).append("  ");
        sb.append("from ");
        int tablePos = 7;
        if (this.isJoinInParentheses()) {
            for (int i = 0; i < this._outerJoinMap.size(); ++i) {
                sb.append("(");
                ++tablePos;
            }
        }
        TableSqlName tableSqlName = this.getDBMeta().getTableSqlName();
        if (this._baseTableInlineWhereList.isEmpty()) {
            sb.append(tableSqlName).append(" dflocal");
        } else {
            sb.append(this.getInlineViewClause(tableSqlName, this._baseTableInlineWhereList, tablePos));
            sb.append(" dflocal");
        }
        sb.append(this.getFromBaseTableHint());
        sb.append(this.getLeftOuterJoinClause());
    }

    protected String getLeftOuterJoinClause() {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<String, LeftOuterJoinInfo>> outerJoinSet = this._outerJoinMap.entrySet();
        for (Map.Entry<String, LeftOuterJoinInfo> outerJoinEntry : outerJoinSet) {
            String aliasName = outerJoinEntry.getKey();
            LeftOuterJoinInfo joinInfo = outerJoinEntry.getValue();
            this.buildLeftOuterJoinClause(sb, aliasName, joinInfo);
        }
        return sb.toString();
    }

    protected void buildLeftOuterJoinClause(StringBuilder sb, String aliasName, LeftOuterJoinInfo joinInfo) {
        String joinTableDbName = joinInfo.getJoinTableDbName();
        Map<ColumnRealName, ColumnRealName> joinOnMap = joinInfo.getJoinOnMap();
        this.assertJoinOnMapNotEmpty(joinOnMap, aliasName);
        sb.append(this.ln()).append("   ");
        String joinExp = joinInfo.isInnerJoin() ? " inner join " : " left outer join ";
        sb.append(joinExp);
        int tablePos = 3 + joinExp.length();
        DBMeta joinDBMeta = this.findDBMeta(joinTableDbName);
        TableSqlName joinTableSqlName = joinDBMeta.getTableSqlName();
        List<QueryClause> inlineWhereClauseList = joinInfo.getInlineWhereClauseList();
        String tableExp = inlineWhereClauseList.isEmpty() ? joinTableSqlName.toString() : this.getInlineViewClause(joinTableSqlName, inlineWhereClauseList, tablePos);
        sb.append(tableExp);
        sb.append(" ").append(aliasName);
        if (joinInfo.hasInlineOrOnClause() || joinInfo.hasFixedCondition()) {
            sb.append(this.ln()).append("     ");
        }
        sb.append(" on ");
        int count = 0;
        Set<Map.Entry<ColumnRealName, ColumnRealName>> joinOnSet = joinOnMap.entrySet();
        for (Map.Entry<ColumnRealName, ColumnRealName> joinOnEntry : joinOnSet) {
            ColumnRealName localRealName = joinOnEntry.getKey();
            ColumnRealName foreignRealName = joinOnEntry.getValue();
            if (count > 0) {
                sb.append(" and ");
            }
            sb.append(localRealName).append(" = ").append(foreignRealName);
            ++count;
        }
        if (joinInfo.hasFixedCondition()) {
            String fixedCondition = joinInfo.getFixedCondition();
            sb.append(this.ln()).append("    ");
            sb.append(" and ").append(fixedCondition);
        }
        List<QueryClause> additionalOnClauseList = joinInfo.getAdditionalOnClauseList();
        for (QueryClause additionalOnClause : additionalOnClauseList) {
            sb.append(this.ln()).append("    ");
            sb.append(" and ").append(additionalOnClause);
        }
        if (this.isJoinInParentheses()) {
            sb.append(")");
        }
    }

    protected boolean isJoinInParentheses() {
        return false;
    }

    protected String getInlineViewClause(TableSqlName inlineTableSqlName, List<QueryClause> inlineWhereClauseList, int tablePos) {
        StringBuilder sb = new StringBuilder();
        sb.append("(select * from ").append(inlineTableSqlName);
        String baseIndent = this.buildSpaceBar(tablePos + 1);
        sb.append(this.ln()).append(baseIndent);
        sb.append(" where ");
        int count = 0;
        for (QueryClause whereClause : inlineWhereClauseList) {
            String clauseElement = this.filterWhereClauseSimply(((Object)whereClause).toString());
            if (count > 0) {
                sb.append(this.ln()).append(baseIndent);
                sb.append("   and ");
            }
            sb.append(clauseElement);
            ++count;
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String getFromBaseTableHint() {
        return this.createFromBaseTableHint();
    }

    @Override
    public String getFromHint() {
        return this.createFromHint();
    }

    @Override
    public String getWhereClause() {
        StringBuilder sb = new StringBuilder();
        this.buildWhereClause(sb);
        return sb.toString();
    }

    protected void buildWhereClause(StringBuilder sb) {
        this.buildWhereClause(sb, false);
    }

    protected void buildWhereClause(StringBuilder sb, boolean template) {
        if (this._whereList.isEmpty()) {
            if (template) {
                sb.append(this.getWhereClauseMark());
            }
            return;
        }
        int count = 0;
        for (QueryClause whereClause : this._whereList) {
            String clauseElement = this.filterWhereClauseSimply(((Object)whereClause).toString());
            if (count == 0) {
                sb.append(this.ln()).append(" ");
                sb.append("where ").append(template ? this.getWhereFirstConditionMark() : "").append(clauseElement);
            } else {
                sb.append(this.ln()).append("  ");
                sb.append(" and ").append(clauseElement);
            }
            ++count;
        }
    }

    @Override
    public String getOrderByClause() {
        String orderByClause = null;
        if (this.hasUnionQuery()) {
            if (this._selectClauseRealColumnAliasMap == null || this._selectClauseRealColumnAliasMap.isEmpty()) {
                String msg = "The selectClauseColumnAliasMap should not be null or empty when union query exists.";
                throw new IllegalStateException(msg);
            }
            orderByClause = this._orderByClause.getOrderByClause(this._selectClauseRealColumnAliasMap);
        } else {
            orderByClause = this._orderByClause.getOrderByClause();
        }
        if (orderByClause != null && orderByClause.trim().length() > 0) {
            return this.ln() + " " + orderByClause;
        }
        return orderByClause;
    }

    @Override
    public String getSqlSuffix() {
        String sqlSuffix = this.createSqlSuffix();
        if (sqlSuffix != null && sqlSuffix.trim().length() > 0) {
            return this.ln() + sqlSuffix;
        }
        return sqlSuffix;
    }

    @Override
    public void registerSelectedSelectColumn(String foreignTableAliasName, String localTableDbName, String foreignPropertyName, String localRelationPath) {
        this._selectedSelectColumnMap.put(foreignTableAliasName, this.createSelectedSelectColumnInfo(foreignTableAliasName, localTableDbName, foreignPropertyName, localRelationPath));
    }

    protected Map<String, SelectedSelectColumnInfo> createSelectedSelectColumnInfo(String foreignTableAliasName, String localTableDbName, String foreignPropertyName, String localRelationPath) {
        DBMeta dbmeta = this.findDBMeta(localTableDbName);
        ForeignInfo foreignInfo = dbmeta.findForeignInfo(foreignPropertyName);
        int relationNo = foreignInfo.getRelationNo();
        String nextRelationPath = "_" + relationNo;
        if (localRelationPath != null) {
            nextRelationPath = localRelationPath + nextRelationPath;
        }
        LinkedHashMap<String, SelectedSelectColumnInfo> resultMap = new LinkedHashMap<String, SelectedSelectColumnInfo>();
        DBMeta foreignDBMeta = foreignInfo.getForeignDBMeta();
        List<ColumnInfo> columnInfoList = foreignDBMeta.getColumnInfoList();
        for (ColumnInfo columnInfo : columnInfoList) {
            String columnDbName = columnInfo.getColumnDbName();
            ColumnSqlName columnSqlName = columnInfo.getColumnSqlName();
            SelectedSelectColumnInfo selectColumnInfo = new SelectedSelectColumnInfo();
            selectColumnInfo.setTableAliasName(foreignTableAliasName);
            selectColumnInfo.setColumnDbName(columnDbName);
            selectColumnInfo.setColumnSqlName(columnSqlName);
            selectColumnInfo.setColumnAliasName(columnDbName + nextRelationPath);
            resultMap.put(columnDbName, selectColumnInfo);
        }
        return resultMap;
    }

    @Override
    public void registerOuterJoin(String baseTableDbName, String joinTableDbName, String aliasName, Map<ColumnRealName, ColumnRealName> joinOnMap, String fixedCondition) {
        this.assertAlreadyOuterJoin(aliasName);
        this.assertJoinOnMapNotEmpty(joinOnMap, aliasName);
        LeftOuterJoinInfo joinInfo = new LeftOuterJoinInfo();
        joinInfo.setAliasName(aliasName);
        joinInfo.setBaseTableDbName(baseTableDbName);
        joinInfo.setJoinTableDbName(joinTableDbName);
        joinInfo.setJoinOnMap(joinOnMap);
        joinInfo.setFixedCondition(fixedCondition);
        if (this._innerJoinEffective) {
            joinInfo.setInnerJoin(true);
        }
        this._outerJoinMap.put(aliasName, joinInfo);
    }

    @Override
    public void changeToInnerJoin(String aliasName) {
        LeftOuterJoinInfo joinInfo = this._outerJoinMap.get(aliasName);
        if (joinInfo == null) {
            String msg = "The aliasName should be registered:";
            msg = msg + " aliasName=" + aliasName + " outerJoinMap=" + this._outerJoinMap.keySet();
            throw new IllegalStateException(msg);
        }
        joinInfo.setInnerJoin(true);
    }

    @Override
    public SqlClause makeInnerJoinEffective() {
        this._innerJoinEffective = true;
        return this;
    }

    @Override
    public SqlClause backToOuterJoin() {
        this._innerJoinEffective = false;
        return this;
    }

    protected void assertAlreadyOuterJoin(String aliasName) {
        if (this._outerJoinMap.containsKey(aliasName)) {
            String msg = "The alias name have already registered in outer join: " + aliasName;
            throw new IllegalStateException(msg);
        }
    }

    protected void assertJoinOnMapNotEmpty(Map<ColumnRealName, ColumnRealName> joinOnMap, String aliasName) {
        if (joinOnMap.isEmpty()) {
            String msg = "The joinOnMap should not be empty: aliasName=" + aliasName;
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public void registerWhereClause(ColumnRealName columnRealName, ConditionKey key, ConditionValue value) {
        this.assertObjectNotNull("columnRealName", columnRealName);
        List<QueryClause> clauseList = this.getWhereClauseList4Register();
        this.doRegisterWhereClause(clauseList, columnRealName, key, value);
    }

    @Override
    public void registerWhereClause(ColumnRealName columnRealName, ConditionKey key, ConditionValue value, ConditionOption option) {
        this.assertObjectNotNull("columnRealName", columnRealName);
        this.assertObjectNotNull("option of " + columnRealName, option);
        List<QueryClause> clauseList = this.getWhereClauseList4Register();
        this.doRegisterWhereClause(clauseList, columnRealName, key, value, option);
    }

    @Override
    public void registerWhereClause(String clause) {
        this.assertStringNotNullAndNotTrimmedEmpty("clause", clause);
        List<QueryClause> clauseList = this.getWhereClauseList4Register();
        this.doRegisterWhereClause(clauseList, clause);
    }

    @Override
    public void registerWhereClause(QueryClause clause) {
        this.assertObjectNotNull("clause", clause);
        List<QueryClause> clauseList = this.getWhereClauseList4Register();
        this.doRegisterWhereClause(clauseList, clause);
    }

    protected List<QueryClause> getWhereClauseList4Register() {
        if (this._orScopeQueryEffective) {
            return this.getTmpOrWhereList();
        }
        return this._whereList;
    }

    @Override
    public void exchangeFirstWhereClauseForLastOne() {
        if (this._whereList.size() > 1) {
            QueryClause first = this._whereList.get(0);
            QueryClause last = this._whereList.get(this._whereList.size() - 1);
            this._whereList.set(0, last);
            this._whereList.set(this._whereList.size() - 1, first);
        }
    }

    @Override
    public boolean hasWhereClause() {
        return this._whereList != null && !this._whereList.isEmpty();
    }

    @Override
    public void registerBaseTableInlineWhereClause(ColumnSqlName columnSqlName, ConditionKey key, ConditionValue value) {
        List<QueryClause> clauseList = this.getBaseTableInlineWhereClauseList4Register();
        this.doRegisterWhereClause(clauseList, new ColumnRealName(null, columnSqlName), key, value);
    }

    @Override
    public void registerBaseTableInlineWhereClause(ColumnSqlName columnSqlName, ConditionKey key, ConditionValue value, ConditionOption option) {
        this.assertObjectNotNull("option of " + columnSqlName, option);
        List<QueryClause> clauseList = this.getBaseTableInlineWhereClauseList4Register();
        this.doRegisterWhereClause(clauseList, new ColumnRealName(null, columnSqlName), key, value, option);
    }

    @Override
    public void registerBaseTableInlineWhereClause(String value) {
        List<QueryClause> clauseList = this.getBaseTableInlineWhereClauseList4Register();
        this.doRegisterWhereClause(clauseList, value);
    }

    protected List<QueryClause> getBaseTableInlineWhereClauseList4Register() {
        if (this._orScopeQueryEffective) {
            return this.getTmpOrBaseTableInlineWhereList();
        }
        return this._baseTableInlineWhereList;
    }

    @Override
    public void registerOuterJoinInlineWhereClause(String aliasName, ColumnSqlName columnSqlName, ConditionKey key, ConditionValue value, boolean onClause) {
        this.assertNotYetOuterJoin(aliasName);
        List<QueryClause> clauseList = this.getOuterJoinInlineWhereClauseList4Register(aliasName, onClause);
        ColumnRealName columnRealName = new ColumnRealName(onClause ? aliasName : "", columnSqlName);
        this.doRegisterWhereClause(clauseList, columnRealName, key, value);
    }

    @Override
    public void registerOuterJoinInlineWhereClause(String aliasName, ColumnSqlName columnSqlName, ConditionKey key, ConditionValue value, ConditionOption option, boolean onClause) {
        this.assertNotYetOuterJoin(aliasName);
        List<QueryClause> clauseList = this.getOuterJoinInlineWhereClauseList4Register(aliasName, onClause);
        ColumnRealName columnRealName = new ColumnRealName(onClause ? aliasName : "", columnSqlName);
        this.doRegisterWhereClause(clauseList, columnRealName, key, value, option);
    }

    @Override
    public void registerOuterJoinInlineWhereClause(String aliasName, String clause, boolean onClause) {
        this.assertNotYetOuterJoin(aliasName);
        List<QueryClause> clauseList = this.getOuterJoinInlineWhereClauseList4Register(aliasName, onClause);
        this.doRegisterWhereClause(clauseList, clause);
    }

    protected List<QueryClause> getOuterJoinInlineWhereClauseList4Register(String aliasName, boolean onClause) {
        LeftOuterJoinInfo joinInfo = this._outerJoinMap.get(aliasName);
        List<QueryClause> clauseList = onClause ? (this._orScopeQueryEffective ? this.getTmpOrAdditionalOnClauseList(aliasName) : joinInfo.getAdditionalOnClauseList()) : (this._orScopeQueryEffective ? this.getTmpOrOuterJoinInlineClauseList(aliasName) : joinInfo.getInlineWhereClauseList());
        return clauseList;
    }

    protected void assertNotYetOuterJoin(String aliasName) {
        if (!this._outerJoinMap.containsKey(aliasName)) {
            String msg = "The alias name have not registered in outer join yet: " + aliasName;
            throw new IllegalStateException(msg);
        }
    }

    protected void doRegisterWhereClause(List<QueryClause> clauseList, ColumnRealName columnRealName, ConditionKey key, ConditionValue value) {
        key.addWhereClause(clauseList, columnRealName, value);
        this.markOrScopeQueryAndPart(clauseList);
    }

    protected void doRegisterWhereClause(List<QueryClause> clauseList, ColumnRealName columnRealName, ConditionKey key, ConditionValue value, ConditionOption option) {
        key.addWhereClause(clauseList, columnRealName, value, option);
        this.markOrScopeQueryAndPart(clauseList);
    }

    protected void doRegisterWhereClause(List<QueryClause> clauseList, String clause) {
        this.doRegisterWhereClause(clauseList, new StringQueryClause(clause));
    }

    protected void doRegisterWhereClause(List<QueryClause> clauseList, QueryClause clause) {
        clauseList.add(clause);
        this.markOrScopeQueryAndPart(clauseList);
    }

    @Override
    public void makeOrScopeQueryEffective() {
        OrScopeQueryInfo tmpOrScopeQueryInfo = new OrScopeQueryInfo();
        if (this._currentTmpOrScopeQueryInfo != null) {
            this._currentTmpOrScopeQueryInfo.addChildInfo(tmpOrScopeQueryInfo);
        }
        this._currentTmpOrScopeQueryInfo = tmpOrScopeQueryInfo;
        this._orScopeQueryEffective = true;
    }

    @Override
    public void closeOrScopeQuery() {
        this.assertCurrentTmpOrScopeQueryInfo();
        OrScopeQueryInfo parentInfo = this._currentTmpOrScopeQueryInfo.getParentInfo();
        if (parentInfo != null) {
            this._currentTmpOrScopeQueryInfo = parentInfo;
        } else {
            this.reflectTmpOrClauseToRealObject(this._currentTmpOrScopeQueryInfo);
            this.clearOrScopeQuery();
        }
    }

    protected void clearOrScopeQuery() {
        this._currentTmpOrScopeQueryInfo = null;
        this._orScopeQueryEffective = false;
        this._orScopeQueryAndPart = false;
    }

    protected void reflectTmpOrClauseToRealObject(OrScopeQueryInfo localInfo) {
        OrScopeQueryReflector reflector = this.createOrClauseReflector();
        reflector.reflectTmpOrClauseToRealObject(localInfo);
    }

    protected OrScopeQueryReflector createOrClauseReflector() {
        return new OrScopeQueryReflector(this._whereList, this._baseTableInlineWhereList, this._outerJoinMap);
    }

    @Override
    public boolean isOrScopeQueryEffective() {
        return this._orScopeQueryEffective;
    }

    protected List<QueryClause> getTmpOrWhereList() {
        this.assertCurrentTmpOrScopeQueryInfo();
        return this._currentTmpOrScopeQueryInfo.getTmpOrWhereList();
    }

    protected List<QueryClause> getTmpOrBaseTableInlineWhereList() {
        this.assertCurrentTmpOrScopeQueryInfo();
        return this._currentTmpOrScopeQueryInfo.getTmpOrBaseTableInlineWhereList();
    }

    protected List<QueryClause> getTmpOrAdditionalOnClauseList(String aliasName) {
        this.assertCurrentTmpOrScopeQueryInfo();
        return this._currentTmpOrScopeQueryInfo.getTmpOrAdditionalOnClauseList(aliasName);
    }

    protected List<QueryClause> getTmpOrOuterJoinInlineClauseList(String aliasName) {
        this.assertCurrentTmpOrScopeQueryInfo();
        return this._currentTmpOrScopeQueryInfo.getTmpOrOuterJoinInlineClauseList(aliasName);
    }

    @Override
    public void beginOrScopeQueryAndPart() {
        this.assertCurrentTmpOrScopeQueryInfo();
        this._orScopeQueryAndPart = true;
    }

    @Override
    public void endOrScopeQueryAndPart() {
        this.assertCurrentTmpOrScopeQueryInfo();
        this._orScopeQueryAndPart = false;
    }

    protected void markOrScopeQueryAndPart(List<QueryClause> clauseList) {
        if (this._orScopeQueryEffective && this._orScopeQueryAndPart && !clauseList.isEmpty()) {
            QueryClause original = clauseList.remove(clauseList.size() - 1);
            clauseList.add(new StringQueryClause(this.getOrScopeQueryAndPartMark() + original));
        }
    }

    protected String getOrScopeQueryAndPartMark() {
        return "$$df:AndPart$$";
    }

    protected void assertCurrentTmpOrScopeQueryInfo() {
        if (this._currentTmpOrScopeQueryInfo == null) {
            String msg = "The attribute 'currentTmpOrScopeQueryInfo' should not be null in or-scope query:";
            msg = msg + " orScopeQueryEffective=" + this._orScopeQueryEffective;
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public OrderByClause getSqlComponentOfOrderByClause() {
        return this._orderByClause;
    }

    @Override
    public SqlClause clearOrderBy() {
        this._orderByEffective = false;
        this._orderByClause.clear();
        return this;
    }

    @Override
    public SqlClause makeOrderByEffective() {
        if (!this._orderByClause.isEmpty()) {
            this._orderByEffective = true;
        }
        return this;
    }

    @Override
    public SqlClause ignoreOrderBy() {
        this._orderByEffective = false;
        return this;
    }

    @Override
    public void registerOrderBy(String orderByProperty, boolean ascOrDesc) {
        try {
            this._orderByEffective = true;
            ArrayList<String> orderByList = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(orderByProperty, "/");
            while (st.hasMoreElements()) {
                orderByList.add(st.nextToken());
            }
            int count = 0;
            for (String orderBy : orderByList) {
                this._orderByEffective = true;
                String aliasName = null;
                String columnName = null;
                if (orderBy.indexOf(".") < 0) {
                    columnName = orderBy;
                } else {
                    aliasName = orderBy.substring(0, orderBy.lastIndexOf("."));
                    columnName = orderBy.substring(orderBy.lastIndexOf(".") + 1);
                }
                OrderByElement element = new OrderByElement();
                element.setAliasName(aliasName);
                element.setColumnName(columnName);
                if (ascOrDesc) {
                    element.setupAsc();
                } else {
                    element.setupDesc();
                }
                this._orderByClause.addOrderByElement(element);
                ++count;
            }
        }
        catch (RuntimeException e) {
            String msg = "Failed to register order-by:";
            msg = msg + " orderByProperty=" + orderByProperty + " ascOrDesc=" + ascOrDesc;
            msg = msg + " table=" + this._tableDbName;
            throw new IllegalStateException(msg, e);
        }
    }

    @Override
    public void reverseOrderBy_Or_OverrideOrderBy(String orderByProperty, boolean ascOrDesc) {
        this._orderByEffective = true;
        if (!this._orderByClause.isSameOrderByColumn(orderByProperty)) {
            this.clearOrderBy();
            this.registerOrderBy(orderByProperty, ascOrDesc);
        } else {
            this._orderByClause.reverseAll();
        }
    }

    @Override
    public void addNullsFirstToPreviousOrderBy() {
        this._orderByClause.addNullsFirstToPreviousOrderByElement(this.createOrderByNullsSetupper());
    }

    @Override
    public void addNullsLastToPreviousOrderBy() {
        this._orderByClause.addNullsLastToPreviousOrderByElement(this.createOrderByNullsSetupper());
    }

    protected OrderByClause.OrderByNullsSetupper createOrderByNullsSetupper() {
        return new OrderByClause.OrderByNullsSetupper(){

            public String setup(String columnName, String orderByElementClause, boolean nullsFirst) {
                return orderByElementClause + " nulls " + (nullsFirst ? "first" : "last");
            }
        };
    }

    protected OrderByClause.OrderByNullsSetupper createOrderByNullsSetupperByCaseWhen() {
        return new OrderByClause.OrderByNullsSetupper(){

            public String setup(String columnName, String orderByElementClause, boolean nullsFirst) {
                String thenNumber = nullsFirst ? "1" : "0";
                String elseNumber = nullsFirst ? "0" : "1";
                String caseWhen = "case when " + columnName + " is not null then " + thenNumber + " else " + elseNumber + " end asc";
                return caseWhen + ", " + orderByElementClause;
            }
        };
    }

    @Override
    public void addManualOrderToPreviousOrderByElement(OrderByClause.ManumalOrderInfo manumalOrderInfo) {
        this.assertObjectNotNull("manumalOrderInfo", manumalOrderInfo);
        if (this.hasUnionQuery()) {
            String msg = "Manual Order with Union is unavailable: " + manumalOrderInfo.getManualValueList();
            throw new IllegalConditionBeanOperationException(msg);
        }
        this._orderByClause.addManualOrderByElement(manumalOrderInfo);
    }

    @Override
    public boolean hasOrderByClause() {
        return this._orderByClause != null && !this._orderByClause.isEmpty();
    }

    @Override
    public void registerUnionQuery(String unionQueryClause, boolean unionAll) {
        this.assertStringNotNullAndNotTrimmedEmpty("unionQueryClause", unionQueryClause);
        UnionQueryInfo unionQueryInfo = new UnionQueryInfo();
        unionQueryInfo.setUnionQueryClause(unionQueryClause);
        unionQueryInfo.setUnionAll(unionAll);
        this.addUnionQueryInfo(unionQueryInfo);
    }

    protected void addUnionQueryInfo(UnionQueryInfo unionQueryInfo) {
        if (this._unionQueryInfoList == null) {
            this._unionQueryInfoList = new ArrayList<UnionQueryInfo>();
        }
        this._unionQueryInfoList.add(unionQueryInfo);
    }

    @Override
    public boolean hasUnionQuery() {
        return this._unionQueryInfoList != null && !this._unionQueryInfoList.isEmpty();
    }

    @Override
    public SqlClause fetchFirst(int fetchSize) {
        this._fetchScopeEffective = true;
        if (fetchSize <= 0) {
            String msg = "Argument[fetchSize] should be plus: " + fetchSize;
            throw new IllegalArgumentException(msg);
        }
        this._fetchStartIndex = 0;
        this._fetchSize = fetchSize;
        this._fetchPageNumber = 1;
        this.doClearFetchPageClause();
        this.doFetchFirst();
        return this;
    }

    @Override
    public SqlClause fetchScope(int fetchStartIndex, int fetchSize) {
        this._fetchScopeEffective = true;
        if (fetchStartIndex < 0) {
            String msg = "Argument[fetchStartIndex] must be plus or zero: " + fetchStartIndex;
            throw new IllegalArgumentException(msg);
        }
        if (fetchSize <= 0) {
            String msg = "Argument[fetchSize] should be plus: " + fetchSize;
            throw new IllegalArgumentException(msg);
        }
        this._fetchStartIndex = fetchStartIndex;
        this._fetchSize = fetchSize;
        return this.fetchPage(1);
    }

    @Override
    public SqlClause fetchPage(int fetchPageNumber) {
        this._fetchScopeEffective = true;
        if (fetchPageNumber <= 0) {
            fetchPageNumber = 1;
        }
        if (this._fetchSize <= 0) {
            this.throwFetchSizeNotPlusException(fetchPageNumber);
        }
        this._fetchPageNumber = fetchPageNumber;
        if (this._fetchPageNumber == 1 && this._fetchStartIndex == 0) {
            return this.fetchFirst(this._fetchSize);
        }
        this.doClearFetchPageClause();
        this.doFetchPage();
        return this;
    }

    protected void throwFetchSizeNotPlusException(int fetchPageNumber) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "Fetch size should not be minus or zero!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Fetch Size]" + this.ln();
        msg = msg + "fetchSize=" + this._fetchSize + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Fetch Page Number]" + this.ln();
        msg = msg + "fetchPageNumber=" + fetchPageNumber + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new IllegalStateException(msg);
    }

    protected abstract void doFetchFirst();

    protected abstract void doFetchPage();

    protected abstract void doClearFetchPageClause();

    @Override
    public int getFetchStartIndex() {
        return this._fetchStartIndex;
    }

    @Override
    public int getFetchSize() {
        return this._fetchSize;
    }

    @Override
    public int getFetchPageNumber() {
        return this._fetchPageNumber;
    }

    @Override
    public int getPageStartIndex() {
        if (this._fetchPageNumber <= 0) {
            String msg = "_fetchPageNumber must be plus: " + this._fetchPageNumber;
            throw new IllegalStateException(msg);
        }
        return this._fetchStartIndex + this._fetchSize * (this._fetchPageNumber - 1);
    }

    @Override
    public int getPageEndIndex() {
        if (this._fetchPageNumber <= 0) {
            String msg = "_fetchPageNumber must be plus: " + this._fetchPageNumber;
            throw new IllegalStateException(msg);
        }
        return this._fetchStartIndex + this._fetchSize * this._fetchPageNumber;
    }

    @Override
    public boolean isFetchScopeEffective() {
        return this._fetchScopeEffective;
    }

    @Override
    public SqlClause ignoreFetchScope() {
        this._fetchScopeEffective = false;
        this.doClearFetchPageClause();
        return this;
    }

    @Override
    public SqlClause makeFetchScopeEffective() {
        if (this.getFetchSize() > 0 && this.getFetchPageNumber() > 0) {
            this.fetchPage(this.getFetchPageNumber());
        }
        return this;
    }

    @Override
    public boolean isFetchStartIndexSupported() {
        return true;
    }

    @Override
    public boolean isFetchSizeSupported() {
        return true;
    }

    protected abstract String createSelectHint();

    protected abstract String createFromBaseTableHint();

    protected abstract String createFromHint();

    protected abstract String createSqlSuffix();

    @Override
    public int getFetchNarrowingSkipStartIndex() {
        return this.getPageStartIndex();
    }

    @Override
    public int getFetchNarrowingLoopCount() {
        return this.getFetchSize();
    }

    @Override
    public boolean isFetchNarrowingEffective() {
        return this._fetchScopeEffective;
    }

    @Override
    public String resolveJoinAliasName(String relationPath, int cqNestNo) {
        return this.resolveNestLevelExpression("dfrelation" + relationPath, cqNestNo);
    }

    @Override
    public String resolveNestLevelExpression(String name, int cqNestNo) {
        return name;
    }

    @Override
    public int resolveRelationNo(String localTableName, String foreignPropertyName) {
        DBMeta dbmeta = this.findDBMeta(localTableName);
        ForeignInfo foreignInfo = dbmeta.findForeignInfo(foreignPropertyName);
        return foreignInfo.getRelationNo();
    }

    @Override
    public String getLocalTableAliasName() {
        return "dflocal";
    }

    @Override
    public String getForeignTableAliasPrefix() {
        return "dfrelation";
    }

    @Override
    public String getWhereClauseMark() {
        return "#df:whereClause#";
    }

    @Override
    public String getWhereFirstConditionMark() {
        return "#df:whereFirstCondition#";
    }

    @Override
    public String getUnionSelectClauseMark() {
        return "#df:unionSelectClause#";
    }

    @Override
    public String getUnionWhereClauseMark() {
        return "#df:unionWhereClause#";
    }

    @Override
    public String getUnionWhereFirstConditionMark() {
        return "#df:unionWhereFirstCondition#";
    }

    @Override
    public String resolveSubQueryBeginMark(String subQueryIdentity) {
        return this._subQueryIndentProcessor.resolveSubQueryBeginMark(subQueryIdentity);
    }

    @Override
    public String resolveSubQueryEndMark(String subQueryIdentity) {
        return this._subQueryIndentProcessor.resolveSubQueryEndMark(subQueryIdentity);
    }

    @Override
    public String processSubQueryIndent(String sql) {
        return this.processSubQueryIndent(sql, "", sql);
    }

    protected String processSubQueryIndent(String sql, String preIndent, String originalSql) {
        return this._subQueryIndentProcessor.processSubQueryIndent(sql, preIndent, originalSql);
    }

    @Override
    public boolean isSelectedForeignInfoEmpty() {
        return this._selectedForeignInfo == null || this._selectedForeignInfo.isEmpty();
    }

    @Override
    public boolean hasSelectedForeignInfo(String relationPath) {
        return this._selectedForeignInfo != null && this._selectedForeignInfo.containsKey(relationPath);
    }

    @Override
    public void registerSelectedForeignInfo(String relationPath, String foreignPropertyName) {
        if (this._selectedForeignInfo == null) {
            this._selectedForeignInfo = new HashMap<String, String>();
        }
        this._selectedForeignInfo.put(relationPath, foreignPropertyName);
    }

    @Override
    public void specifySelectColumn(String tableAliasName, String columnDbName, String tableDbName) {
        Map<String, Object> elementMap;
        if (this._specifiedSelectColumnMap == null) {
            this._specifiedSelectColumnMap = StringKeyMap.createAsFlexible();
        }
        if (!this._specifiedSelectColumnMap.containsKey(tableAliasName)) {
            elementMap = StringKeyMap.createAsFlexibleOrdered();
            this._specifiedSelectColumnMap.put(tableAliasName, elementMap);
        }
        elementMap = this._specifiedSelectColumnMap.get(tableAliasName);
        elementMap.put(columnDbName, tableDbName);
    }

    @Override
    public void backupSpecifiedSelectColumn() {
        this._backupSpecifiedSelectColumnMap = this._specifiedSelectColumnMap;
    }

    @Override
    public void restoreSpecifiedSelectColumn() {
        this._specifiedSelectColumnMap = this._backupSpecifiedSelectColumnMap;
        this._backupSpecifiedSelectColumnMap = null;
    }

    @Override
    public void clearSpecifiedSelectColumn() {
        if (this._specifiedSelectColumnMap != null) {
            this._specifiedSelectColumnMap.clear();
            this._specifiedSelectColumnMap = null;
        }
    }

    @Override
    public String getSpecifiedColumnDbNameAsOne() {
        ColumnInfo columnInfo = this.getSpecifiedColumnInfoAsOne();
        return columnInfo != null ? columnInfo.getColumnDbName() : null;
    }

    @Override
    public ColumnInfo getSpecifiedColumnInfoAsOne() {
        Map<String, String> elementMap = this.getSpecifiedColumnElementMapAsOne();
        if (elementMap == null) {
            return null;
        }
        String columnDbName = elementMap.keySet().iterator().next();
        String tableDbName = elementMap.values().iterator().next();
        return this.toColumnInfo(tableDbName, columnDbName);
    }

    @Override
    public ColumnRealName getSpecifiedColumnRealNameAsOne() {
        ColumnSqlName columnSqlName = this.getSpecifiedColumnSqlNameAsOne();
        if (columnSqlName == null) {
            return null;
        }
        String tableAliasName = this.getSpecifiedColumnTableAliasNameAsOne();
        return new ColumnRealName(tableAliasName, columnSqlName);
    }

    @Override
    public ColumnSqlName getSpecifiedColumnSqlNameAsOne() {
        ColumnInfo columnInfo = this.getSpecifiedColumnInfoAsOne();
        return columnInfo != null ? columnInfo.getColumnSqlName() : null;
    }

    protected String getSpecifiedColumnTableAliasNameAsOne() {
        if (this._specifiedSelectColumnMap != null && this._specifiedSelectColumnMap.size() == 1) {
            return this._specifiedSelectColumnMap.keySet().iterator().next();
        }
        return null;
    }

    protected Map<String, String> getSpecifiedColumnElementMapAsOne() {
        if (this._specifiedSelectColumnMap != null && this._specifiedSelectColumnMap.size() == 1) {
            return this._specifiedSelectColumnMap.values().iterator().next();
        }
        return null;
    }

    @Override
    public void specifyDerivingSubQuery(String aliasName, String deriveSubQuery) {
        if (this._specifiedDerivingSubQueryMap == null) {
            this._specifiedDerivingSubQueryMap = StringKeyMap.createAsFlexibleOrdered();
        }
        this._specifiedDerivingSubQueryMap.put(aliasName, deriveSubQuery);
    }

    @Override
    public boolean hasSpecifiedDerivingSubQuery(String aliasName) {
        return this._specifiedDerivingSubQueryMap != null && this._specifiedDerivingSubQueryMap.containsKey(aliasName);
    }

    @Override
    public List<String> getSpecifiedDerivingAliasList() {
        if (this._specifiedDerivingSubQueryMap == null) {
            List emptyList = Collections.EMPTY_LIST;
            return emptyList;
        }
        return new ArrayList<String>(this._specifiedDerivingSubQueryMap.keySet());
    }

    @Override
    public boolean isCheckInvalidQuery() {
        return this._checkInvalidQuery;
    }

    @Override
    public void checkInvalidQuery() {
        this._checkInvalidQuery = true;
    }

    @Override
    public Map<ColumnRealName, ConditionKey> getInvalidQueryColumnMap() {
        if (this._invalidQueryColumnMap != null) {
            return this._invalidQueryColumnMap;
        }
        return new HashMap<ColumnRealName, ConditionKey>();
    }

    @Override
    public void registerInvalidQueryColumn(ColumnRealName columnRealName, ConditionKey key) {
        if (this._invalidQueryColumnMap == null) {
            this._invalidQueryColumnMap = new LinkedHashMap<ColumnRealName, ConditionKey>();
        }
        this._invalidQueryColumnMap.put(columnRealName, key);
    }

    @Override
    public void addWhereClauseSimpleFilter(QueryClauseFilter whereClauseSimpleFilter) {
        if (this._whereClauseSimpleFilterList == null) {
            this._whereClauseSimpleFilterList = new ArrayList<QueryClauseFilter>();
        }
        this._whereClauseSimpleFilterList.add(whereClauseSimpleFilter);
    }

    protected String filterWhereClauseSimply(String clauseElement) {
        if (this._whereClauseSimpleFilterList == null || this._whereClauseSimpleFilterList.isEmpty()) {
            return clauseElement;
        }
        for (QueryClauseFilter filter : this._whereClauseSimpleFilterList) {
            if (filter == null) {
                String msg = "The list of filter should not have null: _whereClauseSimpleFilterList=" + this._whereClauseSimpleFilterList;
                throw new IllegalStateException(msg);
            }
            clauseElement = filter.filterClauseElement(clauseElement);
        }
        return clauseElement;
    }

    @Override
    public String getClauseQueryUpdate(Map<String, String> columnParameterMap) {
        String msg;
        String subQuery;
        if (columnParameterMap.isEmpty()) {
            return null;
        }
        String aliasName = this.getLocalTableAliasName();
        DBMeta dbmeta = this.getDBMeta();
        TableSqlName tableSqlName = dbmeta.getTableSqlName();
        ColumnSqlName primaryKeyName = dbmeta.getPrimaryUniqueInfo().getFirstColumn().getColumnSqlName();
        String selectClause = "select " + aliasName + "." + primaryKeyName;
        String fromWhereClause = this.getClauseFromWhereWithUnionTemplate();
        fromWhereClause = this.replace(fromWhereClause, this.getUnionSelectClauseMark(), selectClause);
        fromWhereClause = this.replace(fromWhereClause, this.getUnionWhereClauseMark(), "");
        fromWhereClause = this.replace(fromWhereClause, this.getUnionWhereFirstConditionMark(), "");
        StringBuilder sb = new StringBuilder();
        sb.append("update ").append(tableSqlName).append(this.ln());
        int index = 0;
        Set<Map.Entry<String, String>> entrySet = columnParameterMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String columnName = entry.getKey();
            String parameter = entry.getValue();
            ColumnInfo columnInfo = dbmeta.findColumnInfo(columnName);
            ColumnSqlName columnSqlName = columnInfo.getColumnSqlName();
            if (index == 0) {
                sb.append("   set ").append(columnSqlName).append(" = ").append(parameter).append(this.ln());
            } else {
                sb.append("     , ").append(columnSqlName).append(" = ").append(parameter).append(this.ln());
            }
            ++index;
        }
        if (this.isUpdateSubQueryUseLocalTableSupported() && !dbmeta.hasTwoOrMorePrimaryKeys()) {
            subQuery = this.processSubQueryIndent(selectClause + " " + fromWhereClause);
            sb.append(" where ").append(primaryKeyName);
            sb.append(" in (").append(this.ln()).append(subQuery).append(this.ln()).append(")");
            return sb.toString();
        }
        if (this._outerJoinMap != null && !this._outerJoinMap.isEmpty()) {
            msg = "The queryUpdate() with outer join is unavailable";
            msg = msg + " because your DB does not support it or the table has two-or-more primary keys:";
            msg = msg + " tableDbName=" + this.getDBMeta().getTableDbName();
            throw new IllegalConditionBeanOperationException(msg);
        }
        if (this._unionQueryInfoList != null && !this._unionQueryInfoList.isEmpty()) {
            msg = "The queryUpdate() with union is unavailable";
            msg = msg + " because your DB does not support it or the table has two-or-more primary keys:";
            msg = msg + " tableDbName=" + this.getDBMeta().getTableDbName();
            throw new IllegalConditionBeanOperationException(msg);
        }
        subQuery = this.processSubQueryIndent(fromWhereClause);
        subQuery = this.replace(subQuery, aliasName + ".", "");
        int whereIndex = (subQuery = this.replace(subQuery, " " + aliasName + " ", " ")).indexOf("where ");
        if (whereIndex < 0) {
            return sb.toString();
        }
        subQuery = subQuery.substring(whereIndex);
        sb.append(" ").append(subQuery);
        return sb.toString();
    }

    @Override
    public String getClauseQueryDelete() {
        String aliasName = this.getLocalTableAliasName();
        DBMeta dbmeta = this.getDBMeta();
        TableSqlName tableSqlName = dbmeta.getTableSqlName();
        ColumnSqlName primaryKeyName = dbmeta.getPrimaryUniqueInfo().getFirstColumn().getColumnSqlName();
        String selectClause = "select " + aliasName + "." + primaryKeyName;
        String fromWhereClause = this.getClauseFromWhereWithUnionTemplate();
        fromWhereClause = this.replace(fromWhereClause, this.getUnionSelectClauseMark(), selectClause);
        fromWhereClause = this.replace(fromWhereClause, this.getUnionWhereClauseMark(), "");
        fromWhereClause = this.replace(fromWhereClause, this.getUnionWhereFirstConditionMark(), "");
        if (this.isUpdateSubQueryUseLocalTableSupported() && !dbmeta.hasTwoOrMorePrimaryKeys()) {
            String subQuery = this.processSubQueryIndent(selectClause + " " + fromWhereClause);
            StringBuilder sb = new StringBuilder();
            sb.append("delete from ").append(tableSqlName).append(this.ln());
            sb.append(" where ").append(primaryKeyName);
            sb.append(" in (").append(this.ln()).append(subQuery).append(this.ln()).append(")");
            return sb.toString();
        }
        if (this._outerJoinMap != null && !this._outerJoinMap.isEmpty()) {
            String msg = "The queryDelete() with outer join is unavailable";
            msg = msg + " because your DB does not support it or the table has two-or-more primary keys:";
            msg = msg + " tableDbName=" + this.getDBMeta().getTableDbName();
            throw new IllegalConditionBeanOperationException(msg);
        }
        if (this._unionQueryInfoList != null && !this._unionQueryInfoList.isEmpty()) {
            String msg = "The queryDelete() with union is unavailable";
            msg = msg + " because your DB does not support it or the table has two-or-more primary keys:";
            msg = msg + " tableDbName=" + this.getDBMeta().getTableDbName();
            throw new IllegalConditionBeanOperationException(msg);
        }
        String subQuery = this.processSubQueryIndent(fromWhereClause);
        subQuery = this.replace(subQuery, aliasName + ".", "");
        subQuery = this.replace(subQuery, " " + aliasName + " ", " ");
        subQuery = subQuery.substring(subQuery.indexOf("from "));
        return "delete " + subQuery;
    }

    protected boolean isUpdateSubQueryUseLocalTableSupported() {
        return true;
    }

    @Override
    public void classifySelectClauseType(SqlClause.SelectClauseType selectClauseType) {
        this.changeSelectClauseType(selectClauseType);
    }

    protected void changeSelectClauseType(SqlClause.SelectClauseType selectClauseType) {
        this.savePreviousSelectClauseType();
        this._selectClauseType = selectClauseType;
    }

    protected void savePreviousSelectClauseType() {
        this._previousSelectClauseType = this._selectClauseType;
    }

    @Override
    public void rollbackSelectClauseType() {
        this._selectClauseType = this._previousSelectClauseType != null ? this._previousSelectClauseType : DEFAULT_SELECT_CLAUSE_TYPE;
    }

    @Override
    public HpCBPurpose getPurpose() {
        return this._purpose;
    }

    @Override
    public void setPurpose(HpCBPurpose purpose) {
        this._purpose = purpose;
    }

    @Override
    public int getInScopeLimit() {
        return 0;
    }

    protected DBMeta getDBMeta() {
        if (this._dbmeta == null) {
            String msg = "The DB meta of local table should not be null when using getDBMeta():";
            msg = msg + " tableDbName=" + this._tableDbName;
            throw new IllegalStateException(msg);
        }
        return this._dbmeta;
    }

    protected DBMeta findDBMeta(String tableDbName) {
        DBMeta dbmeta = this._cachedDBMetaMap.get(tableDbName);
        if (dbmeta != null) {
            return dbmeta;
        }
        if (this._dbmetaProvider == null) {
            String msg = "The DB meta provider should not be null when using findDBMeta():";
            msg = msg + " tableDbName=" + tableDbName;
            throw new IllegalStateException(msg);
        }
        dbmeta = this._dbmetaProvider.provideDBMetaChecked(tableDbName);
        this._cachedDBMetaMap.put(tableDbName, dbmeta);
        return dbmeta;
    }

    protected ColumnInfo toColumnInfo(String tableDbName, String columnDbName) {
        return this.findDBMeta(tableDbName).findColumnInfo(columnDbName);
    }

    protected ColumnSqlName toColumnSqlName(String tableDbName, String columnDbName) {
        return this.toColumnInfo(tableDbName, columnDbName).getColumnSqlName();
    }

    protected String buildSpaceBar(int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    protected String replace(String text, String fromText, String toText) {
        return Srl.replace(text, fromText, toText);
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        DfAssertUtil.assertObjectNotNull(variableName, value);
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        DfAssertUtil.assertStringNotNullAndNotTrimmedEmpty(variableName, value);
    }

    protected class RownumPagingProcessor {
        protected String _rownumExpression;
        protected String _selectHint = "";
        protected String _sqlSuffix = "";
        protected Integer _pagingBindFrom;
        protected Integer _pagingBindTo;
        protected boolean _bind;

        public RownumPagingProcessor(String rownumExpression) {
            this._rownumExpression = rownumExpression;
        }

        public void useBindVariable() {
            this._bind = true;
        }

        public void processRowNumberPaging() {
            String exp;
            boolean offset = AbstractSqlClause.this.isFetchStartIndexSupported();
            boolean limit = AbstractSqlClause.this.isFetchSizeSupported();
            if (!offset && !limit) {
                return;
            }
            StringBuilder hintSb = new StringBuilder();
            String rownum = this._rownumExpression;
            hintSb.append(" *").append(AbstractSqlClause.this.ln());
            hintSb.append("  from (").append(AbstractSqlClause.this.ln());
            hintSb.append("select plain.*, ").append(rownum).append(" as rn").append(AbstractSqlClause.this.ln());
            hintSb.append("  from (").append(AbstractSqlClause.this.ln());
            hintSb.append("select");
            StringBuilder suffixSb = new StringBuilder();
            String fromEnd = "       ) plain" + AbstractSqlClause.this.ln() + "       ) ext" + AbstractSqlClause.this.ln();
            if (offset) {
                int pageStartIndex = AbstractSqlClause.this.getPageStartIndex();
                this._pagingBindFrom = pageStartIndex;
                exp = this._bind ? "/*pmb.sqlClause.pagingBindFrom*/" : String.valueOf(pageStartIndex);
                suffixSb.append(fromEnd).append(" where ext.rn > ").append(exp);
            }
            if (limit) {
                int pageEndIndex = AbstractSqlClause.this.getPageEndIndex();
                this._pagingBindTo = pageEndIndex;
                String string = exp = this._bind ? "/*pmb.sqlClause.pagingBindTo*/" : String.valueOf(pageEndIndex);
                if (offset) {
                    suffixSb.append(AbstractSqlClause.this.ln()).append("   and ext.rn <= ").append(exp);
                } else {
                    suffixSb.append(fromEnd).append(" where ext.rn <= ").append(exp);
                }
            }
            this._selectHint = hintSb.toString();
            this._sqlSuffix = suffixSb.toString();
        }

        public String getSelectHint() {
            return this._selectHint;
        }

        public String getSqlSuffix() {
            return this._sqlSuffix;
        }

        public Integer getPagingBindFrom() {
            return this._pagingBindFrom;
        }

        public Integer getPagingBindTo() {
            return this._pagingBindTo;
        }
    }

    protected static class UnionQueryInfo {
        protected String _unionQueryClause;
        protected boolean _unionAll;

        protected UnionQueryInfo() {
        }

        public String getUnionQueryClause() {
            return this._unionQueryClause;
        }

        public void setUnionQueryClause(String unionQueryClause) {
            this._unionQueryClause = unionQueryClause;
        }

        public boolean isUnionAll() {
            return this._unionAll;
        }

        public void setUnionAll(boolean unionAll) {
            this._unionAll = unionAll;
        }
    }
}

