/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.sqlclause.subquery;

import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.cbean.sqlclause.subquery.AbstractSubQuery;
import org.seasar.dbflute.cbean.sqlclause.subquery.SubQueryLevelReflector;
import org.seasar.dbflute.cbean.sqlclause.subquery.SubQueryPath;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.name.ColumnRealName;
import org.seasar.dbflute.dbmeta.name.ColumnRealNameProvider;
import org.seasar.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.dbflute.dbmeta.name.ColumnSqlNameProvider;
import org.seasar.dbflute.exception.IllegalConditionBeanOperationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalarCondition
extends AbstractSubQuery {
    protected final String _mainSubQueryIdentity;
    protected final String _operand;

    public ScalarCondition(SqlClause sqlClause, SubQueryPath subQueryPath, ColumnRealNameProvider localRealNameProvider, ColumnSqlNameProvider subQuerySqlNameProvider, int subQueryLevel, SqlClause subQueryClause, SubQueryLevelReflector reflector, String subQueryIdentity, DBMeta subQueryDBMeta, String mainSubQueryIdentity, String operand) {
        super(sqlClause, subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQueryClause, reflector, subQueryIdentity, subQueryDBMeta);
        this._mainSubQueryIdentity = mainSubQueryIdentity;
        this._operand = operand;
    }

    public String buildScalarCondition(String function) {
        this.reflectLocalSubQueryLevel();
        String columnDbName = this._subQueryClause.getSpecifiedColumnDbNameAsOne();
        if (columnDbName == null || columnDbName.trim().length() == 0) {
            this.throwScalarConditionInvalidColumnSpecificationException(function);
        }
        ColumnRealName columnRealName = this._localRealNameProvider.provide(columnDbName);
        String subQueryClause = this.getSubQueryClause(function);
        String beginMark = this._sqlClause.resolveSubQueryBeginMark(this._subQueryIdentity) + this.ln();
        String endMark = this._sqlClause.resolveSubQueryEndMark(this._subQueryIdentity);
        String endIndent = "       ";
        return columnRealName + " " + this._operand + " (" + beginMark + subQueryClause + this.ln() + "       " + ") " + endMark;
    }

    protected String getSubQueryClause(String function) {
        if (!this._subQueryDBMeta.hasPrimaryKey() || this._subQueryDBMeta.hasTwoOrMorePrimaryKeys()) {
            String msg = "The scalar-condition is unsupported when no primary key or two-or-more primary keys:";
            msg = msg + " table=" + this._subQueryDBMeta.getTableDbName();
            throw new IllegalConditionBeanOperationException(msg);
        }
        String tableAliasName = "dfsublocal_" + this._subQueryLevel;
        String derivedColumnDbName = this._subQueryClause.getSpecifiedColumnDbNameAsOne();
        if (derivedColumnDbName == null) {
            this.throwScalarConditionInvalidColumnSpecificationException(function);
        }
        ColumnSqlName derivedColumnSqlName = this._subQueryClause.getSpecifiedColumnSqlNameAsOne();
        ColumnRealName derivedColumnRealName = new ColumnRealName(tableAliasName, derivedColumnSqlName);
        this.assertScalarConditionColumnType(function, derivedColumnDbName);
        this._subQueryClause.clearSpecifiedSelectColumn();
        if (this._subQueryClause.hasUnionQuery()) {
            return this.getUnionSubQuerySql(function, tableAliasName, derivedColumnSqlName, derivedColumnRealName);
        }
        String selectClause = "select " + function + "(" + derivedColumnRealName + ")";
        String fromWhereClause = this.buildPlainFromWhereClause(selectClause, tableAliasName);
        return selectClause + " " + fromWhereClause;
    }

    protected String getUnionSubQuerySql(String function, String tableAliasName, ColumnSqlName derivedColumnSqlName, ColumnRealName derivedColumnRealName) {
        String beginMark = this._sqlClause.resolveSubQueryBeginMark(this._mainSubQueryIdentity) + this.ln();
        String endMark = this._sqlClause.resolveSubQueryEndMark(this._mainSubQueryIdentity);
        ColumnSqlName pkSqlName = this._subQueryDBMeta.getPrimaryUniqueInfo().getFirstColumn().getColumnSqlName();
        ColumnRealName pkRealName = new ColumnRealName(tableAliasName, pkSqlName);
        String selectClause = "select " + pkRealName + ", " + derivedColumnRealName;
        String fromWhereClause = this.buildPlainFromWhereClause(selectClause, tableAliasName);
        String mainSql = selectClause + " " + fromWhereClause;
        ColumnRealName mainDerivedColumnRealName = new ColumnRealName("dfsubquerymain", derivedColumnSqlName);
        return "select " + function + "(" + mainDerivedColumnRealName + ")" + this.ln() + "  from (" + beginMark + mainSql + this.ln() + "       ) dfsubquerymain" + endMark;
    }

    protected void throwScalarConditionInvalidColumnSpecificationException(String function) {
        this.createCBExThrower().throwScalarConditionInvalidColumnSpecificationException(function);
    }

    protected void assertScalarConditionColumnType(String function, String derivedColumnDbName) {
        Class<?> deriveColumnType = this._subQueryDBMeta.findColumnInfo(derivedColumnDbName).getPropertyType();
        if (("sum".equalsIgnoreCase(function) || "avg".equalsIgnoreCase(function)) && !Number.class.isAssignableFrom(deriveColumnType)) {
            this.throwScalarConditionUnmatchedColumnTypeException(function, derivedColumnDbName, deriveColumnType);
        }
    }

    protected void throwScalarConditionUnmatchedColumnTypeException(String function, String derivedColumnDbName, Class<?> derivedColumnType) {
        this.createCBExThrower().throwScalarConditionUnmatchedColumnTypeException(function, derivedColumnDbName, derivedColumnType);
    }
}

