/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.sqlclause.subquery;

import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.cbean.sqlclause.subquery.SubQueryPath;
import org.seasar.dbflute.dbmeta.name.ColumnRealName;
import org.seasar.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.dbflute.util.DfSystemUtil;
import org.seasar.dbflute.util.Srl;

public class SubQueryClause {
    protected final SqlClause _sqlClause;
    protected final SubQueryPath _subQueryPath;
    protected final String _selectClause;
    protected final SqlClause _subQueryClause;
    protected final String _tableAliasName;

    public SubQueryClause(SqlClause sqlClause, SubQueryPath subQueryPath, String selectClause, SqlClause subQueryClause, String tableAliasName) {
        this._sqlClause = sqlClause;
        this._subQueryPath = subQueryPath;
        this._selectClause = selectClause;
        this._subQueryClause = subQueryClause;
        this._tableAliasName = tableAliasName;
    }

    public String buildPlainSubQueryFromWhereClause() {
        String fromWhereClause = this._subQueryClause.getClauseFromWhereWithUnionTemplate();
        if (this._tableAliasName != null) {
            fromWhereClause = this.replaceString(fromWhereClause, "dflocal", this._tableAliasName);
        }
        fromWhereClause = this.replaceString(fromWhereClause, ".conditionQuery.", "." + this._subQueryPath + ".");
        SqlClause sc = this._sqlClause;
        fromWhereClause = this.replaceString(fromWhereClause, sc.getUnionSelectClauseMark(), this._selectClause);
        fromWhereClause = this.replaceString(fromWhereClause, sc.getUnionWhereClauseMark(), "");
        fromWhereClause = this.replaceString(fromWhereClause, sc.getUnionWhereFirstConditionMark(), "");
        return fromWhereClause;
    }

    public String buildCorrelationSubQueryFromWhereClause(ColumnSqlName relatedColumnSqlName, ColumnRealName correlatedColumnRealName) {
        String clause = this.xprepareCorrelationSubQueryFromWhereClause();
        String joinCondition = this._tableAliasName + "." + relatedColumnSqlName + " = " + correlatedColumnRealName;
        clause = this.xreplaceCorrelationSubQueryFromWhereClause(clause, joinCondition);
        return clause;
    }

    public String buildCorrelationSubQueryFromWhereClause(ColumnSqlName[] relatedColumnSqlNames, ColumnRealName[] correlatedColumnRealNames) {
        String clause = this.xprepareCorrelationSubQueryFromWhereClause();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < relatedColumnSqlNames.length; ++i) {
            if (sb.length() > 0) {
                sb.append(this.ln()).append("   and ");
            }
            sb.append(this._tableAliasName).append(".").append(relatedColumnSqlNames[i]);
            sb.append(" = ").append(correlatedColumnRealNames[i]);
        }
        String joinCondition = sb.toString();
        clause = this.xreplaceCorrelationSubQueryFromWhereClause(clause, joinCondition);
        return clause;
    }

    protected String xprepareCorrelationSubQueryFromWhereClause() {
        String clause = this._subQueryClause.getClauseFromWhereWithWhereUnionTemplate();
        clause = this.replaceString(clause, "dflocal", this._tableAliasName);
        clause = this.replaceString(clause, ".conditionQuery.", "." + this._subQueryPath + ".");
        return clause;
    }

    protected String xreplaceCorrelationSubQueryFromWhereClause(String clause, String joinCondition) {
        String firstConditionAfter = this.ln() + "   and ";
        SqlClause sc = this._sqlClause;
        clause = this.replaceString(clause, sc.getWhereClauseMark(), "where " + joinCondition);
        clause = this.replaceString(clause, sc.getWhereFirstConditionMark(), joinCondition + firstConditionAfter);
        clause = this.replaceString(clause, sc.getUnionSelectClauseMark(), this._selectClause);
        clause = this.replaceString(clause, sc.getUnionWhereClauseMark(), "where " + joinCondition);
        clause = this.replaceString(clause, sc.getUnionWhereFirstConditionMark(), joinCondition + firstConditionAfter);
        return clause;
    }

    protected final String replaceString(String text, String fromText, String toText) {
        return Srl.replace(text, fromText, toText);
    }

    protected String initCap(String str) {
        return Srl.initCap(str);
    }

    protected String initUncap(String str) {
        return Srl.initUncap(str);
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }
}

