/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.outsidesql;

import org.seasar.dbflute.jdbc.StatementConfig;

public class OutsideSqlOption {
    protected String _pagingRequestType = "non";
    protected boolean _dynamicBinding;
    protected boolean _removeBlockComment;
    protected boolean _removeLineComment;
    protected boolean _formatSql;
    protected StatementConfig _statementConfig;
    protected String _sourcePagingRequestType = "non";
    protected String _tableDbName;

    public void autoPaging() {
        this._pagingRequestType = "auto";
    }

    public void manualPaging() {
        this._pagingRequestType = "manual";
    }

    public void dynamicBinding() {
        this._dynamicBinding = true;
    }

    public void removeBlockComment() {
        this._removeBlockComment = true;
    }

    public void removeLineComment() {
        this._removeLineComment = true;
    }

    public void formatSql() {
        this._formatSql = true;
    }

    public String generateUniqueKey() {
        return "{" + this._pagingRequestType + "/" + this._dynamicBinding + "/" + this._formatSql + "}";
    }

    public OutsideSqlOption copyOptionWithoutPaging() {
        OutsideSqlOption copyOption = new OutsideSqlOption();
        copyOption.setPagingSourceRequestType(this._pagingRequestType);
        if (this.isDynamicBinding()) {
            copyOption.dynamicBinding();
        }
        copyOption.setTableDbName(this._tableDbName);
        return copyOption;
    }

    public String toString() {
        return "{paging=" + this._pagingRequestType + ", dynamic=" + this._dynamicBinding + "}";
    }

    public boolean isAutoPaging() {
        return "auto".equals(this._pagingRequestType);
    }

    public boolean isManualPaging() {
        return "manual".equals(this._pagingRequestType);
    }

    public boolean isDynamicBinding() {
        return this._dynamicBinding;
    }

    public boolean isRemoveBlockComment() {
        return this._removeBlockComment;
    }

    public boolean isRemoveLineComment() {
        return this._removeLineComment;
    }

    public boolean isFormatSql() {
        return this._formatSql;
    }

    public StatementConfig getStatementConfig() {
        return this._statementConfig;
    }

    public void setStatementConfig(StatementConfig statementConfig) {
        this._statementConfig = statementConfig;
    }

    protected void setPagingSourceRequestType(String sourcePagingRequestType) {
        this._sourcePagingRequestType = sourcePagingRequestType;
    }

    public boolean isSourcePagingRequestTypeAuto() {
        return "auto".equals(this._sourcePagingRequestType);
    }

    public String getTableDbName() {
        return this._tableDbName;
    }

    public void setTableDbName(String tableDbName) {
        this._tableDbName = tableDbName;
    }
}

