/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.valuetype.plugin;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.dbflute.s2dao.valuetype.plugin.BytesType;
import org.seasar.dbflute.util.DfSystemUtil;

public class BytesOidType
extends BytesType {
    public BytesOidType() {
        super(new TnBytesOidTrait());
    }

    protected static class TnBytesOidImpl
    implements Blob {
        protected byte[] _bytes;

        public TnBytesOidImpl(byte[] bytes) {
            this._bytes = bytes;
        }

        public void free() throws SQLException {
            throw new UnsupportedOperationException("free()");
        }

        public InputStream getBinaryStream() throws SQLException {
            return new ByteArrayInputStream(this._bytes);
        }

        public InputStream getBinaryStream(long pos, long length) throws SQLException {
            throw new UnsupportedOperationException("getBinaryStream(pos, length)");
        }

        public byte[] getBytes(long pos, int length) throws SQLException {
            if (length == this._bytes.length) {
                return this._bytes;
            }
            byte[] result = new byte[length];
            DfSystemUtil.arraycopy(this._bytes, 0, result, 0, length);
            return result;
        }

        public long length() throws SQLException {
            return this._bytes.length;
        }

        public long position(Blob pattern, long start) throws SQLException {
            throw new UnsupportedOperationException("position");
        }

        public long position(byte[] pattern, long start) throws SQLException {
            throw new UnsupportedOperationException("position");
        }

        public OutputStream setBinaryStream(long pos) throws SQLException {
            throw new UnsupportedOperationException("setBinaryStream");
        }

        public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
            throw new UnsupportedOperationException("setBytes");
        }

        public int setBytes(long pos, byte[] bytes) throws SQLException {
            throw new UnsupportedOperationException("setBytes");
        }

        public void truncate(long len) throws SQLException {
            throw new UnsupportedOperationException("truncate");
        }
    }

    protected static class TnBytesOidTrait
    implements BytesType.Trait {
        protected TnBytesOidTrait() {
        }

        public int getSqlType() {
            return 2004;
        }

        public void set(PreparedStatement ps, int parameterIndex, byte[] bytes) throws SQLException {
            ps.setBlob(parameterIndex, this.createBytesOidImpl(bytes));
        }

        protected Blob createBytesOidImpl(byte[] bytes) {
            return new TnBytesOidImpl(bytes);
        }

        public void set(CallableStatement cs, String parameterName, byte[] bytes) throws SQLException {
            cs.setBytes(parameterName, bytes);
        }

        public byte[] get(ResultSet rs, int columnIndex) throws SQLException {
            return BytesType.toBytes(rs.getBlob(columnIndex));
        }

        public byte[] get(ResultSet rs, String columnName) throws SQLException {
            return BytesType.toBytes(rs.getBlob(columnName));
        }

        public byte[] get(CallableStatement cs, int columnIndex) throws SQLException {
            return BytesType.toBytes(cs.getBlob(columnIndex));
        }

        public byte[] get(CallableStatement cs, String columnName) throws SQLException {
            return BytesType.toBytes(cs.getBlob(columnName));
        }
    }
}

