/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import jp.sf.orangesignal.csv.CsvConfig;
import jp.sf.orangesignal.csv.CsvToken;

public class CsvWriter
implements Closeable,
Flushable {
    private Writer out;
    private CsvConfig cfg;
    private boolean utf8bom;
    private static int defaultCharBufferSize = 8192;

    public CsvWriter(Writer out, int sz, CsvConfig cfg) {
        if (cfg == null) {
            throw new IllegalArgumentException("CsvConfig must not be null");
        }
        cfg.validate();
        this.out = new BufferedWriter(out, sz);
        this.cfg = cfg;
        if (cfg.isUtf8bomPolicy()) {
            String s = out instanceof OutputStreamWriter ? ((OutputStreamWriter)out).getEncoding() : Charset.defaultCharset().name();
            this.utf8bom = s.toLowerCase().matches("^utf\\-{0,1}8$");
        }
    }

    public CsvWriter(Writer out, CsvConfig cfg) {
        this(out, defaultCharBufferSize, cfg);
    }

    public CsvWriter(Writer out, int sz) {
        this(out, sz, new CsvConfig());
    }

    public CsvWriter(Writer out) {
        this(out, defaultCharBufferSize, new CsvConfig());
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeValues(List<String> values) throws IOException {
        Writer writer = this.out;
        synchronized (writer) {
            this.ensureOpen();
            if (this.utf8bom) {
                this.out.write(65279);
                this.utf8bom = false;
            }
            StringBuilder buf = new StringBuilder();
            if (values != null) {
                int max = values.size();
                for (int i = 0; i < max; ++i) {
                    String s;
                    if (i > 0) {
                        buf.append(this.cfg.getSeparator());
                    }
                    String value = values.get(i);
                    boolean enclose = false;
                    if (value == null) {
                        if (this.cfg.getNullString() == null) continue;
                        value = this.cfg.getNullString();
                    } else if (!this.cfg.isQuoteDisabled()) {
                        switch (this.cfg.getQuotePolicy()) {
                            case ALL: {
                                enclose = true;
                                break;
                            }
                            default: {
                                enclose = value.indexOf(this.cfg.getSeparator()) != -1 || value.indexOf(this.cfg.getQuote()) != -1 || value.indexOf(13) != -1 || value.indexOf(10) != -1;
                                break;
                            }
                        }
                    } else {
                        s = this.escapeSeparator(value);
                        if (!value.equals(s) && this.cfg.isEscapeDisabled()) {
                            throw new IOException();
                        }
                        value = s;
                    }
                    if (enclose) {
                        buf.append(this.cfg.getQuote());
                        s = this.escapeQuote(value);
                        if (!value.equals(s) && this.cfg.isEscapeDisabled()) {
                            throw new IOException();
                        }
                        buf.append(s);
                        buf.append(this.cfg.getQuote());
                        continue;
                    }
                    buf.append(value);
                }
            }
            if (values != null || !this.cfg.isIgnoreEmptyLines()) {
                buf.append(this.cfg.getLineSeparator());
                this.out.write(buf.toString());
            }
        }
    }

    public void writeTokens(List<CsvToken> tokens) throws IOException {
        if (tokens != null) {
            ArrayList<String> values = new ArrayList<String>(tokens.size());
            for (CsvToken token : tokens) {
                if (token == null) {
                    values.add(null);
                    continue;
                }
                values.add(token.getValue());
            }
            this.writeValues(values);
        } else {
            this.writeValues(null);
        }
    }

    private String escapeSeparator(String value) {
        return value.replace(new StringBuilder(1).append(this.cfg.getSeparator()), new StringBuilder(2).append(this.cfg.getEscape()).append(this.cfg.getSeparator()));
    }

    private String escapeQuote(String value) {
        return value.replace(new StringBuilder(1).append(this.cfg.getQuote()), new StringBuilder(2).append(this.cfg.getEscape()).append(this.cfg.getQuote()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Writer writer = this.out;
        synchronized (writer) {
            this.ensureOpen();
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Writer writer = this.out;
        synchronized (writer) {
            if (this.out != null) {
                this.out.close();
                this.out = null;
                this.cfg = null;
            }
        }
    }
}

