/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.ip.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.mobylet.core.Carrier;
import org.mobylet.core.config.MobyletConfig;
import org.mobylet.core.ip.IpAddress;
import org.mobylet.core.ip.IpAddressList;
import org.mobylet.core.ip.IpTextReader;
import org.mobylet.core.log.MobyletLogger;
import org.mobylet.core.util.ResourceUtils;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;

public class IpTextReaderImpl
implements IpTextReader {
    private static final String EXTENSION = "EXTENSION";
    private static final String SUFIX = ".txt";
    protected Map<Carrier, IpAddressList> ipMap;

    public IpTextReaderImpl() {
        this.initialize();
    }

    @Override
    public IpAddressList getIpAddressList(Carrier carrier) {
        return this.ipMap.get((Object)carrier);
    }

    protected void initialize() {
        this.ipMap = new HashMap<Carrier, IpAddressList>();
        IpAddressList extensionIpList = this.readIpText(EXTENSION);
        this.putIpList(Carrier.DOCOMO, extensionIpList);
        this.putIpList(Carrier.AU, extensionIpList);
        this.putIpList(Carrier.SOFTBANK, extensionIpList);
    }

    protected void putIpList(Carrier carrier, IpAddressList extensionList) {
        IpAddressList ipList = this.readIpText(carrier.name());
        ipList.addAll(extensionList);
        this.ipMap.put(carrier, ipList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IpAddressList readIpText(String type) {
        IpAddressList ipList = new IpAddressList();
        if (StringUtils.isEmpty(type)) {
            return ipList;
        }
        MobyletConfig config = SingletonUtils.get(MobyletConfig.class);
        String path = config.getIpDir() + type + SUFIX;
        MobyletLogger logger = SingletonUtils.get(MobyletLogger.class);
        if (logger != null && logger.isLoggable()) {
            logger.log("[mobylet] " + path + " \u306e\u8aad\u307f\u8fbc\u307f\u51e6\u7406\u958b\u59cb");
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(ResourceUtils.getResourceFileOrInputStream(path), "utf-8"));
            String line = null;
            int count = 0;
            while ((line = reader.readLine()) != null) {
                if (!StringUtils.isNotEmpty(line) || line.startsWith("#")) continue;
                ipList.add(new IpAddress(line.trim()));
                ++count;
            }
            if (logger != null && logger.isLoggable()) {
                logger.log("[mobylet] " + path + " \u304c\u8aad\u307f\u8fbc\u307e\u308c\u307e\u3057\u305f - IP\u30a2\u30c9\u30ec\u30b9\u5e2f\u57df\u6570 = " + count);
            }
        }
        catch (UnsupportedEncodingException e) {
            if (logger != null && logger.isLoggable()) {
                logger.log("[mobylet] \u6587\u5b57\u30b3\u30fc\u30c9[utf-8]\u304c\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
            }
        }
        catch (Exception e) {
            if (logger != null && logger.isLoggable()) {
                logger.log("[mobylet] IP\u30a2\u30c9\u30ec\u30b9\u30c6\u30ad\u30b9\u30c8 [" + path + "]\u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093");
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return ipList;
    }
}

