/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.Transformer;
import org.apache.solr.handler.dataimport.VariableResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberFormatTransformer
extends Transformer {
    private static final Pattern localeRegex = Pattern.compile("^([a-z]{2})-([A-Z]{2})$");
    public static final String FORMAT_STYLE = "formatStyle";
    public static final String LOCALE = "locale";
    public static final String NUMBER = "number";
    public static final String PERCENT = "percent";
    public static final String INTEGER = "integer";
    public static final String CURRENCY = "currency";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object transformRow(Map<String, Object> row, Context context) {
        VariableResolver resolver = context.getVariableResolver();
        for (Map<String, String> fld : context.getAllEntityFields()) {
            String style = resolver.replaceTokens(fld.get(FORMAT_STYLE));
            if (style == null) continue;
            String column = fld.get("column");
            String srcCol = fld.get("sourceColName");
            Locale locale = null;
            String localeStr = resolver.replaceTokens(fld.get(LOCALE));
            if (srcCol == null) {
                srcCol = column;
            }
            if (localeStr != null) {
                Matcher matcher = localeRegex.matcher(localeStr);
                if (!matcher.find() || matcher.groupCount() != 2) throw new DataImportHandlerException(500, "Invalid Locale specified for field: " + fld);
                locale = new Locale(matcher.group(1), matcher.group(2));
            } else {
                locale = Locale.getDefault();
            }
            Object val = row.get(srcCol);
            String styleSmall = style.toLowerCase();
            if (val instanceof List) {
                List inputs = (List)val;
                ArrayList<Number> results = new ArrayList<Number>();
                for (String input : inputs) {
                    try {
                        results.add(this.process(input, styleSmall, locale));
                    }
                    catch (ParseException e) {
                        throw new DataImportHandlerException(500, "Failed to apply NumberFormat on column: " + column, e);
                    }
                }
                row.put(column, results);
                continue;
            }
            if (val == null || val.toString().trim().equals("")) continue;
            try {
                row.put(column, this.process(val.toString(), styleSmall, locale));
            }
            catch (ParseException e) {
                throw new DataImportHandlerException(500, "Failed to apply NumberFormat on column: " + column, e);
            }
        }
        return row;
    }

    private Number process(String val, String style, Locale locale) throws ParseException {
        if (INTEGER.equals(style)) {
            return this.parseNumber(val, NumberFormat.getIntegerInstance(locale));
        }
        if (NUMBER.equals(style)) {
            return this.parseNumber(val, NumberFormat.getNumberInstance(locale));
        }
        if (CURRENCY.equals(style)) {
            return this.parseNumber(val, NumberFormat.getCurrencyInstance(locale));
        }
        if (PERCENT.equals(style)) {
            return this.parseNumber(val, NumberFormat.getPercentInstance(locale));
        }
        return null;
    }

    private Number parseNumber(String val, NumberFormat numFormat) throws ParseException {
        ParsePosition parsePos = new ParsePosition(0);
        Number num = numFormat.parse(val, parsePos);
        if (parsePos.getIndex() != val.length()) {
            throw new ParseException("illegal number format", parsePos.getIndex());
        }
        return num;
    }
}

