/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrInfoMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxMonitoredMap<K, V>
extends ConcurrentHashMap<String, SolrInfoMBean> {
    private static final Logger LOG = LoggerFactory.getLogger((String)JmxMonitoredMap.class.getName());
    private MBeanServer server = null;
    private String jmxRootName;

    public JmxMonitoredMap(String coreName, SolrConfig.JmxConfiguration jmxConfig) {
        this.jmxRootName = "solr" + (coreName == null ? "" : "/" + coreName);
        if (jmxConfig.agentId != null && jmxConfig.serviceUrl != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Incorrect JMX Configuration in solrconfig.xml, both agentId and serviceUrl cannot be specified at the same time");
        }
        if (jmxConfig.serviceUrl == null) {
            ArrayList<MBeanServer> servers = null;
            if (jmxConfig.agentId == null) {
                servers = MBeanServerFactory.findMBeanServer(null);
            } else if (jmxConfig.agentId != null && ((servers = MBeanServerFactory.findMBeanServer(jmxConfig.agentId)) == null || servers.isEmpty())) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No JMX Servers found with agentId: " + jmxConfig.agentId);
            }
            if (servers == null || servers.isEmpty()) {
                LOG.info("No JMX servers found, not exposing Solr information with JMX.");
                return;
            }
            this.server = (MBeanServer)servers.get(0);
            LOG.info("JMX monitoring is enabled. Adding Solr mbeans to JMX Server: " + this.server);
        } else {
            try {
                this.server = MBeanServerFactory.newMBeanServer();
                JMXConnectorServer connector = JMXConnectorServerFactory.newJMXConnectorServer(new JMXServiceURL(jmxConfig.serviceUrl), null, this.server);
                connector.start();
                LOG.info("JMX monitoring is enabled at " + jmxConfig.serviceUrl);
            }
            catch (Exception e) {
                this.server = null;
                throw new RuntimeException("Could not start JMX monitoring ", e);
            }
        }
    }

    @Override
    public void clear() {
        if (this.server != null) {
            for (Map.Entry entry : this.entrySet()) {
                this.unregister((String)entry.getKey(), (SolrInfoMBean)entry.getValue());
            }
        }
        super.clear();
    }

    @Override
    public SolrInfoMBean put(String key, SolrInfoMBean infoBean) {
        if (this.server != null && infoBean != null) {
            try {
                ObjectName name = this.getObjectName(key, infoBean);
                if (this.server.isRegistered(name)) {
                    this.server.unregisterMBean(name);
                }
                SolrDynamicMBean mbean = new SolrDynamicMBean(infoBean);
                this.server.registerMBean(mbean, name);
            }
            catch (Exception e) {
                LOG.warn("Failed to register info bean: " + key, (Throwable)e);
            }
        }
        return super.put(key, infoBean);
    }

    @Override
    public SolrInfoMBean remove(Object key) {
        SolrInfoMBean infoBean = (SolrInfoMBean)this.get(key);
        if (infoBean != null) {
            try {
                this.unregister((String)key, infoBean);
            }
            catch (RuntimeException e) {
                LOG.warn("Failed to unregister info bean: " + key, (Throwable)e);
            }
        }
        return (SolrInfoMBean)super.remove(key);
    }

    private void unregister(String key, SolrInfoMBean infoBean) {
        if (this.server == null) {
            return;
        }
        try {
            ObjectName name = this.getObjectName(key, infoBean);
            if (this.server.isRegistered(name)) {
                this.server.unregisterMBean(name);
            } else {
                LOG.info("Failed to unregister mbean: " + key + " because it was not registered");
            }
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to unregister info bean: " + key, (Throwable)e);
        }
    }

    private ObjectName getObjectName(String key, SolrInfoMBean infoBean) throws MalformedObjectNameException {
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("type", key);
        if (infoBean.getName() != null && !"".equals(infoBean.getName())) {
            map.put("id", infoBean.getName());
        }
        return ObjectName.getInstance(this.jmxRootName, map);
    }

    static class SolrDynamicMBean
    implements DynamicMBean {
        private SolrInfoMBean infoBean;
        private HashSet<String> staticStats;

        public SolrDynamicMBean(SolrInfoMBean managedResource) {
            this.infoBean = managedResource;
            this.staticStats = new HashSet();
            this.staticStats.add("name");
            this.staticStats.add("version");
            this.staticStats.add("description");
            this.staticStats.add("category");
            this.staticStats.add("sourceId");
            this.staticStats.add("source");
        }

        public MBeanInfo getMBeanInfo() {
            ArrayList<MBeanAttributeInfo> attrInfoList = new ArrayList<MBeanAttributeInfo>();
            for (String stat : this.staticStats) {
                attrInfoList.add(new MBeanAttributeInfo(stat, String.class.getName(), null, true, false, false));
            }
            try {
                NamedList dynamicStats = this.infoBean.getStatistics();
                if (dynamicStats != null) {
                    for (int i = 0; i < dynamicStats.size(); ++i) {
                        String name = dynamicStats.getName(i);
                        if (this.staticStats.contains(name)) continue;
                        attrInfoList.add(new MBeanAttributeInfo(dynamicStats.getName(i), String.class.getName(), null, true, false, false));
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Could not getStatistics on info bean " + this.infoBean.getName(), (Throwable)e);
            }
            MBeanAttributeInfo[] attrInfoArr = attrInfoList.toArray(new MBeanAttributeInfo[attrInfoList.size()]);
            return new MBeanInfo(this.getClass().getName(), this.infoBean.getDescription(), attrInfoArr, null, null, null);
        }

        public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
            Object val;
            if (this.staticStats.contains(attribute) && attribute != null && attribute.length() > 0) {
                try {
                    String getter = "get" + attribute.substring(0, 1).toUpperCase() + attribute.substring(1);
                    Method meth = this.infoBean.getClass().getMethod(getter, new Class[0]);
                    val = meth.invoke((Object)this.infoBean, new Object[0]);
                }
                catch (Exception e) {
                    throw new AttributeNotFoundException(attribute);
                }
            } else {
                NamedList list = this.infoBean.getStatistics();
                val = list.get(attribute);
            }
            if (val != null) {
                return val.toString();
            }
            return val;
        }

        public AttributeList getAttributes(String[] attributes) {
            AttributeList list = new AttributeList();
            for (String attribute : attributes) {
                try {
                    list.add(new Attribute(attribute, this.getAttribute(attribute)));
                }
                catch (Exception e) {
                    LOG.warn("Could not get attibute " + attribute);
                }
            }
            return list;
        }

        public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
            throw new UnsupportedOperationException("Operation not Supported");
        }

        public AttributeList setAttributes(AttributeList attributes) {
            throw new UnsupportedOperationException("Operation not Supported");
        }

        public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
            throw new UnsupportedOperationException("Operation not Supported");
        }
    }
}

