/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.handler.ContentStreamLoader;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;

public abstract class ContentStreamHandlerBase
extends RequestHandlerBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrParams params = req.getParams();
        UpdateRequestProcessorChain processorChain = req.getCore().getUpdateProcessingChain(params.get("update.processor"));
        UpdateRequestProcessor processor = processorChain.createProcessor(req, rsp);
        try {
            ContentStreamLoader documentLoader = this.newLoader(req, processor);
            Iterable<ContentStream> streams = req.getContentStreams();
            if (streams == null) {
                if (!RequestHandlerUtils.handleCommit(processor, params, false) && !RequestHandlerUtils.handleRollback(processor, params, false)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing content stream");
                }
            } else {
                for (ContentStream stream : streams) {
                    documentLoader.load(req, rsp, stream);
                }
                RequestHandlerUtils.handleCommit(processor, params, false);
                RequestHandlerUtils.handleRollback(processor, params, false);
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            processor.finish();
            throw throwable;
        }
        processor.finish();
    }

    protected abstract ContentStreamLoader newLoader(SolrQueryRequest var1, UpdateRequestProcessor var2);
}

