/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import org.apache.poi.util.LittleEndian;

public final class SectionDescriptor {
    private short fn;
    private int fc;
    private short fnMpr;
    private int fcMpr;

    public SectionDescriptor() {
    }

    public SectionDescriptor(byte[] buf, int offset) {
        this.fn = LittleEndian.getShort((byte[])buf, (int)offset);
        this.fc = LittleEndian.getInt((byte[])buf, (int)(offset += 2));
        this.fnMpr = LittleEndian.getShort((byte[])buf, (int)(offset += 4));
        this.fcMpr = LittleEndian.getInt((byte[])buf, (int)(offset += 2));
    }

    public int getFc() {
        return this.fc;
    }

    public void setFc(int fc) {
        this.fc = fc;
    }

    public boolean equals(Object o) {
        SectionDescriptor sed = (SectionDescriptor)o;
        return sed.fn == this.fn && sed.fnMpr == this.fnMpr;
    }

    public byte[] toByteArray() {
        int offset = 0;
        byte[] buf = new byte[12];
        LittleEndian.putShort((byte[])buf, (int)offset, (short)this.fn);
        LittleEndian.putInt((byte[])buf, (int)(offset += 2), (int)this.fc);
        LittleEndian.putShort((byte[])buf, (int)(offset += 4), (short)this.fnMpr);
        LittleEndian.putInt((byte[])buf, (int)(offset += 2), (int)this.fcMpr);
        return buf;
    }
}

