/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.util.StringHelper;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.StrField;
import org.apache.solr.util.BoundedTreeSet;

public class TermsComponent
extends SearchComponent {
    public static final int UNLIMITED_MAX_COUNT = -1;

    public void process(ResponseBuilder rb) throws IOException {
        SolrParams params = rb.req.getParams();
        if (params.getBool("terms", false)) {
            String lowerStr = params.get("terms.lower", null);
            String[] fields = params.getParams("terms.fl");
            if (fields != null && fields.length > 0) {
                NamedList terms = new NamedList();
                rb.rsp.add("terms", terms);
                int limit = params.getInt("terms.limit", 10);
                if (limit < 0) {
                    limit = Integer.MAX_VALUE;
                }
                String upperStr = params.get("terms.upper");
                boolean upperIncl = params.getBool("terms.upper.incl", false);
                boolean lowerIncl = params.getBool("terms.lower.incl", true);
                boolean sort = !"index".equals(params.get("terms.sort", "count"));
                int freqmin = params.getInt("terms.mincount", 1);
                int freqmax = params.getInt("terms.maxcount", -1);
                if (freqmax < 0) {
                    freqmax = Integer.MAX_VALUE;
                }
                String prefix = params.get("terms.prefix");
                boolean raw = params.getBool("terms.raw", false);
                block0: for (int j = 0; j < fields.length; ++j) {
                    Term theTerm;
                    String lower;
                    FieldType ft;
                    String field = StringHelper.intern((String)fields[j]);
                    FieldType fieldType = ft = raw ? null : rb.req.getSchema().getFieldTypeNoEx(field);
                    if (ft == null) {
                        ft = new StrField();
                    }
                    String string = lowerStr == null ? prefix : (lower = raw ? lowerStr : ft.toInternal(lowerStr));
                    if (lower == null) {
                        lower = "";
                    }
                    String upper = upperStr == null ? null : (raw ? upperStr : ft.toInternal(upperStr));
                    Term lowerTerm = new Term(field, lower);
                    Term upperTerm = upper == null ? null : new Term(field, upper);
                    TermEnum termEnum = rb.req.getSearcher().getReader().terms(lowerTerm);
                    int i = 0;
                    BoundedTreeSet<SimpleFacets.CountPair<String, Integer>> queue = sort ? new BoundedTreeSet<SimpleFacets.CountPair<String, Integer>>(limit) : null;
                    NamedList fieldTerms = new NamedList();
                    terms.add(field, (Object)fieldTerms);
                    Term lowerTestTerm = termEnum.term();
                    if (lowerTestTerm != null && !lowerIncl && lowerTestTerm.field() == field && lowerTestTerm.text().equals(lower)) {
                        termEnum.next();
                    }
                    while ((i < limit || sort) && (theTerm = termEnum.term()) != null && field == theTerm.field()) {
                        int upperCmp;
                        String string2 = theTerm.text();
                        if (prefix != null && !string2.startsWith(prefix) || upperTerm != null && ((upperCmp = theTerm.compareTo(upperTerm)) > 0 || upperCmp == 0 && !upperIncl)) break;
                        int docFreq = termEnum.docFreq();
                        if (docFreq >= freqmin && docFreq <= freqmax) {
                            String label;
                            String string3 = label = raw ? string2 : ft.indexedToReadable(string2);
                            if (sort) {
                                queue.add(new SimpleFacets.CountPair<String, Integer>(label, docFreq));
                            } else {
                                fieldTerms.add(label, (Object)docFreq);
                                ++i;
                            }
                        }
                        termEnum.next();
                    }
                    termEnum.close();
                    if (!sort) continue;
                    for (SimpleFacets.CountPair countPair : queue) {
                        if (i >= limit) continue block0;
                        fieldTerms.add((String)countPair.key, countPair.val);
                        ++i;
                    }
                }
            } else {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No terms.fl parameter specified");
            }
        }
    }

    public void prepare(ResponseBuilder rb) throws IOException {
    }

    public String getVersion() {
        return "$Revision: 807289 $";
    }

    public String getSourceId() {
        return "$Id: TermsComponent.java 807289 2009-08-24 15:56:32Z yonik $";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.4/src/java/org/apache/solr/handler/component/TermsComponent.java $";
    }

    public String getDescription() {
        return "A Component for working with Term Enumerators";
    }
}

