/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.plugin;

import java.util.ArrayList;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.DOMUtil;
import org.apache.solr.core.SolrConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPluginLoader<T> {
    public static Logger log = LoggerFactory.getLogger(AbstractPluginLoader.class);
    private final String type;
    private final boolean preRegister;
    private final boolean requireName;

    public AbstractPluginLoader(String type, boolean preRegister, boolean requireName) {
        this.type = type;
        this.preRegister = preRegister;
        this.requireName = requireName;
    }

    public AbstractPluginLoader(String type) {
        this(type, false, true);
    }

    protected String[] getDefaultPackages() {
        return new String[0];
    }

    protected T create(ResourceLoader loader, String name, String className, Node node) throws Exception {
        return (T)loader.newInstance(className, this.getDefaultPackages());
    }

    protected abstract T register(String var1, T var2) throws Exception;

    protected abstract void init(T var1, Node var2) throws Exception;

    public T load(ResourceLoader loader, NodeList nodes) {
        ArrayList<PluginInitInfo> info = new ArrayList<PluginInitInfo>();
        T defaultPlugin = null;
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                try {
                    String name = DOMUtil.getAttr((Node)node, (String)"name", (String)(this.requireName ? this.type : null));
                    String className = DOMUtil.getAttr((Node)node, (String)"class", (String)this.type);
                    String defaultStr = DOMUtil.getAttr((Node)node, (String)"default", null);
                    T plugin = this.create(loader, name, className, node);
                    log.info("created " + name + ": " + plugin.getClass().getName());
                    if (this.preRegister) {
                        info.add(new PluginInitInfo(plugin, node));
                    } else {
                        this.init(plugin, node);
                    }
                    T old = this.register(name, plugin);
                    if (old != null && (name != null || this.requireName)) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Multiple " + this.type + " registered to the same name: " + name + " ignoring: " + old);
                    }
                    if (defaultStr == null || !Boolean.parseBoolean(defaultStr)) continue;
                    if (defaultPlugin != null) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Multiple default " + this.type + " plugins: " + defaultPlugin + " AND " + name);
                    }
                    defaultPlugin = plugin;
                    continue;
                }
                catch (Exception e) {
                    SolrConfig.severeErrors.add(e);
                    SolrException.logOnce((Logger)log, null, (Throwable)e);
                }
            }
        }
        for (PluginInitInfo pinfo : info) {
            try {
                this.init(pinfo.plugin, pinfo.node);
            }
            catch (Exception ex) {
                SolrConfig.severeErrors.add(ex);
                SolrException.logOnce((Logger)log, null, (Throwable)ex);
            }
        }
        return defaultPlugin;
    }

    public T loadSingle(ResourceLoader loader, Node node) {
        ArrayList<PluginInitInfo> info = new ArrayList<PluginInitInfo>();
        Object plugin = null;
        try {
            String name = DOMUtil.getAttr((Node)node, (String)"name", (String)(this.requireName ? this.type : null));
            String className = DOMUtil.getAttr((Node)node, (String)"class", (String)this.type);
            plugin = this.create(loader, name, className, node);
            log.info("created " + name + ": " + plugin.getClass().getName());
            if (this.preRegister) {
                info.add(new PluginInitInfo(plugin, node));
            } else {
                this.init(plugin, node);
            }
            Object old = this.register(name, plugin);
            if (old != null && (name != null || this.requireName)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Multiple " + this.type + " registered to the same name: " + name + " ignoring: " + old);
            }
        }
        catch (Exception e) {
            SolrConfig.severeErrors.add(e);
            SolrException.logOnce((Logger)log, null, (Throwable)e);
        }
        for (PluginInitInfo pinfo : info) {
            try {
                this.init(pinfo.plugin, pinfo.node);
            }
            catch (Exception ex) {
                SolrConfig.severeErrors.add(ex);
                SolrException.logOnce((Logger)log, null, (Throwable)ex);
            }
        }
        return (T)plugin;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PluginInitInfo {
        final T plugin;
        final Node node;

        PluginInitInfo(T plugin, Node node) {
            this.plugin = plugin;
            this.node = node;
        }
    }
}

