/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.db.allcommon;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.robot.db.allcommon.DBFluteConfig;
import org.seasar.robot.dbflute.cbean.ConditionBeanContext;
import org.seasar.robot.dbflute.s2dao.extension.TnSqlLogRegistry;
import org.seasar.robot.dbflute.util.DfSystemUtil;

public class DBFluteInitializer {
    private static final Log _log = LogFactory.getLog(DBFluteInitializer.class);

    public DBFluteInitializer() {
        _log.info((Object)"...Initializing DBFlute components!");
        this.handleSqlLogRegistry();
        this.loadCoolClasses();
        DBFluteConfig.getInstance().lock();
    }

    protected void handleSqlLogRegistry() {
        if (DBFluteConfig.getInstance().isUseSqlLogRegistry()) {
            StringBuilder sb = new StringBuilder();
            sb.append("{SqlLog Information}").append(this.getLineSeparator());
            sb.append("  [SqlLogRegistry]").append(this.getLineSeparator());
            if (TnSqlLogRegistry.setupSqlLogRegistry()) {
                sb.append("    ...Setting up sqlLogRegistry(org.seasar.extension.jdbc)!").append(this.getLineSeparator());
                sb.append("    Because the property 'useSqlLogRegistry' of the config of DBFlute is true.");
            } else {
                sb.append("    The sqlLogRegistry(org.seasar.extension.jdbc) is not supported at the version!");
            }
            _log.info((Object)sb);
        } else {
            Object sqlLogRegistry = TnSqlLogRegistry.findContainerSqlLogRegistry();
            if (sqlLogRegistry != null) {
                TnSqlLogRegistry.closeRegistration();
            }
        }
    }

    protected void loadCoolClasses() {
        ConditionBeanContext.loadCoolClasses();
    }

    protected String getLineSeparator() {
        return DfSystemUtil.getLineSeparator();
    }
}

