/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.util;

import java.nio.charset.Charset;

public class UrlDecoder {
    private static final String HEX = "0123456789abcdefABCDEF";

    public static String decode(String s, Charset charset) {
        boolean needToChange = false;
        int numChars = s.length();
        StringBuilder buf = new StringBuilder(numChars > 500 ? numChars / 2 : numChars);
        int i = 0;
        byte[] bytes = null;
        block6: while (i < numChars) {
            int c = s.charAt(i);
            switch (c) {
                case 43: {
                    buf.append(' ');
                    ++i;
                    needToChange = true;
                    continue block6;
                }
                case 37: {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i) / 2];
                        }
                        int pos = 0;
                        while (c == 37 && i + 1 < numChars) {
                            if (HEX.indexOf(s.charAt(i + 1)) >= 0) {
                                int index = 2;
                                if (i + 2 < numChars && HEX.indexOf(s.charAt(i + 2)) >= 0) {
                                    index = 3;
                                }
                                bytes[pos] = (byte)Integer.parseInt(s.substring(i + 1, i + index), 16);
                                ++pos;
                                if ((i += index) >= numChars || (c = s.charAt(i)) == 37) continue;
                                if (c == 43) {
                                    c = 32;
                                }
                                bytes[pos] = (byte)c;
                                ++pos;
                                if (++i >= numChars) continue;
                                c = s.charAt(i);
                                continue;
                            }
                            bytes[pos] = (byte)c;
                            ++pos;
                            if (++i >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == 37) {
                            throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern i = " + i + "[" + s + "]");
                        }
                        buf.append(new String(bytes, 0, pos, charset));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - " + e.getMessage());
                    }
                    needToChange = true;
                    continue block6;
                }
            }
            buf.append((char)c);
            ++i;
        }
        return needToChange ? buf.toString() : s;
    }
}

