/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot;

import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.RobotCrawlAccessException;
import org.seasar.robot.S2RobotContext;
import org.seasar.robot.client.S2RobotClient;
import org.seasar.robot.client.S2RobotClientFactory;
import org.seasar.robot.client.fs.ChildUrlsException;
import org.seasar.robot.entity.ResponseData;
import org.seasar.robot.entity.UrlQueue;
import org.seasar.robot.helper.LogHelper;
import org.seasar.robot.log.LogType;
import org.seasar.robot.processor.ResponseProcessor;
import org.seasar.robot.rule.Rule;
import org.seasar.robot.service.DataService;
import org.seasar.robot.service.UrlQueueService;
import org.seasar.robot.util.CrawlingParameterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S2RobotThread
implements Runnable {
    @Resource
    protected UrlQueueService urlQueueService;
    @Resource
    protected DataService dataService;
    @Resource
    protected S2Container container;
    @Binding(bindingType=BindingType.MAY)
    @Resource
    protected LogHelper logHelper;
    protected S2RobotClientFactory clientFactory;
    protected S2RobotContext robotContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startCrawling() {
        Object object = this.robotContext.activeThreadCountLock;
        synchronized (object) {
            S2RobotContext s2RobotContext = this.robotContext;
            Integer n = s2RobotContext.activeThreadCount;
            Integer n2 = s2RobotContext.activeThreadCount = Integer.valueOf(s2RobotContext.activeThreadCount + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishCrawling() {
        Object object = this.robotContext.activeThreadCountLock;
        synchronized (object) {
            S2RobotContext s2RobotContext = this.robotContext;
            Integer n = s2RobotContext.activeThreadCount;
            Integer n2 = s2RobotContext.activeThreadCount = Integer.valueOf(s2RobotContext.activeThreadCount - 1);
        }
    }

    protected boolean isContinue(int tcCount) {
        if (!SingletonS2ContainerFactory.hasContainer()) {
            return false;
        }
        boolean isContinue = false;
        if (tcCount < this.robotContext.maxThreadCheckCount) {
            if (this.robotContext.maxAccessCount > 0L && this.robotContext.accessCount >= this.robotContext.maxAccessCount) {
                return false;
            }
            isContinue = true;
        }
        if (!isContinue && this.robotContext.activeThreadCount > 0) {
            return true;
        }
        return isContinue;
    }

    protected void log(LogHelper logHelper, LogType key, Object ... objs) {
        if (logHelper != null) {
            logHelper.log(key, objs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.log(this.logHelper, LogType.START_THREAD, this.robotContext);
        int threadCheckCount = 0;
        CrawlingParameterUtil.setRobotContext(this.robotContext);
        CrawlingParameterUtil.setUrlQueueService(this.urlQueueService);
        CrawlingParameterUtil.setDataService(this.dataService);
        try {
            while (this.robotContext.running && this.isContinue(threadCheckCount)) {
                block35: {
                    UrlQueue urlQueue = this.urlQueueService.poll(this.robotContext.sessionId);
                    if (this.isValid(urlQueue)) {
                        Object var12_13;
                        ResponseData responseData;
                        block34: {
                            block32: {
                                block33: {
                                    responseData = null;
                                    this.log(this.logHelper, LogType.START_CRAWLING, this.robotContext, urlQueue);
                                    try {
                                        try {
                                            boolean contentUpdated;
                                            S2RobotClient client = this.getClient(urlQueue.getUrl());
                                            if (client == null) {
                                                this.log(this.logHelper, LogType.UNSUPPORTED_URL_AT_CRAWLING_STARTED, this.robotContext, urlQueue);
                                                var12_13 = null;
                                                if (responseData == null) break block32;
                                                break block33;
                                            }
                                            this.startCrawling();
                                            CrawlingParameterUtil.setUrlQueue(urlQueue);
                                            if (this.robotContext.intervalController != null) {
                                                this.robotContext.intervalController.delay(1);
                                            }
                                            if (contentUpdated = this.isContentUpdated(client, urlQueue)) {
                                                this.log(this.logHelper, LogType.GET_CONTENT, this.robotContext, urlQueue);
                                                long startTime = System.currentTimeMillis();
                                                responseData = client.doGet(urlQueue.getUrl());
                                                responseData.setExecutionTime(System.currentTimeMillis() - startTime);
                                                responseData.setParentUrl(urlQueue.getParentUrl());
                                                responseData.setSessionId(this.robotContext.sessionId);
                                                if (responseData.getRedirectLocation() == null) {
                                                    this.log(this.logHelper, LogType.PROCESS_RESPONSE, this.robotContext, urlQueue, responseData);
                                                    this.processResponse(urlQueue, responseData);
                                                } else {
                                                    this.log(this.logHelper, LogType.REDIRECT_LOCATION, this.robotContext, urlQueue, responseData);
                                                    Object object = this.robotContext.accessCountLock;
                                                    synchronized (object) {
                                                        this.storeChildUrl(responseData.getRedirectLocation(), urlQueue.getUrl(), urlQueue.getDepth() == null ? 1 : urlQueue.getDepth() + 1);
                                                    }
                                                }
                                            }
                                            this.log(this.logHelper, LogType.FINISHED_CRAWLING, this.robotContext, urlQueue);
                                            break block34;
                                        }
                                        catch (ChildUrlsException e) {
                                            Set<String> childUrlSet = e.getChildUrlList();
                                            this.log(this.logHelper, LogType.PROCESS_CHILD_URLS_BY_EXCEPTION, this.robotContext, urlQueue, childUrlSet);
                                            Object object = this.robotContext.accessCountLock;
                                            synchronized (object) {
                                                this.storeChildUrls(childUrlSet, urlQueue.getUrl(), urlQueue.getDepth() == null ? 1 : urlQueue.getDepth() + 1);
                                            }
                                            var12_13 = null;
                                            if (responseData != null) {
                                                IOUtils.closeQuietly((InputStream)responseData.getResponseBody());
                                            }
                                            if (this.robotContext.intervalController != null) {
                                                this.robotContext.intervalController.delay(2);
                                            }
                                            threadCheckCount = 0;
                                            CrawlingParameterUtil.setUrlQueue(null);
                                            this.finishCrawling();
                                            break block35;
                                        }
                                        catch (RobotCrawlAccessException e) {
                                            this.log(this.logHelper, LogType.CRAWLING_ACCESS_EXCEPTION, this.robotContext, urlQueue, e);
                                            var12_13 = null;
                                            if (responseData != null) {
                                                IOUtils.closeQuietly((InputStream)responseData.getResponseBody());
                                            }
                                            if (this.robotContext.intervalController != null) {
                                                this.robotContext.intervalController.delay(2);
                                            }
                                            threadCheckCount = 0;
                                            CrawlingParameterUtil.setUrlQueue(null);
                                            this.finishCrawling();
                                            break block35;
                                        }
                                        catch (Throwable e) {
                                            this.log(this.logHelper, LogType.CRAWLING_EXCETPION, this.robotContext, urlQueue, e);
                                            var12_13 = null;
                                            if (responseData != null) {
                                                IOUtils.closeQuietly((InputStream)responseData.getResponseBody());
                                            }
                                            if (this.robotContext.intervalController != null) {
                                                this.robotContext.intervalController.delay(2);
                                            }
                                            threadCheckCount = 0;
                                            CrawlingParameterUtil.setUrlQueue(null);
                                            this.finishCrawling();
                                            break block35;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        var12_13 = null;
                                        if (responseData != null) {
                                            IOUtils.closeQuietly((InputStream)responseData.getResponseBody());
                                        }
                                        if (this.robotContext.intervalController != null) {
                                            this.robotContext.intervalController.delay(2);
                                        }
                                        threadCheckCount = 0;
                                        CrawlingParameterUtil.setUrlQueue(null);
                                        this.finishCrawling();
                                        throw throwable;
                                    }
                                }
                                IOUtils.closeQuietly((InputStream)responseData.getResponseBody());
                            }
                            if (this.robotContext.intervalController != null) {
                                this.robotContext.intervalController.delay(2);
                            }
                            threadCheckCount = 0;
                            CrawlingParameterUtil.setUrlQueue(null);
                            this.finishCrawling();
                            continue;
                        }
                        var12_13 = null;
                        if (responseData != null) {
                            IOUtils.closeQuietly((InputStream)responseData.getResponseBody());
                        }
                        if (this.robotContext.intervalController != null) {
                            this.robotContext.intervalController.delay(2);
                        }
                        threadCheckCount = 0;
                        CrawlingParameterUtil.setUrlQueue(null);
                        this.finishCrawling();
                    } else {
                        this.log(this.logHelper, LogType.NO_URL_IN_QUEUE, this.robotContext, urlQueue, threadCheckCount);
                        if (this.robotContext.intervalController != null) {
                            this.robotContext.intervalController.delay(4);
                        }
                        ++threadCheckCount;
                    }
                }
                if (this.robotContext.intervalController == null) continue;
                this.robotContext.intervalController.delay(8);
            }
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            CrawlingParameterUtil.setRobotContext(null);
            CrawlingParameterUtil.setUrlQueueService(null);
            CrawlingParameterUtil.setDataService(null);
            throw throwable;
        }
        CrawlingParameterUtil.setRobotContext(null);
        CrawlingParameterUtil.setUrlQueueService(null);
        CrawlingParameterUtil.setDataService(null);
        this.log(this.logHelper, LogType.FINISHED_THREAD, this.robotContext);
    }

    protected S2RobotClient getClient(String url) {
        return this.clientFactory.getClient(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isContentUpdated(S2RobotClient client, UrlQueue urlQueue) {
        ResponseData responseData;
        block3: {
            boolean bl;
            if (urlQueue.getLastModified() == null) return true;
            this.log(this.logHelper, LogType.CHECK_LAST_MODIFIED, this.robotContext, urlQueue);
            long startTime = System.currentTimeMillis();
            responseData = null;
            try {
                responseData = client.doHead(urlQueue.getUrl());
                if (responseData == null || responseData.getLastModified().getTime() > urlQueue.getLastModified().getTime() || responseData.getHttpStatusCode() != 200) break block3;
                this.log(this.logHelper, LogType.NOT_MODIFIED, this.robotContext, urlQueue);
                responseData.setExecutionTime(System.currentTimeMillis() - startTime);
                responseData.setParentUrl(urlQueue.getParentUrl());
                responseData.setSessionId(this.robotContext.sessionId);
                responseData.setStatus(304);
                this.processResponse(urlQueue, responseData);
                bl = false;
                Object var8_6 = null;
                if (responseData == null) return bl;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (responseData == null) throw throwable;
                IOUtils.closeQuietly((InputStream)responseData.getResponseBody());
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)responseData.getResponseBody());
            return bl;
        }
        Object var8_7 = null;
        if (responseData == null) return true;
        IOUtils.closeQuietly((InputStream)responseData.getResponseBody());
        return true;
    }

    protected void processResponse(UrlQueue urlQueue, ResponseData responseData) {
        Rule rule = this.robotContext.ruleManager.getRule(responseData);
        if (rule == null) {
            this.log(this.logHelper, LogType.NO_RULE, this.robotContext, urlQueue, responseData);
        } else {
            responseData.setRuleId(rule.getRuleId());
            ResponseProcessor responseProcessor = rule.getResponseProcessor();
            if (responseProcessor == null) {
                this.log(this.logHelper, LogType.NO_RESPONSE_PROCESSOR, this.robotContext, urlQueue, responseData, rule);
            } else {
                responseProcessor.process(responseData);
            }
        }
    }

    protected void storeChildUrls(Set<String> childUrlList, String url, int depth) {
        ArrayList<UrlQueue> childList = new ArrayList<UrlQueue>();
        for (String childUrl : childUrlList) {
            if (!this.robotContext.urlFilter.match(childUrl)) continue;
            UrlQueue uq = (UrlQueue)this.container.getComponent(UrlQueue.class);
            uq.setCreateTime(new Timestamp(System.currentTimeMillis()));
            uq.setDepth(depth);
            uq.setMethod("GET");
            uq.setParentUrl(url);
            uq.setSessionId(this.robotContext.sessionId);
            uq.setUrl(childUrl);
            childList.add(uq);
        }
        this.urlQueueService.offerAll(this.robotContext.sessionId, childList);
    }

    protected void storeChildUrl(String childUrl, String url, int depth) {
        if (this.robotContext.urlFilter.match(childUrl)) {
            ArrayList<UrlQueue> childList = new ArrayList<UrlQueue>(1);
            UrlQueue uq = (UrlQueue)this.container.getComponent(UrlQueue.class);
            uq.setCreateTime(new Timestamp(new Date().getTime()));
            uq.setDepth(depth);
            uq.setMethod("GET");
            uq.setParentUrl(url);
            uq.setSessionId(this.robotContext.sessionId);
            uq.setUrl(childUrl);
            childList.add(uq);
            this.urlQueueService.offerAll(this.robotContext.sessionId, childList);
        }
    }

    protected boolean isValid(UrlQueue urlQueue) {
        if (urlQueue == null) {
            return false;
        }
        if (StringUtil.isBlank((String)urlQueue.getUrl())) {
            return false;
        }
        if (this.robotContext.getMaxDepth() >= 0 && urlQueue.getDepth() > this.robotContext.getMaxDepth()) {
            return false;
        }
        return this.robotContext.urlFilter.match(urlQueue.getUrl());
    }
}

