/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.model.XWPFCommentsDecorator;
import org.apache.poi.xwpf.model.XWPFHeaderFooterPolicy;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFHyperlink;
import org.apache.poi.xwpf.usermodel.XWPFHyperlinkRun;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPicture;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFStyles;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.tika.parser.microsoft.WordExtractor;
import org.apache.tika.parser.microsoft.ooxml.AbstractOOXMLExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBookmark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWPFWordExtractorDecorator
extends AbstractOOXMLExtractor {
    private XWPFDocument document;
    private XWPFStyles styles;

    public XWPFWordExtractorDecorator(XWPFWordExtractor extractor) {
        super((POIXMLTextExtractor)extractor, "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        this.document = (XWPFDocument)extractor.getDocument();
        this.styles = this.document.getStyles();
    }

    @Override
    protected void buildXHTML(XHTMLContentHandler xhtml) throws SAXException, XmlException, IOException {
        XWPFHeaderFooterPolicy hfPolicy = this.document.getHeaderFooterPolicy();
        this.extractHeaders(xhtml, hfPolicy);
        this.extractIBodyText((IBody)this.document, xhtml);
        this.extractFooters(xhtml, hfPolicy);
    }

    private void extractIBodyText(IBody bodyElement, XHTMLContentHandler xhtml) throws SAXException, XmlException, IOException {
        for (IBodyElement element : bodyElement.getBodyElements()) {
            if (element instanceof XWPFParagraph) {
                XWPFParagraph paragraph = (XWPFParagraph)element;
                this.extractParagraph(paragraph, xhtml);
            }
            if (!(element instanceof XWPFTable)) continue;
            XWPFTable table = (XWPFTable)element;
            this.extractTable(table, xhtml);
        }
    }

    private void extractParagraph(XWPFParagraph paragraph, XHTMLContentHandler xhtml) throws SAXException, XmlException, IOException {
        CTSectPr ctSectPr;
        XWPFHeaderFooterPolicy headerFooterPolicy = null;
        if (paragraph.getCTP().getPPr() != null && (ctSectPr = paragraph.getCTP().getPPr().getSectPr()) != null) {
            headerFooterPolicy = new XWPFHeaderFooterPolicy(this.document, ctSectPr);
            this.extractHeaders(xhtml, headerFooterPolicy);
        }
        String tag = "p";
        String styleClass = null;
        if (paragraph.getStyleID() != null) {
            XWPFStyle style = this.styles.getStyle(paragraph.getStyleID());
            WordExtractor.TagAndStyle tas = WordExtractor.buildParagraphTagAndStyle(style.getName(), paragraph.getPartType() == BodyType.TABLECELL);
            tag = tas.getTag();
            styleClass = tas.getStyleClass();
        }
        for (CTBookmark bookmark : paragraph.getCTP().getBookmarkStartList()) {
            xhtml.element("p", bookmark.getName());
        }
        if (styleClass == null) {
            xhtml.startElement(tag);
        } else {
            xhtml.startElement(tag, "class", styleClass);
        }
        for (XWPFRun run : paragraph.getRuns()) {
            XWPFHyperlinkRun linkRun;
            XWPFHyperlink link;
            ArrayList<String> tags = new ArrayList<String>();
            if (run instanceof XWPFHyperlinkRun && (link = (linkRun = (XWPFHyperlinkRun)run).getHyperlink(this.document)) != null && link.getURL() != null) {
                xhtml.startElement("a", "href", link.getURL());
                tags.add("a");
            }
            if (run.isBold()) {
                xhtml.startElement("b");
                tags.add("b");
            }
            if (run.isItalic()) {
                xhtml.startElement("i");
                tags.add("i");
            }
            xhtml.characters(run.toString());
            for (int i = tags.size() - 1; i >= 0; --i) {
                xhtml.endElement((String)tags.get(i));
            }
            for (XWPFPicture picture : run.getEmbeddedPictures()) {
                XWPFPictureData data;
                if (paragraph.getDocument() == null || (data = picture.getPictureData()) == null) continue;
                xhtml.startElement("img", "src", "embedded:" + data.getFileName());
                xhtml.endElement("img");
            }
        }
        XWPFCommentsDecorator comments = new XWPFCommentsDecorator(paragraph, null);
        String commentText = comments.getCommentText();
        if (commentText != null && commentText.length() > 0) {
            xhtml.characters(commentText);
        }
        xhtml.endElement(tag);
        if (headerFooterPolicy != null) {
            this.extractFooters(xhtml, headerFooterPolicy);
        }
    }

    private void extractTable(XWPFTable table, XHTMLContentHandler xhtml) throws SAXException, XmlException, IOException {
        xhtml.startElement("table");
        xhtml.startElement("tbody");
        for (XWPFTableRow row : table.getRows()) {
            xhtml.startElement("tr");
            for (XWPFTableCell cell : row.getTableCells()) {
                xhtml.startElement("td");
                this.extractIBodyText((IBody)cell, xhtml);
                xhtml.endElement("td");
            }
            xhtml.endElement("tr");
        }
        xhtml.endElement("tbody");
        xhtml.endElement("table");
    }

    private void extractFooters(XHTMLContentHandler xhtml, XWPFHeaderFooterPolicy hfPolicy) throws SAXException {
        if (hfPolicy.getFirstPageFooter() != null) {
            xhtml.element("p", hfPolicy.getFirstPageFooter().getText());
        }
        if (hfPolicy.getEvenPageFooter() != null) {
            xhtml.element("p", hfPolicy.getEvenPageFooter().getText());
        }
        if (hfPolicy.getDefaultFooter() != null) {
            xhtml.element("p", hfPolicy.getDefaultFooter().getText());
        }
    }

    private void extractHeaders(XHTMLContentHandler xhtml, XWPFHeaderFooterPolicy hfPolicy) throws SAXException {
        if (hfPolicy.getFirstPageHeader() != null) {
            xhtml.element("p", hfPolicy.getFirstPageHeader().getText());
        }
        if (hfPolicy.getEvenPageHeader() != null) {
            xhtml.element("p", hfPolicy.getEvenPageHeader().getText());
        }
        if (hfPolicy.getDefaultHeader() != null) {
            xhtml.element("p", hfPolicy.getDefaultHeader().getText());
        }
    }

    @Override
    protected List<PackagePart> getMainDocumentParts() {
        ArrayList<PackagePart> parts = new ArrayList<PackagePart>();
        parts.add(this.document.getPackagePart());
        return parts;
    }
}

