/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.s2dao.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.seasar.robot.dbflute.DBDef;
import org.seasar.robot.dbflute.cbean.FetchBean;
import org.seasar.robot.dbflute.cbean.FetchNarrowingBean;
import org.seasar.robot.dbflute.exception.DangerousResultSizeException;
import org.seasar.robot.dbflute.jdbc.PlainResultSetWrapper;
import org.seasar.robot.dbflute.resource.ResourceContext;
import org.seasar.robot.dbflute.resource.SQLExceptionHandler;

public class TnFetchAssistResultSet
extends PlainResultSetWrapper {
    protected final ResultSet _resultSet;
    protected final FetchBean _fetchBean;
    protected final FetchNarrowingBean _fetchNarrowingBean;
    protected final boolean _offsetByCursorForcedly;
    protected final boolean _limitByCursorForcedly;
    protected long _fetchCounter;
    protected long _requestCounter;
    protected boolean _skipToCursorEnd;
    protected final boolean _db2 = ResourceContext.isCurrentDBDef(DBDef.DB2);

    public TnFetchAssistResultSet(ResultSet resultSet, FetchBean fetchBean, boolean offsetByCursorForcedly, boolean limitByCursorForcedly) {
        super(resultSet);
        this._resultSet = resultSet;
        this._fetchBean = fetchBean;
        this._fetchNarrowingBean = fetchBean instanceof FetchNarrowingBean ? (FetchNarrowingBean)fetchBean : null;
        this._offsetByCursorForcedly = offsetByCursorForcedly;
        this._limitByCursorForcedly = limitByCursorForcedly;
        this.skip();
    }

    protected void skip() {
        if (!this.isAvailableSkipRecord()) {
            return;
        }
        int skipStartIndex = this.getFetchNarrowingSkipStartIndex();
        if (this.isScrollableCursor()) {
            try {
                if (0 == skipStartIndex) {
                    this._resultSet.beforeFirst();
                } else {
                    this._resultSet.absolute(skipStartIndex);
                }
                this._fetchCounter = this._resultSet.getRow();
            }
            catch (SQLException e) {
                this.handleSQLException(e, null);
            }
        } else {
            try {
                while (this._fetchCounter < (long)skipStartIndex) {
                    if (!this._resultSet.next()) {
                        this._skipToCursorEnd = true;
                        break;
                    }
                    ++this._fetchCounter;
                }
            }
            catch (SQLException e) {
                this.handleSQLException(e, null);
            }
        }
    }

    protected boolean isAvailableSkipRecord() {
        if (!this.isFetchNarrowingEffective()) {
            return false;
        }
        if (this.isOffsetByCursorForcedly()) {
            return true;
        }
        return this.isFetchNarrowingSkipStartIndexEffective();
    }

    public boolean next() throws SQLException {
        if (this._db2 && this._skipToCursorEnd) {
            return false;
        }
        boolean hasNext = super.next();
        ++this._requestCounter;
        if (!this.isAvailableLimitLoopCount()) {
            this.checkSafetyResultIfNeed(hasNext);
            return hasNext;
        }
        int skipStartIndex = this.getFetchNarrowingSkipStartIndex();
        int loopCount = this.getFetchNarrowingLoopCount();
        if (hasNext && this._fetchCounter < (long)(skipStartIndex + loopCount)) {
            ++this._fetchCounter;
            this.checkSafetyResultIfNeed(true);
            return true;
        }
        return false;
    }

    protected boolean isAvailableLimitLoopCount() {
        if (!this.isFetchNarrowingEffective()) {
            return false;
        }
        if (this.isLimitByCursorForcedly()) {
            return true;
        }
        return this.isFetchNarrowingLoopCountEffective();
    }

    protected void checkSafetyResultIfNeed(boolean hasNext) {
        int safetyMaxResultSize = this.getSafetyMaxResultSize();
        if (hasNext && safetyMaxResultSize > 0 && this._requestCounter > (long)safetyMaxResultSize) {
            String msg = "You've been in Danger Zone:";
            msg = msg + " safetyMaxResultSize=" + safetyMaxResultSize;
            throw new DangerousResultSizeException(msg, safetyMaxResultSize);
        }
    }

    public int getSafetyMaxResultSize() {
        return this._fetchBean.getSafetyMaxResultSize();
    }

    protected boolean isFetchNarrowingEffective() {
        if (this._fetchNarrowingBean == null) {
            return false;
        }
        return this._fetchNarrowingBean.isFetchNarrowingEffective();
    }

    protected boolean isFetchNarrowingSkipStartIndexEffective() {
        if (this._fetchNarrowingBean == null) {
            String msg = "This method should not be called";
            msg = msg + " when isFetchNarrowingEffective() is false!";
            throw new IllegalStateException(msg);
        }
        return this._fetchNarrowingBean.isFetchNarrowingSkipStartIndexEffective();
    }

    protected boolean isFetchNarrowingLoopCountEffective() {
        if (this._fetchNarrowingBean == null) {
            String msg = "This method should not be called";
            msg = msg + " when isFetchNarrowingEffective() is false!";
            throw new IllegalStateException(msg);
        }
        return this._fetchNarrowingBean.isFetchNarrowingLoopCountEffective();
    }

    protected int getFetchNarrowingSkipStartIndex() {
        if (this._fetchNarrowingBean == null) {
            String msg = "This method should not be called";
            msg = msg + " when isFetchNarrowingEffective() is false!";
            throw new IllegalStateException(msg);
        }
        return this._fetchNarrowingBean.getFetchNarrowingSkipStartIndex();
    }

    protected int getFetchNarrowingLoopCount() {
        if (this._fetchNarrowingBean == null) {
            String msg = "This method should not be called";
            msg = msg + " when isFetchNarrowingEffective() is false!";
            throw new IllegalStateException(msg);
        }
        return this._fetchNarrowingBean.getFetchNarrowingLoopCount();
    }

    protected boolean isScrollableCursor() {
        try {
            return this._resultSet.getType() != 1003;
        }
        catch (SQLException e) {
            this.handleSQLException(e, null);
            return false;
        }
    }

    protected void handleSQLException(SQLException e, Statement statement) {
        new SQLExceptionHandler().handleSQLException(e, statement);
    }

    public boolean isOffsetByCursorForcedly() {
        return this._offsetByCursorForcedly;
    }

    public boolean isLimitByCursorForcedly() {
        return this._limitByCursorForcedly;
    }

    public boolean isSkipToCursorEnd() {
        return this._skipToCursorEnd;
    }
}

