/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv.core.command;

import org.seasar.dbflute.bhv.core.SqlExecution;
import org.seasar.dbflute.bhv.core.SqlExecutionCreator;
import org.seasar.dbflute.bhv.core.command.AbstractOutsideSqlCommand;
import org.seasar.dbflute.bhv.core.execution.OutsideSqlSelectExecution;
import org.seasar.dbflute.cbean.FetchAssistContext;
import org.seasar.dbflute.cbean.FetchNarrowingBean;
import org.seasar.dbflute.jdbc.FetchBean;
import org.seasar.dbflute.outsidesql.OutsideSqlContext;
import org.seasar.dbflute.outsidesql.OutsideSqlOption;
import org.seasar.dbflute.s2dao.jdbc.TnResultSetHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOutsideSqlSelectCommand<RESULT>
extends AbstractOutsideSqlCommand<RESULT> {
    @Override
    public boolean isProcedure() {
        return false;
    }

    @Override
    public boolean isSelect() {
        return true;
    }

    @Override
    public void beforeGettingSqlExecution() {
        this.assertStatus("beforeGettingSqlExecution");
        OutsideSqlContext outsideSqlContext = this.createOutsideSqlContext();
        this.setupOutsideSqlContext(outsideSqlContext);
        OutsideSqlContext.setOutsideSqlContextOnThread(outsideSqlContext);
        Object pmb = this._parameterBean;
        OutsideSqlOption option = this._outsideSqlOption;
        this.setupFetchBean(pmb, option);
    }

    protected void setupOutsideSqlContext(OutsideSqlContext outsideSqlContext) {
        String path = this._outsideSqlPath;
        Object pmb = this._parameterBean;
        OutsideSqlOption option = this._outsideSqlOption;
        Class<?> resultType = this.getResultType();
        boolean autoPagingLogging = option.isAutoPaging() || option.isSourcePagingRequestTypeAuto();
        outsideSqlContext.setOutsideSqlPath(path);
        outsideSqlContext.setParameterBean(pmb);
        outsideSqlContext.setResultType(resultType);
        outsideSqlContext.setMethodName(this.getCommandName());
        outsideSqlContext.setStatementConfig(option.getStatementConfig());
        outsideSqlContext.setTableDbName(option.getTableDbName());
        outsideSqlContext.setDynamicBinding(option.isDynamicBinding());
        outsideSqlContext.setOffsetByCursorForcedly(option.isAutoPaging());
        outsideSqlContext.setLimitByCursorForcedly(option.isAutoPaging());
        outsideSqlContext.setAutoPagingLogging(autoPagingLogging);
        outsideSqlContext.setRemoveBlockComment(option.isRemoveBlockComment());
        outsideSqlContext.setRemoveLineComment(option.isRemoveLineComment());
        outsideSqlContext.setFormatSql(option.isFormatSql());
        outsideSqlContext.setupBehaviorQueryPathIfNeeds();
    }

    protected void setupFetchBean(Object pmb, OutsideSqlOption option) {
        if (pmb == null) {
            return;
        }
        if (pmb instanceof FetchBean) {
            FetchAssistContext.setFetchBeanOnThread((FetchBean)pmb);
            if (pmb instanceof FetchNarrowingBean && option.isManualPaging()) {
                ((FetchNarrowingBean)pmb).ignoreFetchNarrowing();
            }
        }
    }

    @Override
    public void afterExecuting() {
    }

    @Override
    public String buildSqlExecutionKey() {
        this.assertStatus("buildSqlExecutionKey");
        return this.generateSpecifiedOutsideSqlUniqueKey();
    }

    protected String generateSpecifiedOutsideSqlUniqueKey() {
        String methodName = this.getCommandName();
        String path = this._outsideSqlPath;
        Object pmb = this._parameterBean;
        OutsideSqlOption option = this._outsideSqlOption;
        Class<?> resultType = this.getResultType();
        return OutsideSqlContext.generateSpecifiedOutsideSqlUniqueKey(methodName, path, pmb, option, resultType);
    }

    @Override
    public SqlExecutionCreator createSqlExecutionCreator() {
        this.assertStatus("createSqlExecutionCreator");
        return new SqlExecutionCreator(){

            public SqlExecution createSqlExecution() {
                OutsideSqlContext outsideSqlContext = OutsideSqlContext.getOutsideSqlContextOnThread();
                return AbstractOutsideSqlSelectCommand.this.createOutsideSqlSelectExecution(outsideSqlContext);
            }
        };
    }

    protected SqlExecution createOutsideSqlSelectExecution(OutsideSqlContext outsideSqlContext) {
        Class[] classArray;
        String[] argNames;
        String[] stringArray;
        String suffix = this.buildDbmsSuffix();
        String sql = outsideSqlContext.readFilteredOutsideSql(this._sqlFileEncoding, suffix);
        Object pmb = outsideSqlContext.getParameterBean();
        if (pmb != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "pmb";
        } else {
            stringArray = argNames = new String[]{};
        }
        if (pmb != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = pmb.getClass();
        } else {
            classArray = new Class[]{};
        }
        Class[] argTypes = classArray;
        TnResultSetHandler handler = this.createOutsideSqlSelectResultSetHandler();
        OutsideSqlSelectExecution execution = this.createOutsideSqlSelectExecution(handler, argNames, argTypes, sql);
        execution.setRemoveBlockComment(this.isRemoveBlockComment(outsideSqlContext));
        execution.setRemoveLineComment(this.isRemoveLineComment(outsideSqlContext));
        execution.setFormatSql(outsideSqlContext.isFormatSql());
        return execution;
    }

    protected OutsideSqlSelectExecution createOutsideSqlSelectExecution(TnResultSetHandler handler, String[] argNames, Class<?>[] argTypes, String sql) {
        OutsideSqlSelectExecution cmd = new OutsideSqlSelectExecution(this._dataSource, this._statementFactory, handler);
        cmd.setArgNames(argNames);
        cmd.setArgTypes(argTypes);
        cmd.setSql(sql);
        return cmd;
    }

    @Override
    public Object[] getSqlExecutionArgument() {
        this.assertStatus("getSqlExecutionArgument");
        return new Object[]{this._parameterBean};
    }

    protected abstract TnResultSetHandler createOutsideSqlSelectResultSetHandler();

    protected abstract Class<?> getResultType();

    protected void assertStatus(String methodName) {
        this.assertBasicProperty(methodName);
        this.assertComponentProperty(methodName);
        this.assertOutsideSqlBasic(methodName);
    }
}

