/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ffplug.rcp.views;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import jp.sourceforge.ffplug.rcp.FPlugin;
import jp.sourceforge.ffplug.rcp.models.data.Constants;
import jp.sourceforge.ffplug.rcp.models.data.DateUtils;
import jp.sourceforge.ffplug.rcp.models.data.FileIOUtils;
import jp.sourceforge.ffplug.rcp.models.table.BeanListTableProvider;
import jp.sourceforge.ffplug.rcp.models.table.BeanViewerSorter;
import jp.sourceforge.ffplug.rcp.models.table.PredicateViewerFilter;
import jp.sourceforge.ffplug.rcp.models.table.SynthPredicate;
import jp.sourceforge.ffplug.rcp.views.dialog.SearchDialog;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WWinActionBars;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.ViewPart;

public class SynthView
extends ViewPart {
    static Logger log;
    private LinkedMap items = new LinkedMap();
    private LinkedMap synths = new LinkedMap();
    private TableViewer viewer;
    private BeanViewerSorter sorter;
    private LinkedMap header;
    private Action refreshAction;
    private Action searchAction;
    private Action clearFilterAction;
    private Action doubleClickAction;
    private String errorMessage;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.ffplug.rcp.views.SynthView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((String)clazz.getName());
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 68352);
        this.sorter = new BeanViewerSorter("itemName");
        this.viewer.setSorter((ViewerSorter)this.sorter);
        this.header = new LinkedMap();
        this.header.put((Object)"item name", (Object)"itemName");
        this.header.put((Object)"crystal", (Object)"crystalName");
        this.header.put((Object)"amount", (Object)"amount");
        this.header.put((Object)"@trial margin", (Object)"marginPerTrial");
        this.header.put((Object)"item price", (Object)"itemMaxPrice");
        this.header.put((Object)"material price", (Object)"materialTotalPrice");
        this.header.put((Object)"skillcap", (Object)"skillCapString");
        this.header.put((Object)"text", (Object)"itemText");
        BeanListTableProvider provider = new BeanListTableProvider(this.header);
        Table table = this.viewer.getTable();
        MapIterator i = provider.getHeader().mapIterator();
        while (i.hasNext()) {
            String colName = (String)i.next();
            TableColumn col = new TableColumn(table, 0);
            col.setText(colName);
            col.pack();
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setBounds(new Rectangle(15, 5, 482, 156));
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)provider);
        this.initializeListener();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        try {
            this.initialLoad();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initialLoad() throws CoreException, IOException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IWorkbenchWindow iw = this.getViewSite().getWorkbenchWindow();
        IWorkbench workbench = iw.getWorkbench();
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)workbench.getActiveWorkbenchWindow();
        WWinActionBars bars = workbenchWindow.getActionBars();
        IStatusLineManager lineManager = bars.getStatusLineManager();
        IProgressMonitor monitor = lineManager.getProgressMonitor();
        this.makeProjectSession(root, monitor);
    }

    private void createSession(IWorkspaceRoot root, IProgressMonitor monitor) throws CoreException, IOException {
        IProject project = root.getProject(Constants.MYPROJECT);
        if (!project.exists()) {
            project.create(monitor);
            project.open(monitor);
        }
        project.refreshLocal(2, monitor);
        IFolder folder = project.getFolder(Constants.MYFOLDER);
        if (folder.exists()) {
            System.out.println("[MyFolder] exists.");
            IFile recipeFile = folder.getFile("recipe.txt");
            IFile itemFile = folder.getFile("item.txt");
            if (recipeFile.exists() && itemFile.exists()) {
                InputStreamReader recipeReader = new InputStreamReader(recipeFile.getContents());
                InputStreamReader itemReader = new InputStreamReader(itemFile.getContents());
                LinkedMap items = FileIOUtils.readItemData(itemReader);
                LinkedMap synths = FileIOUtils.readRecipeData(recipeReader);
                FileIOUtils.fillSynthNameBeans(synths, items);
                project.setSessionProperty(new QualifiedName(null, Constants.SESSION_SYNTH), (Object)synths);
                project.setSessionProperty(new QualifiedName(null, Constants.SESSION_ITEM), (Object)items);
            } else {
                System.out.println("file not found. (recipe.txt or item.txt)");
                this.errorMessage = "\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u66f4\u65b0\u3092\u5b9f\u884c\u3057\u3066\u4e0b\u3055\u3044\u3002";
            }
        } else {
            folder.create(true, true, monitor);
            System.out.println("file not found. (new folder)");
            this.errorMessage = "\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u66f4\u65b0\u3092\u5b9f\u884c\u3057\u3066\u4e0b\u3055\u3044\u3002";
        }
    }

    private void makeProjectSession(IWorkspaceRoot root, IProgressMonitor monitor) throws CoreException, IOException {
        IProject project = root.getProject(Constants.MYPROJECT);
        if (!project.exists()) {
            project.create(monitor);
            project.open(monitor);
        }
        project.refreshLocal(2, monitor);
        IFolder folder = project.getFolder(Constants.MYFOLDER);
        if (folder.exists()) {
            System.out.println("[MyFolder] exists.");
            ArrayList<Date> recipeFileDates = new ArrayList<Date>();
            ArrayList<Date> itemFileDates = new ArrayList<Date>();
            IResource[] resources = folder.members();
            int i = 0;
            while (i < resources.length) {
                if (resources[i] instanceof IFile) {
                    IFile file = (IFile)resources[i];
                    String fileName = file.getName();
                    Date recipeDate = DateUtils.parseDateFilename("recipe", fileName);
                    Date itemDate = DateUtils.parseDateFilename("item", fileName);
                    if (recipeDate != null) {
                        recipeFileDates.add(recipeDate);
                    }
                    if (itemDate != null) {
                        itemFileDates.add(itemDate);
                    }
                }
                ++i;
            }
            Date recipeLatest = DateUtils.latestDate(recipeFileDates);
            Date itemLatest = DateUtils.latestDate(itemFileDates);
            if (recipeLatest == null) {
                System.out.println("file not found. (recipe.txt)");
                this.errorMessage = "\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u66f4\u65b0\u3092\u5b9f\u884c\u3057\u3066\u4e0b\u3055\u3044\u3002";
                return;
            }
            if (itemLatest == null) {
                System.out.println("file not found. (item.txt)");
                this.errorMessage = "\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u66f4\u65b0\u3092\u5b9f\u884c\u3057\u3066\u4e0b\u3055\u3044\u3002";
                return;
            }
            IFile recipeFile = folder.getFile("recipe." + DateUtils.formatDate(recipeLatest) + ".txt");
            IFile itemFile = folder.getFile("item." + DateUtils.formatDate(itemLatest) + ".txt");
            if (recipeFile.exists() && itemFile.exists()) {
                InputStreamReader recipeReader = new InputStreamReader(recipeFile.getContents());
                InputStreamReader itemReader = new InputStreamReader(itemFile.getContents());
                LinkedMap items = FileIOUtils.readItemData(itemReader);
                LinkedMap synths = FileIOUtils.readRecipeData(recipeReader);
                FileIOUtils.fillSynthNameBeans(synths, items);
                IFile priceFile = folder.getFile("price.txt");
                if (priceFile.exists()) {
                    InputStreamReader priceReader = new InputStreamReader(priceFile.getContents());
                    FileIOUtils.addItemPriceBeanFromReader(items, priceReader);
                }
                project.setSessionProperty(new QualifiedName(null, Constants.SESSION_SYNTH), (Object)synths);
                project.setSessionProperty(new QualifiedName(null, Constants.SESSION_ITEM), (Object)items);
                project.setSessionProperty(new QualifiedName(null, Constants.SESSION_VIEWER), (Object)this.viewer);
            } else {
                System.out.println("file not found. (recipe.txt or item.txt)");
                this.errorMessage = "\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u66f4\u65b0\u3092\u5b9f\u884c\u3057\u3066\u4e0b\u3055\u3044\u3002";
            }
        } else {
            folder.create(true, true, monitor);
            System.out.println("file not found. (new folder)");
            this.errorMessage = "\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u66f4\u65b0\u3092\u5b9f\u884c\u3057\u3066\u4e0b\u3055\u3044\u3002";
        }
    }

    private void initializeListener() {
        Table table = this.viewer.getTable();
        int i = 0;
        while (i < table.getColumnCount()) {
            table.getColumn(i).addSelectionListener((SelectionListener)new ColumnSortAdapter(this.viewer, this.header, i));
            ++i;
        }
    }

    private void showStatusbar(String message, boolean error) {
        IWorkbenchWindow iw = this.getViewSite().getWorkbenchWindow();
        IWorkbench workbench = iw.getWorkbench();
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)workbench.getActiveWorkbenchWindow();
        WWinActionBars bars = workbenchWindow.getActionBars();
        IStatusLineManager lineManager = bars.getStatusLineManager();
        if (message != null) {
            if (error) {
                lineManager.setErrorMessage(message);
            } else {
                lineManager.setMessage(message);
            }
        } else {
            lineManager.setMessage("");
        }
    }

    private void resizeColumn(Table table) {
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].pack();
            ++i;
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SynthView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.refreshAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.searchAction);
        manager.add((IAction)this.clearFilterAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.refreshAction);
        manager.add((IAction)this.searchAction);
        manager.add((IAction)this.clearFilterAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.refreshAction);
        manager.add((IAction)this.searchAction);
        manager.add((IAction)this.clearFilterAction);
    }

    private void makeActions() {
        this.refreshAction = new RefreshAction();
        this.refreshAction.setText("reflesh");
        this.refreshAction.setToolTipText("reflesh table input");
        this.refreshAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK"));
        URL urlRefresh = FPlugin.getInstance().find((IPath)new Path("icons/synced.gif"));
        this.refreshAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)urlRefresh));
        this.searchAction = new SearchAction();
        this.searchAction.setText("search");
        this.searchAction.setToolTipText("search tooltip");
        URL urlSearch = FPlugin.getInstance().find((IPath)new Path("icons/search.gif"));
        this.searchAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)urlSearch));
        this.clearFilterAction = new ClearFilterAction();
        this.clearFilterAction.setText("clear filter");
        this.clearFilterAction.setToolTipText("remove all filters");
        URL urlClear = FPlugin.getInstance().find((IPath)new Path("icons/clear_co.gif"));
        this.clearFilterAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)urlClear));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = SynthView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                SynthView.this.showMessage("Double-click detected on " + obj.toString());
            }
        };
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Synth Table", (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
        this.showStatusbar(this.errorMessage, true);
        this.errorMessage = null;
    }

    public void refresh() {
        try {
            this.loadSessionData();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (this.synths != null) {
            this.viewer.setInput((Object)this.synths.values());
            this.resizeColumn(this.viewer.getTable());
            this.viewer.refresh();
        }
    }

    private void loadSessionData() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(Constants.MYPROJECT);
        this.synths = (LinkedMap)project.getSessionProperty(new QualifiedName(null, Constants.SESSION_SYNTH));
        this.items = (LinkedMap)project.getSessionProperty(new QualifiedName(null, Constants.SESSION_ITEM));
    }

    public LinkedMap getItems() {
        return this.items;
    }

    public void setItems(LinkedMap items) {
        this.items = items;
    }

    public LinkedMap getSynths() {
        return this.synths;
    }

    public void setSynths(LinkedMap synths) {
        this.synths = synths;
    }

    private final class SearchAction
    extends Action {
        private SynthPredicate predicate;

        SearchAction() {
        }

        public void run() {
            log.debug((Object)"search action");
            if (this.predicate == null) {
                this.predicate = new SynthPredicate();
            }
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            Shell shell = window.getShell();
            SearchDialog dlg = new SearchDialog(this.predicate, shell);
            int ret = dlg.open();
            System.out.println("\u30b3\u30fc\u30c9 " + ret + " \u3067\u7d42\u4e86\u3057\u307e\u3057\u305f");
            if (ret == 0) {
                SynthView.this.viewer.setInput(null);
                int i = 0;
                while (i < SynthView.this.viewer.getFilters().length) {
                    SynthView.this.viewer.removeFilter(SynthView.this.viewer.getFilters()[i]);
                    ++i;
                }
                this.predicate = dlg.getPredicate();
                SynthView.this.viewer.addFilter((ViewerFilter)new PredicateViewerFilter(this.predicate));
                SynthView.this.viewer.setInput((Object)SynthView.this.synths.values());
                int kind = this.predicate.getKind();
                if (kind >= 0 && kind <= 8) {
                    SynthView.this.viewer.setSorter((ViewerSorter)new BeanViewerSorter("skillCap" + kind));
                }
                SynthView.this.refresh();
            }
            SynthView.this.showStatusbar(SynthView.this.errorMessage, true);
            SynthView.this.errorMessage = null;
        }
    }

    private final class ClearFilterAction
    extends Action {
        ClearFilterAction() {
        }

        public void run() {
            log.debug((Object)"clear filter action");
            int i = 0;
            while (i < SynthView.this.viewer.getFilters().length) {
                SynthView.this.viewer.removeFilter(SynthView.this.viewer.getFilters()[i]);
                ++i;
            }
        }
    }

    private class RefreshAction
    extends Action {
        RefreshAction() {
        }

        public void run() {
            SynthView.this.refresh();
        }
    }

    class ColumnSortAdapter
    implements SelectionListener {
        private TableViewer viewer;
        private LinkedMap header;
        private int column;
        private String key;
        private boolean reverse;

        ColumnSortAdapter(TableViewer viewer, LinkedMap header, int column) {
            this.viewer = viewer;
            this.header = header;
            this.column = column;
            this.key = (String)header.getValue(column);
        }

        public void widgetSelected(SelectionEvent e) {
            this.viewer.setSorter((ViewerSorter)new BeanViewerSorter(this.key, this.reverse));
            this.reverse = !this.reverse;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

