<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.RDF
 */
/**
 * @file Node.php
 * @brief Node.
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: Node.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 */
/**
 * @class Ficus_Node
 */
interface Ficus_Node
{
    /**
     * compare node.
     *
     * @param $node Ficus_Node or string another node.
     * @return int
     */
    public function compare($node);

    /**
     * equals node.
     *
     * @param $node Ficus_Node or string another node.
     * @return boolean return true if equals else return false.
     */
    public function equals($node);

    /**
     * equals by node value.
     *
     * @param $node Ficus_Node or string another node.
     * @return boolean return true if equals else return false.
     */
    public function equalsByValue($node);

    /**
     * toString.
     *
     * @return string Node to string.
     */
    public function toString();

    /**
     * toString.
     *
     * @return string Node to string.
     */
    public function __toString();

}
?>
