<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.beans.annotation
 */
/**
 * @file BeanClassAnnotationAccessor.php
 * @brief class annotation accessor
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: BeanClassAnnotationAccessor.php 2 2007-07-11 10:37:48Z ishitoya $
 */

require_once "ficus/beans/annotation/BeanAnnotationAccessor.php";

/**
 * @class Ficus_BeanClassAnnotationAccessor
 */
class Ficus_BeanClassAnnotationAccessor extends Ficus_BeanAnnotationAccessor{
    /**
     * @var $properties
     */
    private $properties = null;
    
    /**
     * construct with bean
     * @param $bean Ficus_Bean target bean
     */
    public function __construct($annotations){
        parent::__construct($annotations);
    }

    /**
     * set properties annotations
     * @param $property Ficus_BeanPropertyAnnotationAccessor accessor
     */
    public function addProperty($property){
        $property->setDomain($this->getQName());
        $this->properties[$property->getName()] = $property;
    }

    /**
     * get Annotation from name
     * @param $name string annotation name
     * @return string annotation value
     */
    protected function getAnnotation($name){
        if($name == self::T_BRIEF){
            $annotation = $this->annotations->getAnnotation(self::T_BRIEF);
            return $annotation->getBrief();
        }else if($name == self::T_COMMENT){
            $annotation = $this->annotations->getAnnotation(self::T_COMMENT);
            return $annotation->getComment();
        }else if($name == self::T_NAME){
            $annotation = $this->annotations->getAnnotation(self::T_CLASS);
            $class = $annotation->getClass();
            preg_match('/[^_]+_Beans.*_([^_]+)Bean/', $class, $matches);
            return $matches[1];
        }else if($name == self::T_TYPE){
            $annotation = $this->annotations->getAnnotation(self::T_CLASS);
            return $annotation->getClass();
        }else if($name == self::T_COMMENT){
            $annotation = $this->annotations->getAnnotation(self::T_COMMENT);
            return $annotation->getComment();
        }else if($name == self::T_BRIEF){
            $annotation = $this->annotations->getAnnotation(self::T_BRIEF);
            return $annotation->getBrief();
        }else if($name == self::T_DEFINEDBY){
            $annotation = $this->annotations->getAnnotation(self::T_DEFINEDBY);
            return $annotation->getDefinedBy();
        }
    }

    /**
     * type name
     */
    public function getTypename(){
        $classname =
            str_replace(".", "_", strtolower($this->getPackageName()));
        $classname = "{$classname}_" . $this->getName();
        return $classname;
    }

    /**
     * get ClassAnnotation
     * @return Ficus_ReflectionAnnotationClass
     */
    public function getClassAnnotation(){
        return $this->classAnnotation;
    }
    
    /**
     * get property author
     * @return string author of class
     */
    public function getAuthor(){
        $annotation = $this->annotations->getAnnotation(self::T_AUTHOR);
        return $annotation->getAuthor();
    }

    /**
     * get property author
     * @return string author of class
     */
    public function getPackageName(){
        $annotation = $this->annotations->getAnnotation(self::T_PACKAGE);
        return $annotation->getPackage();
    }

    /**
     * get PropertyAnnotations
     * @reuturn array array of Ficus_ReflectionAnnotationProperty
     */
    public function getPropertyAnnotations(){
        return $this->properties;
    }

    /**
     * get Property with name
     * @param $name string name of property
     * @return Ficus_ReflectionAnnotationProperty annotations
     */
    public function getPropertyAnnotation($name){
        return $this->properties[$name];
    }
}
?>
