<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.beans.serializer
 */
/**
 * @file PHPBeanTypeSerializer.php
 * @brief This class will generates Bean source file from Essence.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: PHPBeanSerializer.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 * generates php bean source codes.
 * Templates and tokens are defined in abstract class.
 */

require_once "ficus/beans/serializer/BeanSerializer.php";
require_once "ficus/beans/BeanTemplate.php";

/**
 * @package ficus.beans.serializer
 * @class Ficus_PHPBeanTypeSerializer
 */
class Ficus_PHPBeanSerializer
         implements Ficus_BeanSerializer{

    /** default source code template file name*/
    const DEFAULT_TEMPLATE = "bean_php.tpl";

    /** template name */
    private $templateName = null;

    /**
     * set template name
     * @param $templateName string template name
     */
    public function setTemplateName($templateName){
        $this->templateName = $templateName;
    }
    
    /**
     * Generate Source Code From essences
     * @param $essence array essence of source code
     * @param $template_name string smarty template filename
     * @return string source code
     */
    public function serialize($bean){
        if(is_file($this->templateName) == false){
            $this->templateName = self::DEFAULT_TEMPLATE;
        }

        $template = new Ficus_BeanTemplate();
        $template->assign("bean", $bean);
        $source = $template->fetch($this->templateName);

        return $source;
    }
}
?>
