<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.cli
 */
/**
 * @file CommandLineApplication.php
 * @brief command line application abstract class
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: CommandLineApplication.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 * Command line application
 */

require_once("ficus/cli/CommandLineArgument.php");
require_once("ficus/cli/CommandLineCommand.php");
require_once("ficus/cli/CommandLineManager.php");
require_once("ficus/cli/CommandLineCommandAnnotation.php");

/**
 * @class Soya_CommandLineApplication
 */
abstract class Soya_CommandLineApplication{
    protected $commandManager = null;
    
    protected function __construct(){
        $this->commandManager = new Soya_CommandLineManager($this);
    }

    public function execute($arguments){
        if(count($arguments) == 0){
            $arguments = array();
        }
        $this->commandManager->execute($arguments);
    }

    public function __call($name, $params){
        if(preg_match('/set(.+)/', $name, $regs)){
            $name = $regs[1];
            $name = strtolower($name[0]) . substr($name, 1);
            if(property_exists($this, $name)){
                $this->{$name} = $params[0];
            }else{
                throw new Ficus_PropertyNotFoundException("property $name is not found in " . get_class($this) . ".");
            }
        }
    }

    /**
     * show help
     * @CommandLineCommand(
     *   type    = "Executable",
     *   short   = {?, h},
     *   long    = {help})
     */
    public abstract function help();
    
    /**
     * show version
     * @CommandLineCommand(
     *   type  = "Executable",
     *   short = {V},
     *   long  = {version})
     */
    public abstract function version();
}
?>
