<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.cli.ffmpeg
 */
/**
 * @file FFMpegConvertCodec.php
 * @brief svn add
 * @author <a href="kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: FFMpegConvertCodec.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 * executes ffmpeg abstract class
 */

require_once("ficus/exception/IllegalArgumentException.php");
require_once("ficus/cli/ffmpeg/FFMpeg.php");
require_once("ficus/media/video/VideoBean.php");
require_once("ficus/media/audio/AudioBean.php");


/**
 * @class Ficus_FFMpegConvertCodec
 */
class Ficus_FFMpegConvertCodec extends Ficus_FFMpeg
{
    const DEFAULT_HEIGHT = 240;
    const DEFAULT_WIDTH = 320;
    const DEFAULT_AUDIO_FREQUENCY = 44100;
    const DEFAULT_AUDIO_CHANNELS = 2;
    const DEFAULT_CODEC = Ficus_VideoConstants::CODEC_FLASH;
    
    /**
     * @var $overwrite boolean
     */
    protected $overwrite = false;

    /**
     * @var $output string output filename
     */
    protected $output = null;

    /**
     * @var $width integer width
     */
    protected $width = self::DEFAULT_WIDTH;

    /**
     * @var $height integer height
     */
    protected $height = self::DEFAULT_HEIGHT;

    /**
     * @var $audioFrequency
     */
    protected $audioFrequency = self::DEFAULT_AUDIO_FREQUENCY;

    /**
     * @var $audioChannels
     */
    protected $audioChannels = self::DEFAULT_AUDIO_CHANNELS;

    /**
     * @var $codec
     */
    protected $codec = self::DEFAULT_CODEC;

    /**
     * create command
     * @return string ./ffmpeg -f build.xml
     */
    protected function createCommand(){
        $command = parent::createCommand();
        if($this->isEmptyOutput()){
            throw new Ficus_NotReadyException("output file name is not specified");
        }
        if($this->overwrite){
            $command = $this->addOption($command, self::OVERWRITE);
        }
        $size = $this->getSizeString($this->width, $this->height);
        $command = $this->addOption($command, self::VIDEO_SIZE, $size);
        $command = $this->addOption($command, self::AUDIO_FREQUENCY,
                                    $this->audioFrequency);
        $command = $this->addOption($command, self::AUDIO_CHANNELS,
                                    $this->audioChannels);

        $filename = basename($this->output);
        $filename = dirname($this->output) . "\\" .
            substr($filename, 0, strpos($filename, ".") + 1) .
            $this->codec;
        $command = $this->addOption($command, $filename);
        return $command;
    }

    /**
     * process result
     * @return boolean true if no error
     */
    protected function processResult(){
        $result = $this->getErrorStream();
        if(preg_match('/muxing overhead/', $result)){
            return true;
        }else{
            return false;
        }
    }
}
?>
