<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.cli.subversion
 */
/**
 * @file SVNAdd.php
 * @brief svn add
 * @author <a href="kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: SVNAdd.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 * executes svn add
 */

require_once("ficus/exception/IllegalArgumentException.php");
require_once("ficus/cli/subversion/SVNConstants.php");
require_once("ficus/lang/Runtime.php");
/**
 * @class Ficus_SVNAdd
 */
class Ficus_SVNAdd implements Ficus_SVNConstants
{
    const COMMAND = "add";

    /**
     * @var $fileset array of file to add
     */ 
    private $fileset = array();

    /**
     * execute svn add
     * @return string output of svn add
     */
    public function execute(){
        if(empty($this->fileset)){
            throw new Ficus_IllegalArgumentException("repository is empty");
        }
        $command = $this->createCommand();
        $output = Ficus_Runtime::exec($command);

        $error = $output[Ficus_Runtime::ERROR];
        unset($output[Ficus_Runtime::ERROR]);

        if(empty($error) == false){
            throw new Ficus_IllegalArgumentException("some error occured. message:" . $error);
        }

        return $this->parseResult($output);
    }

    /**
     * add file
     * @param $file string file name
     */
    public function addFile($file){
        $this->fileset[] = $file;
    }

    /**
     * parse result do nothing.
     * @param $output string
     * @return string result.
     */ 
    private function parseResult($output){
        return $output;
    }

    /**
     * create command
     * @return string command
     */
    private function createCommand(){
        $command = self::SVN . " ";
        $command .= self::COMMAND . " ";
        foreach($this->fileset as $file){
            $command .= $file . " ";
        }
        return $command;
    }
}
?>
