<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.crypto
 */
/**
 * @file Key.php
 * @brief key
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: Key.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 *
 */

require_once("ficus/crypto/CryptoConstants.php");

/**
 * @class Ficus_Key
 */
class Ficus_Key implements Ficus_CryptoConstants
{
    /**
     * @var string algorithm
     */
    protected $algorithm = null;
    /**
     * @var string key
     */
    protected $key = null;

    /**
     * constructor
     * @param $algorithm string algorithm
     * @param $key generated key
     */
    public function __construct($algorithm, $key){
        $this->algorithm = $algorithm;
        $this->key = $key;
    }

    /**
     * get algorithm
     * @return string algorithm
     */
    public function getAlgorithm(){
        return $this->algorithm;
    }
    
    /**
     * get raw key
     * @return string raw key
     */
    public function getRaw(){
        return $this->key;
    }

    /**
     * get encoded key
     * @return string encoded key
     */
    public function getEncoded(){
        return $this->getRaw();
    }

    /**
     * to string
     * @return string string form of key
     */
    public function __toString(){
        return $this->getEncoded();
    }
}
?>
