<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.lang
 */
/**
 * @file S2ContainerAutoLoad.php
 * @brief define s2container __autoload class
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: S2ContainerAutoLoad.php 2 2007-07-11 10:37:48Z ishitoya $
 */

require_once("ficus/lang/AutoLoad.php");
require_once("s2container.php5/S2Container.php");

/**
 * @class Ficus_S2ContainerAutoLoad
 */
class Ficus_S2ContainerAutoLoad extends Ficus_AutoLoad{
    /**
     * constructor
     */
    public function __construct(){
        S2ContainerClassLoader::import(S2CONTAINER_PHP5);
    }
    /**
     * abstract autoload
     * @param $classname string class name to load
     * @return boolean true if load succeeded
     */
    protected function load($classname){
        return S2ContainerClassLoader::load($classname);
    }
}
?>
