<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * PHP Version 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license/3_0.txt.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   PHP
 * @package      Ficus_ReflectionAnnotation
 * @author     Sebastian Bergmann <sb@sebastian-bergmann.de>
 * @copyright  2005 Sebastian Bergmann <sb@sebastian-bergmann.de>
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id: ReflectionAnnotationAnnotatedElement.php 2 2007-07-11 10:37:48Z ishitoya $
 * @link       http://pear.php.net/package/  Ficus_ReflectionAnnotation
 * @since      File available since Release 1.0.0
 */

/**
 * Represents an annotated element of the program currently running.
 *
 * @category   PHP
 * @package      Ficus_ReflectionAnnotation
 * @author     Sebastian Bergmann <sb@sebastian-bergmann.de>
 * @copyright  2005 Sebastian Bergmann <sb@sebastian-bergmann.de>
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    Release: @package_version@
 * @link       http://pear.php.net/package/  Ficus_ReflectionAnnotation
 * @since      Interface available since Release 1.0.0
 */
interface   Ficus_ReflectionAnnotationAnnotatedElement {
    /**
     * Returns the annotations.
     *
     * @return   Ficus_ReflectionAnnotation[]
     * @access public
     */
    public function getAnnotations();

    /**
     * Returns annotation by name.
     *
     * @param  String $name
     * @return   Ficus_ReflectionAnnotation
     * @access public
     */
    public function getAnnotation($name);

    /**
     * Returns wether an annotation exists or not.
     *
     * @param  String $name
     * @return boolean
     * @access public
     */
    public function hasAnnotation($name);
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>
